/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.CodeLens;
import org.junit.jupiter.api.Test;

public class XSDCodeLensExtensionsTest {
    @Test
    public void codeLensOnGroupAndElement() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" />\r\n\t<xs:complexType name=\"aComplexType\" >\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element ref=\"xs:elt\" />\r\n\t\t\t<xs:group ref=\"xs:elt\"></xs:group>\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>\r\n\t<xs:element name=\"elt2\" substitutionGroup=\"xs:elt\" />\r\n\r\n\t<xs:group name=\"elt\" >\r\n\t\t<xs:sequence></xs:sequence>\r\n\t</xs:group>\r\n\t\r\n</xs:schema>";
        XMLAssert.testCodeLensFor(xml, XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "http://www.w3.org/2001/XMLSchema (with embedded xml.xsd)", "xml.open.uri"), XMLAssert.cl(XMLAssert.r(2, 13, 2, 23), "2 references", "xml.show.references"), XMLAssert.cl(XMLAssert.r(11, 11, 11, 21), "1 reference", "xml.show.references"));
    }

    @Test
    public void codeLensOnComplexTypeAndSimpleType() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" type=\"xs:aComplexType\" />\r\n\t<xs:complexType name=\"aComplexType\">\r\n\t\t<xs:simpleContent>\r\n\t\t\t<xs:extension base=\"xs:aSimpleTypeA\"></xs:extension>\r\n\t\t</xs:simpleContent>\r\n\t</xs:complexType>\r\n\t\r\n\t<xs:complexType name=\"aComplexType2\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"xs:aComplexType\"></xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n\r\n\t<xs:simpleType name=\"aSimpleTypeA\">\r\n\t\t<xs:restriction base=\"xs:ENTITIES\">\r\n\t\t</xs:restriction>\r\n\t</xs:simpleType>\r\n</xs:schema>";
        XMLAssert.testCodeLensFor(xml, XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "http://www.w3.org/2001/XMLSchema (with embedded xml.xsd)", "xml.open.uri"), XMLAssert.cl(XMLAssert.r(3, 17, 3, 36), "2 references", "xml.show.references"), XMLAssert.cl(XMLAssert.r(15, 16, 15, 35), "1 reference", "xml.show.references"));
    }

    @Test
    public void codeLensEmptyDocument() throws BadLocationException {
        String xml = "";
        XMLAssert.testCodeLensFor(xml, new CodeLens[0]);
    }

    @Test
    public void codeLensSpace() throws BadLocationException {
        String xml = " ";
        XMLAssert.testCodeLensFor(xml, new CodeLens[0]);
    }
}

