/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.XMLFoldingSettings;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeCapabilities;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLFoldingsTest {
    @Test
    public void testFoldOneLevel() {
        String[] input = new String[]{"<html>", "Hello", "</html>"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 2)});
    }

    @Test
    public void testFoldTwoLevel() {
        String[] input = new String[]{"<html>", "<head>", "Hello", "</head>", "</html>"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 4), XMLFoldingsTest.r(1, 3)});
    }

    @Test
    public void testFoldSiblings() {
        String[] input = new String[]{"<html>", "<head>", "Head", "</head>", "<body class=\"f\">", "Body", "</body>", "</html>"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 7), XMLFoldingsTest.r(1, 3), XMLFoldingsTest.r(4, 6)});
    }

    @Test
    public void testFoldComment() {
        String[] input = new String[]{"<!--", " multi line", "-->", "<!-- some stuff", " some more stuff -->"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 2, "comment"), XMLFoldingsTest.r(3, 4, "comment")});
    }

    @Test
    public void testFoldRegions() {
        String[] input = new String[]{"<!-- #region -->", "<!-- #region -->", "<!-- #endregion -->", "<!-- #endregion -->"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 3, "region"), XMLFoldingsTest.r(1, 2, "region")});
    }

    @Test
    public void testFoldIncomplete() {
        String[] input = new String[]{"<body>", "<div></div>", "Hello", "</div>", "</body>"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 4)});
    }

    @Test
    public void testFoldIcomplete2() {
        String[] input = new String[]{"<be><div>", "<!-- #endregion -->", "</div>"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 2)});
    }

    @Test
    public void testFoldIntersectingRegion() {
        String[] input = new String[]{"<body>", "<!-- #region -->", "Hello", "<div></div>", "</body>", "<!-- #endregion -->"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 4)});
    }

    @Test
    public void testFoldIntersectingRegion2() {
        String[] input = new String[]{"<!-- #region -->", "<body>", "Hello", "<!-- #endregion -->", "<div></div>", "</body>"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 3, "region")});
    }

    @Test
    public void testLimit() {
        String[] input = new String[]{"<div>", " <span>", "  <b>", "  ", "  </b>,", "  <b>", "   <pre>", "  ", "   </pre>,", "   <pre>", "  ", "   </pre>,", "  </b>,", "  <b>", "  ", "  </b>,", "  <b>", "  ", "  </b>", " </span>", "</div>"};
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20), XMLFoldingsTest.r(1, 19), XMLFoldingsTest.r(2, 4), XMLFoldingsTest.r(5, 12), XMLFoldingsTest.r(6, 8), XMLFoldingsTest.r(9, 11), XMLFoldingsTest.r(13, 15), XMLFoldingsTest.r(16, 18)}, "no limit", null);
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20), XMLFoldingsTest.r(1, 19), XMLFoldingsTest.r(2, 4), XMLFoldingsTest.r(5, 12), XMLFoldingsTest.r(6, 8), XMLFoldingsTest.r(9, 11), XMLFoldingsTest.r(13, 15), XMLFoldingsTest.r(16, 18)}, "limit 8", 8);
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20), XMLFoldingsTest.r(1, 19), XMLFoldingsTest.r(2, 4), XMLFoldingsTest.r(5, 12), XMLFoldingsTest.r(6, 8), XMLFoldingsTest.r(13, 15), XMLFoldingsTest.r(16, 18)}, "limit 7", 7);
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20), XMLFoldingsTest.r(1, 19), XMLFoldingsTest.r(2, 4), XMLFoldingsTest.r(5, 12), XMLFoldingsTest.r(13, 15), XMLFoldingsTest.r(16, 18)}, "limit 6", 6);
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20), XMLFoldingsTest.r(1, 19), XMLFoldingsTest.r(2, 4), XMLFoldingsTest.r(5, 12), XMLFoldingsTest.r(13, 15)}, "limit 5", 5);
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20), XMLFoldingsTest.r(1, 19), XMLFoldingsTest.r(2, 4), XMLFoldingsTest.r(5, 12)}, "limit 4", 4);
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20), XMLFoldingsTest.r(1, 19), XMLFoldingsTest.r(2, 4)}, "limit 3", 3);
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20), XMLFoldingsTest.r(1, 19)}, "limit 2", 2);
        XMLFoldingsTest.assertRanges(input, new ExpectedIndentRange[]{XMLFoldingsTest.r(0, 20)}, "limit 1", 1);
    }

    private static void assertRanges(String[] lines, ExpectedIndentRange[] expected) {
        XMLFoldingsTest.assertRanges(lines, expected, "", null);
    }

    private static void assertRanges(String[] lines, ExpectedIndentRange[] expected, String message, Integer nRanges) {
        TextDocument document = new TextDocument(String.join((CharSequence)"\n", lines), "test://foo/bar.json");
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, null);
        XMLLanguageService languageService = new XMLLanguageService();
        FoldingRangeCapabilities context = new FoldingRangeCapabilities();
        context.setRangeLimit(nRanges);
        XMLFoldingSettings settings = new XMLFoldingSettings();
        settings.setCapabilities(context);
        List actual = languageService.getFoldingRanges(xmlDocument, settings);
        ArrayList<ExpectedIndentRange> actualRanges = new ArrayList<ExpectedIndentRange>();
        for (FoldingRange f : actual) {
            actualRanges.add(XMLFoldingsTest.r(f.getStartLine(), f.getEndLine(), f.getKind()));
        }
        Collections.sort(actualRanges, (r1, r2) -> r1.startLine - r2.startLine);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actualRanges.toArray(), (String)message);
    }

    private static ExpectedIndentRange r(int startLine, int endLine) {
        return XMLFoldingsTest.r(startLine, endLine, null);
    }

    private static ExpectedIndentRange r(int startLine, int endLine, String kind) {
        return new ExpectedIndentRange(startLine, endLine, kind);
    }

    private static class ExpectedIndentRange {
        public final int startLine;
        public final int endLine;
        public final String kind;

        public ExpectedIndentRange(int startLine, int endLine, String kind) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.kind = kind;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.endLine;
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + this.startLine;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpectedIndentRange other = (ExpectedIndentRange)obj;
            if (this.endLine != other.endLine) {
                return false;
            }
            if (this.kind == null ? other.kind != null : !this.kind.equals(other.kind)) {
                return false;
            }
            return this.startLine == other.startLine;
        }
    }
}

