/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints.GenerateDocTypeCodeActionResolver;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints.GenerateXMLModelWithDTDCodeActionResolver;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints.GenerateXMLModelWithXSDCodeActionResolver;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints.GenerateXSINoNamespaceSchemaCodeActionResolver;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CodeActionResolveSupportCapabilities;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.junit.jupiter.api.Test;

public class XMLProblemsTest {
    @Test
    public void noGrammarIgnore() throws BadLocationException {
        String xml = "<root /> ";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void noGrammarHint() throws BadLocationException {
        XMLProblemsTest.noGrammarHint(false);
    }

    @Test
    public void noGrammarHintSelfClose() throws BadLocationException {
        XMLProblemsTest.noGrammarHint(true);
    }

    private static void noGrammarHint(boolean selfClose) throws BadLocationException {
        String xml = selfClose ? "<root/>" : "<root></root>";
        Diagnostic d = new Diagnostic(XMLAssert.r(0, 1, 0, 5), "No grammar constraints (DTD or XML Schema).", DiagnosticSeverity.Hint, "test.xml", XMLSyntaxErrorCode.NoGrammarConstraints.name());
        ContentModelSettings contentModelSettings = new ContentModelSettings();
        XMLValidationSettings problems = new XMLValidationSettings();
        problems.setNoGrammar("hint");
        contentModelSettings.setValidation(problems);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, false, contentModelSettings, d);
        SharedSettings settings = XMLProblemsTest.createSharedSettings();
        String schemaTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\" />" + System.lineSeparator() + "</xs:schema>";
        String dtdTemplate = "<!ELEMENT root EMPTY>";
        XMLAssert.testCodeActionsFor(xml, d, null, settings, XMLAssert.ca(d, XMLAssert.createFile("test.xsd", false), XMLAssert.teOp("test.xsd", 0, 0, 0, 0, schemaTemplate), XMLAssert.teOp("test.xml", 0, 5, 0, 5, " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:noNamespaceSchemaLocation=\"test.xsd\"")), XMLAssert.ca(d, XMLAssert.createFile("test.xsd", false), XMLAssert.teOp("test.xsd", 0, 0, 0, 0, schemaTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<?xml-model href=\"test.xsd\"?>" + System.lineSeparator())), XMLAssert.ca(d, XMLAssert.createFile("test.dtd", false), XMLAssert.teOp("test.dtd", 0, 0, 0, 0, dtdTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<!DOCTYPE root SYSTEM \"test.dtd\">" + System.lineSeparator())), XMLAssert.ca(d, XMLAssert.createFile("test.dtd", false), XMLAssert.teOp("test.dtd", 0, 0, 0, 0, dtdTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<?xml-model href=\"test.dtd\"?>" + System.lineSeparator())), XMLAssert.ca(d, new Command("Bind to existing grammar/schema", "xml.open.binding.wizard", Arrays.asList("test.xml"))));
    }

    @Test
    public void noCodeActionResolverSupport() throws BadLocationException {
        String xml = "<root></root>";
        Diagnostic d = new Diagnostic(XMLAssert.r(0, 1, 0, 5), "No grammar constraints (DTD or XML Schema).", DiagnosticSeverity.Hint, "test.xml", XMLSyntaxErrorCode.NoGrammarConstraints.name());
        SharedSettings settings = XMLProblemsTest.createSharedSettings();
        String schemaTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\" />" + System.lineSeparator() + "</xs:schema>";
        String dtdTemplate = "<!ELEMENT root EMPTY>";
        XMLAssert.testCodeActionsFor(xml, d, null, settings, XMLAssert.ca(d, XMLAssert.createFile("test.xsd", false), XMLAssert.teOp("test.xsd", 0, 0, 0, 0, schemaTemplate), XMLAssert.teOp("test.xml", 0, 5, 0, 5, " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:noNamespaceSchemaLocation=\"test.xsd\"")), XMLAssert.ca(d, XMLAssert.createFile("test.xsd", false), XMLAssert.teOp("test.xsd", 0, 0, 0, 0, schemaTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<?xml-model href=\"test.xsd\"?>" + System.lineSeparator())), XMLAssert.ca(d, XMLAssert.createFile("test.dtd", false), XMLAssert.teOp("test.dtd", 0, 0, 0, 0, dtdTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<!DOCTYPE root SYSTEM \"test.dtd\">" + System.lineSeparator())), XMLAssert.ca(d, XMLAssert.createFile("test.dtd", false), XMLAssert.teOp("test.dtd", 0, 0, 0, 0, dtdTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<?xml-model href=\"test.dtd\"?>" + System.lineSeparator())), XMLAssert.ca(d, new Command("Bind to existing grammar/schema", "xml.open.binding.wizard", Arrays.asList("test.xml"))));
    }

    @Test
    public void withCodeActionResolverSupport() throws BadLocationException {
        String xml = "<root></root>";
        Diagnostic d = new Diagnostic(XMLAssert.r(0, 1, 0, 5), "No grammar constraints (DTD or XML Schema).", DiagnosticSeverity.Hint, "test.xml", XMLSyntaxErrorCode.NoGrammarConstraints.name());
        SharedSettings settings = XMLProblemsTest.createSharedSettings(true);
        XMLLanguageService ls = new XMLLanguageService();
        List<CodeAction> actual = XMLAssert.testCodeActionsFor(xml, d, null, settings, ls, XMLAssert.ca(d, this.createData("test.xml", GenerateXSINoNamespaceSchemaCodeActionResolver.PARTICIPANT_ID, "test.xsd")), XMLAssert.ca(d, this.createData("test.xml", GenerateXMLModelWithXSDCodeActionResolver.PARTICIPANT_ID, "test.xsd")), XMLAssert.ca(d, this.createData("test.xml", GenerateDocTypeCodeActionResolver.PARTICIPANT_ID, "test.dtd")), XMLAssert.ca(d, this.createData("test.xml", GenerateXMLModelWithDTDCodeActionResolver.PARTICIPANT_ID, "test.dtd")), XMLAssert.ca(d, new Command("Bind to existing grammar/schema", "xml.open.binding.wizard", Arrays.asList("test.xml"))));
        String schemaTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "  <xs:element name=\"root\" />" + System.lineSeparator() + "</xs:schema>";
        String dtdTemplate = "<!ELEMENT root EMPTY>";
        CodeAction unresolved1 = actual.get(0);
        XMLAssert.testResolveCodeActionsFor(xml, unresolved1, settings, ls, XMLAssert.ca(d, this.createData("test.xml", GenerateXSINoNamespaceSchemaCodeActionResolver.PARTICIPANT_ID, "test.xsd"), XMLAssert.createFile("test.xsd", false), XMLAssert.teOp("test.xsd", 0, 0, 0, 0, schemaTemplate), XMLAssert.teOp("test.xml", 0, 5, 0, 5, " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:noNamespaceSchemaLocation=\"test.xsd\"")));
        CodeAction unresolved2 = actual.get(1);
        XMLAssert.testResolveCodeActionsFor(xml, unresolved2, settings, ls, XMLAssert.ca(d, this.createData("test.xml", GenerateXMLModelWithXSDCodeActionResolver.PARTICIPANT_ID, "test.xsd"), XMLAssert.createFile("test.xsd", false), XMLAssert.teOp("test.xsd", 0, 0, 0, 0, schemaTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<?xml-model href=\"test.xsd\"?>" + System.lineSeparator())));
        CodeAction unresolved3 = actual.get(2);
        XMLAssert.testResolveCodeActionsFor(xml, unresolved3, settings, ls, XMLAssert.ca(d, this.createData("test.xml", GenerateDocTypeCodeActionResolver.PARTICIPANT_ID, "test.dtd"), XMLAssert.createFile("test.dtd", false), XMLAssert.teOp("test.dtd", 0, 0, 0, 0, dtdTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<!DOCTYPE root SYSTEM \"test.dtd\">" + System.lineSeparator())));
        CodeAction unresolved4 = actual.get(3);
        XMLAssert.testResolveCodeActionsFor(xml, unresolved4, settings, ls, XMLAssert.ca(d, this.createData("test.xml", GenerateXMLModelWithDTDCodeActionResolver.PARTICIPANT_ID, "test.dtd"), XMLAssert.createFile("test.dtd", false), XMLAssert.teOp("test.dtd", 0, 0, 0, 0, dtdTemplate), XMLAssert.teOp("test.xml", 0, 0, 0, 0, "<?xml-model href=\"test.dtd\"?>" + System.lineSeparator())));
    }

    private JsonObject createData(String uri, String particpantId, String file) {
        JsonObject data = DataEntryField.createData((String)uri, (String)particpantId);
        data.addProperty("file", file);
        return data;
    }

    private static SharedSettings createSharedSettings() {
        return XMLProblemsTest.createSharedSettings(false);
    }

    private static SharedSettings createSharedSettings(boolean resolveCodeAction) {
        SharedSettings settings = new SharedSettings();
        WorkspaceClientCapabilities workspace = new WorkspaceClientCapabilities();
        WorkspaceEditCapabilities workspaceEdit = new WorkspaceEditCapabilities();
        workspaceEdit.setResourceOperations(Arrays.asList("create"));
        workspace.setWorkspaceEdit(workspaceEdit);
        settings.getWorkspaceSettings().setCapabilities(workspace);
        settings.setBindingWizardSupport(true);
        if (resolveCodeAction) {
            CodeActionCapabilities codeAction = new CodeActionCapabilities();
            codeAction.setResolveSupport(new CodeActionResolveSupportCapabilities());
            settings.getCodeActionSettings().setCapabilities(codeAction);
        }
        return settings;
    }
}

