/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class XMLFormatterExperimentalTest {
    @Test
    public void emptyXML() throws BadLocationException {
        String content;
        String expected = content = "";
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void bracket() throws BadLocationException {
        String content;
        String expected = content = "<";
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void closeStartTagMissing() throws BadLocationException {
        String content;
        String expected = content = "<a";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void closeTagMissing() throws BadLocationException {
        String content;
        String expected = content = "<a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void autoCloseTag() throws BadLocationException {
        String content = "<a/>";
        String expected = "<a />";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 2, 0, 2, " "));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void selfClosingTag() throws BadLocationException {
        String content;
        String expected = content = "<a></a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void singleEndTag() throws BadLocationException {
        String content;
        String expected = content = "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void invalidEndTag() throws BadLocationException {
        String content;
        String expected = content = "</";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
        expected = content = "</a";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
        content = "<a></";
        expected = "<a>" + System.lineSeparator() + "</";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 3, 0, 3, System.lineSeparator()));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void invalidEndTagInsideRoot() throws BadLocationException {
        String content;
        String expected = content = "<a>\r\n  <b>\r\n    </\r\n  </b>\r\n</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void endTagMissing() throws BadLocationException {
        String content = "<foo>\r\n  <bar>\r\n    <toto></toto>\r\n</foo>";
        String expected = "<foo>\r\n  <bar>\r\n  <toto></toto>\r\n</foo>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(1, 7, 2, 4, "\r\n  "));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testUnclosedEndTagBracketTrailingElement() throws BadLocationException {
        String content = "<root>\r\n         <a> content </a\r\n      <b></b>\r\n</root>";
        String expected = "<root>\r\n  <a> content </a\r\n  <b></b>\r\n</root>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 6, 1, 9, "\r\n  "), XMLAssert.te(1, 24, 2, 6, "\r\n  "));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void endTagWithSpace() throws BadLocationException {
        String content = "<a></a        >";
        String expected = "<a></a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 6, 0, 14, ""));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void endTagWithLineBreak() throws BadLocationException {
        String content = "<a></a  \n      >";
        String expected = "<a></a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 6, 1, 6, ""));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void invalidAttribute() throws BadLocationException {
        String content;
        String expected = content = "<a bb=\"asd\" \"aaa\"> </a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidQuoteInTag() throws BadLocationException {
        String content;
        String expected = content = "<a'> </a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidEqualsInTag() throws BadLocationException {
        String content;
        String expected = content = "<a=";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidProcessingInstruction() throws BadLocationException {
        String content;
        String expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?\r\n\t\t\t<a />";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidTagName() throws BadLocationException {
        String content = "<message>\r\n\t  <table>\r\n\t    <tbody>\r\n\t      <%= for el <- @elements do %>\r\n\t        <tr>\r\n\t            <td><%= el.id %></td>\r\n\t        </tr>\r\n\t      <% end %>\r\n\t    </tbody>\r\n\t  </table>\r\n\t</message>";
        String expected = "<message>\r\n  <table>\r\n    <tbody>\r\n      <%= for el\r\n      <- @elements do %>\r\n      <tr>\r\n        <td>\r\n          <%= el.id %>\r\n        </td>\r\n      </tr>\r\n      <% end %>\r\n    </tbody>\r\n  </table>\r\n</message>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 9, 1, 3, "\r\n  "), XMLAssert.te(1, 10, 2, 5, "\r\n    "), XMLAssert.te(2, 12, 3, 7, "\r\n      "), XMLAssert.te(3, 17, 3, 18, "\r\n      "), XMLAssert.te(3, 36, 4, 9, "\r\n      "), XMLAssert.te(4, 13, 5, 13, "\r\n        "), XMLAssert.te(5, 17, 5, 17, "\r\n          "), XMLAssert.te(5, 29, 5, 29, "\r\n        "), XMLAssert.te(5, 34, 6, 9, "\r\n      "), XMLAssert.te(6, 14, 7, 7, "\r\n      "), XMLAssert.te(7, 16, 8, 5, "\r\n    "), XMLAssert.te(8, 13, 9, 3, "\r\n  "), XMLAssert.te(9, 11, 10, 1, "\r\n"));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void attrWithEqualsSpace() throws BadLocationException {
        String content = "<div  class = \"foo\">\n<br/>\n </div>";
        String expected = "<div class=\"foo\">\n  <br />\n</div>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 4, 0, 6, " "), XMLAssert.te(0, 11, 0, 12, ""), XMLAssert.te(0, 13, 0, 14, ""), XMLAssert.te(0, 20, 1, 0, "\n  "), XMLAssert.te(1, 3, 1, 3, " "), XMLAssert.te(1, 5, 2, 1, "\n"));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void attrValueWithLineBreakSpace() throws BadLocationException {
        String content = "<div  class = \n\"foo\">\n<br/>\n </div>";
        String expected = "<div class=\"foo\">\n  <br />\n</div>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 4, 0, 6, " "), XMLAssert.te(0, 11, 0, 12, ""), XMLAssert.te(0, 13, 1, 0, ""), XMLAssert.te(1, 6, 2, 0, "\n  "), XMLAssert.te(2, 3, 2, 3, " "), XMLAssert.te(2, 5, 3, 1, "\n"));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testInvalidAttr() throws BadLocationException {
        String content = "<asdf \"\"`=asdf />";
        String expected = "<asdf \"\" `= asdf />";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 8, 0, 8, " "), XMLAssert.te(0, 10, 0, 10, " "));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueTwoLines() throws BadLocationException {
        String content = "<xml>\r\n  <a \r\n   |a             =         \"aa\"|>\r\n    <b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a a=\"aa\">\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(1, 4, 2, 3, " "), XMLAssert.te(2, 4, 2, 17, ""), XMLAssert.te(2, 18, 2, 27, ""));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLines() throws BadLocationException {
        String content = "<xml>\r\n  <a \r\n  |a\r\n  =\r\n  \"aa\"\r\n  \r\n  >|\r\n    <b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a a=\"aa\">\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(1, 4, 2, 2, " "), XMLAssert.te(2, 3, 3, 2, ""), XMLAssert.te(3, 3, 4, 2, ""), XMLAssert.te(4, 6, 6, 2, ""));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLinesWithChild() throws BadLocationException {
        String content = "<xml>\r\n  <a \r\n   |a          =        \r\n   \r\n   \"aa\">|<b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a a=\"aa\">\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(1, 4, 2, 3, " "), XMLAssert.te(2, 4, 2, 14, ""), XMLAssert.te(2, 15, 4, 3, ""), XMLAssert.te(4, 8, 4, 8, "\r\n    "));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLinesWithChildrenSiblings() throws BadLocationException {
        String content = "<xml>\r\n  <a \r\n  |a\r\n  =\r\n  \"aa\"\r\n  \r\n  >\r\n        <b>\r\n          <c></c>\r\n    </b>\r\n  </a>\r\n        <d></d>|\r\n</xml>";
        String expected = "<xml>\r\n  <a a=\"aa\">\r\n    <b>\r\n      <c></c>\r\n    </b>\r\n  </a>\r\n  <d></d>\r\n</xml>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(1, 4, 2, 2, " "), XMLAssert.te(2, 3, 3, 2, ""), XMLAssert.te(3, 3, 4, 2, ""), XMLAssert.te(4, 6, 6, 2, ""), XMLAssert.te(6, 3, 7, 8, "\r\n    "), XMLAssert.te(7, 11, 8, 10, "\r\n      "), XMLAssert.te(10, 6, 11, 8, "\r\n  "));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testProlog() throws BadLocationException {
        String content = "<?xml version=   \"1.0\"       encoding=\"UTF-8\"  ?>\r\n";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 14, 0, 17, ""), XMLAssert.te(0, 22, 0, 29, " "), XMLAssert.te(0, 45, 0, 47, ""), XMLAssert.te(0, 49, 1, 0, ""));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testProlog2() throws BadLocationException {
        String content = "<?xml version=   \"1.0\"       encoding=\"UTF-8\"  ?><a>bb</a>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<a>bb</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 14, 0, 17, ""), XMLAssert.te(0, 22, 0, 29, " "), XMLAssert.te(0, 45, 0, 47, ""), XMLAssert.te(0, 49, 0, 49, System.lineSeparator()));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testProlog3() throws BadLocationException {
        String content = "<?xml version=   \"1.0\"       encoding=\"UTF-8\"  ?><a><b>c</b></a>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<a>" + System.lineSeparator() + "  <b>c</b>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 14, 0, 17, ""), XMLAssert.te(0, 22, 0, 29, " "), XMLAssert.te(0, 45, 0, 47, ""), XMLAssert.te(0, 49, 0, 49, System.lineSeparator()), XMLAssert.te(0, 52, 0, 52, System.lineSeparator() + "  "), XMLAssert.te(0, 60, 0, 60, System.lineSeparator()));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testProlog4WithUnknownVariable() throws BadLocationException {
        String content = "<?xml version=   \"1.0\"       encoding=\"UTF-8\"  unknown=\"unknownValue\" ?><a><b>c</b></a>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" unknown=\"unknownValue\"?>" + System.lineSeparator() + "<a>" + System.lineSeparator() + "  <b>c</b>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 14, 0, 17, ""), XMLAssert.te(0, 22, 0, 29, " "), XMLAssert.te(0, 45, 0, 47, " "), XMLAssert.te(0, 69, 0, 70, ""), XMLAssert.te(0, 72, 0, 72, System.lineSeparator()), XMLAssert.te(0, 75, 0, 75, System.lineSeparator() + "  "), XMLAssert.te(0, 83, 0, 83, System.lineSeparator()));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testPI() throws BadLocationException {
        String content = "<a><?m2e asd as das das ?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?m2e asd as das das?>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testPINoContent() throws BadLocationException {
        String content = "<a><?m2e?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?m2e ?>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDefinedPIWithVariables() throws BadLocationException {
        String content = "<a><?xml-stylesheet   href=\"my-style.css\"     type=   \"text/css\"?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?xml-stylesheet href=\"my-style.css\" type=\"text/css\" ?>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDefinedPIWithJustAttributeNames() throws BadLocationException {
        String content = "<a><?xml-stylesheet    href     type  =       attName?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?xml-stylesheet href type= attName ?>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testPIWithVariables() throws BadLocationException {
        String content = "<a><?xml-styleZZ   href=\"my-style.css\"     type=   \"text/css\"?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?xml-styleZZ href=\"my-style.css\"     type=   \"text/css\"?>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testComment() throws BadLocationException {
        String content = "<!-- CommentText --><a>Val</a>";
        String expected = "<!-- CommentText -->" + System.lineSeparator() + "<a>Val</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, XMLAssert.te(0, 20, 0, 20, System.lineSeparator()));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testComment2() throws BadLocationException {
        String content = "<!-- CommentText --><!-- Comment2 --><a>Val</a>";
        String expected = "<!-- CommentText -->" + System.lineSeparator() + "<!-- Comment2 -->" + System.lineSeparator() + "<a>Val</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testCommentNested() throws BadLocationException {
        String content = "<a><!-- CommentText --></a>";
        String expected = "<a>" + System.lineSeparator() + "  <!-- CommentText -->" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testCommentNested2() throws BadLocationException {
        String content = "<a><!-- CommentText --><b><!-- Comment2 --></b></a>";
        String expected = "<a>" + System.lineSeparator() + "  <!-- CommentText -->" + System.lineSeparator() + "  <b>" + System.lineSeparator() + "    <!-- Comment2 -->" + System.lineSeparator() + "  </b>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testCommentMultiLineContent() throws BadLocationException {
        String content = "<a><!-- CommentText" + System.lineSeparator() + "2222" + System.lineSeparator() + "  3333 --></a>";
        String expected = "<a>" + System.lineSeparator() + "  <!-- CommentText" + System.lineSeparator() + "2222" + System.lineSeparator() + "  3333 -->" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testCommentNotClosed() throws BadLocationException {
        String content;
        String expected = content = "<foo>\r\n  <!-- \r\n</foo>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testCommentWithRange() throws BadLocationException {
        String content = "<foo>\r\n  <!-- |<bar>|\r\n  </bar>\r\n\t-->\r\n</foo>";
        String expected = "<foo>\r\n  <!-- <bar>\r\n  </bar>\r\n\t-->\r\n</foo>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testJoinCommentLines() throws BadLocationException {
        String content = "<!--" + System.lineSeparator() + " line 1" + System.lineSeparator() + " " + System.lineSeparator() + " " + System.lineSeparator() + "   line 2" + System.lineSeparator() + " -->";
        String expected = "<!-- line 1 line 2 -->";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testUnclosedEndTagTrailingComment() throws BadLocationException {
        String content = "<root>" + System.lineSeparator() + "    <a> content </a" + System.lineSeparator() + "        <!-- comment -->" + System.lineSeparator() + " </root>";
        String expected = "<root>" + System.lineSeparator() + "  <a> content </a" + System.lineSeparator() + "  <!-- comment -->" + System.lineSeparator() + "</root>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testJoinCommentLinesNested() throws BadLocationException {
        String content = "<a>" + System.lineSeparator() + "  <!--" + System.lineSeparator() + "   line 1" + System.lineSeparator() + "   " + System.lineSeparator() + "   " + System.lineSeparator() + "     line 2" + System.lineSeparator() + "   -->" + System.lineSeparator() + "</a>";
        String expected = "<a>" + System.lineSeparator() + "  <!-- line 1 line 2 -->" + System.lineSeparator() + "</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testCommentFormatSameLine() throws BadLocationException {
        String content = "<a>" + System.lineSeparator() + " Content" + System.lineSeparator() + "</a> <!-- My   Comment   -->";
        String expected = "<a>" + System.lineSeparator() + " Content" + System.lineSeparator() + "</a> <!-- My Comment -->";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCommentLines(true);
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCDATANotClosed() throws BadLocationException {
        String content;
        String expected = content = "<foo>\r\n  <![CDATA[ \r\n</foo>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testCDATAWithRange() throws BadLocationException {
        String content = "<foo>\r\n  <![CDATA[ |<bar>|\r\n  </bar>\r\n  ]]>\r\n</foo>";
        String expected = "<foo>\r\n  <![CDATA[ <bar>\r\n  </bar>\r\n  ]]>\r\n</foo>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testJoinCDATALines() throws BadLocationException {
        String content = "<a>" + System.lineSeparator() + "<![CDATA[" + System.lineSeparator() + "line 1" + System.lineSeparator() + "" + System.lineSeparator() + "" + System.lineSeparator() + "line 2" + System.lineSeparator() + "line 3" + System.lineSeparator() + "]]> </a>";
        String expected = "<a>" + System.lineSeparator() + "  <![CDATA[line 1 line 2 line 3]]>" + System.lineSeparator() + "</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCDATALines(true);
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testElementContentNotNormalized() throws BadLocationException {
        String content = "<a>\r Content\r     Content2\r      Content3\r Content4\r  Content5\r</a>";
        String expected = "<a>\r Content\r     Content2\r      Content3\r Content4\r  Content5\r</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testContentFormatting2() throws BadLocationException {
        String content = "<a>\r Content\r <b>\r   Content2\r    Content3\r </b>\r</a>";
        String expected = "<a>\r  Content\r  <b>\r   Content2\r    Content3\r </b>\r</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testContentFormattingDontMoveEndTag() throws BadLocationException {
        String content = "<a>\r Content\r <b>\r   Content2\r    Content3 </b>\r</a>";
        String expected = "<a>\r  Content\r  <b>\r   Content2\r    Content3 </b>\r</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testContentFormatting3() throws BadLocationException {
        String content = "<a> content </a>";
        String expected = "<a> content </a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testContentFormatting6() throws BadLocationException {
        String content = "<a>\r\r Content\r</a>";
        String expected = "<a>\r\r Content\r</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
        content = "<a>\r\n\r\n Content\r\n</a>";
        expected = "<a>\r\n\r\n Content\r\n</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testTrimTrailingWhitespaceText() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \ntext     \n    text text text    \n    text\n</a>   ";
        String expected = "<a>\ntext\n    text text text\n    text\n</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testTrimTrailingWhitespaceNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \n   \n</a>   ";
        String expected = "<a></a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testTrimTrailingWhitespaceTextAndNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \n    \ntext     \n    text text text    \n   \n    text\n        \n</a>   ";
        String expected = "<a>\n\ntext\n    text text text\n\n    text\n\n</a>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDontInsertFinalNewLineWithRange() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"|/>\r\n </div>";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n </div>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testInsertFinalNewLineWithRange2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"/>\r\n </div>|";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n</div>\r\n";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testInsertFinalNewLineWithRange3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"/>\r\n\r\n|\r\n<h1></h1>\r\n </div>";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n\r\n<h1></h1>\r\n </div>";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontTrimFinalNewLines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n\r\n\r\n";
        String expected = "<a></a>\r\n\r\n\r\n";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 4, ""));
        XMLFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDontTrimFinalNewLines2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n   \r\n\r\n";
        String expected = "<a></a>\r\n   \r\n\r\n";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDontTrimFinalNewLines3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n  text \r\n  more text   \r\n   \r\n";
        String expected = "<a></a>\r\n  text \r\n  more text   \r\n   \r\n";
        XMLFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterExperimentalTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterExperimentalTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterExperimentalTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

