/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.typedefinition;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.junit.jupiter.api.Test;

public class RelaxNGCompactSyntaxTypeDefinitionTest
extends AbstractCacheBasedTest {
    @Test
    public void toRootElementDeclaration() throws BadLocationException {
        String xmlFile = "src/test/resources/relaxng/addressBook.xml";
        String xsdFile = "addressBook.rnc";
        String xml = "<?xml-model href=\"addressBook.rnc\" ?>\r\n<addre|ssBook>\r\n\r\n</addressBook>";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(1, 1, 1, 12), XMLAssert.r(0, 0, 0, 1)));
    }

    @Test
    public void toElementDeclaration() throws BadLocationException {
        String xmlFile = "src/test/resources/relaxng/addressBook.xml";
        String xsdFile = "addressBook.rnc";
        String xml = "<?xml-model href=\"addressBook.rnc\" ?>\r\n<addressBook>\r\n  <car|d></card>\r\n</addressBook>";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(2, 3, 2, 7), XMLAssert.r(1, 2, 1, 3)));
    }

    @Test
    public void toAttributeDeclaration() throws BadLocationException {
        String xmlFile = "src/test/resources/relaxng/addressBook.xml";
        String xsdFile = "addressBook.rnc";
        String xml = "<?xml-model href=\"addressBook.rnc\" ?>\r\n<addressBook>\r\n  <card i|d=\"\"></card>\r\n</addressBook>";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(2, 8, 2, 13), XMLAssert.r(5, 4, 5, 5)));
    }
}

