/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.prolog;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.prolog.PrologModel;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.junit.jupiter.api.Test;

public class PrologCompletionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void completionVersionWithV() throws BadLocationException {
        String xml = "<?xml v|?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, 1, XMLAssert.c("version", XMLAssert.te(0, 6, 0, 7, "version=\"1.0\""), "version"));
    }

    @Test
    public void completionVersion() throws BadLocationException {
        String xml = "<?xml |?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, XMLAssert.c("version", XMLAssert.te(0, 6, 0, 6, "version=\"1.0\""), "version"));
    }

    @Test
    public void completionEncodingAndStandalone() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" |?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, 2, XMLAssert.c("encoding", XMLAssert.te(0, 20, 0, 20, "encoding=\"UTF-8\""), "encoding"), XMLAssert.c("standalone", XMLAssert.te(0, 20, 0, 20, "standalone=\"yes\""), "standalone"));
    }

    @Test
    public void completionStandalone() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" |?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, 1, XMLAssert.c("standalone", XMLAssert.te(0, 37, 0, 37, "standalone=\"yes\""), "standalone"));
    }

    @Test
    public void noCompletionsAfterStandalone() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" standalone=\"yes\" |?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, 0, (CompletionItem[])null);
    }

    @Test
    public void completionEncodingBeforeStandalone() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" | standalone=\"yes\" ?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, 1, XMLAssert.c("encoding", XMLAssert.te(0, 20, 0, 20, "encoding=\"UTF-8\""), "encoding"));
    }

    @Test
    public void completionVersionValue() throws BadLocationException {
        String xml = "<?xml version=| ?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, XMLAssert.c("1.0", XMLAssert.te(0, 14, 0, 14, "\"1.0\""), "\"1.0\""), XMLAssert.c("1.1", XMLAssert.te(0, 14, 0, 14, "\"1.1\""), "\"1.1\""));
    }

    @Test
    public void completionVersionNoSpaceAfterEquals() throws BadLocationException {
        String xml = "<?xml version=|?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, XMLAssert.c("1.0", XMLAssert.te(0, 14, 0, 14, "\"1.0\""), "\"1.0\""), XMLAssert.c("1.1", XMLAssert.te(0, 14, 0, 14, "\"1.1\""), "\"1.1\""));
    }

    @Test
    public void completionEncodingValue() throws BadLocationException {
        String xml = "<?xml encoding=| ?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, XMLAssert.c(PrologModel.UTF_8, XMLAssert.te(0, 15, 0, 15, "\"" + PrologModel.UTF_8 + "\""), "\"" + PrologModel.UTF_8 + "\""), XMLAssert.c("EUC-KR", XMLAssert.te(0, 15, 0, 15, "\"EUC-KR\""), "\"EUC-KR\""));
    }

    @Test
    public void completionStandaloneValue() throws BadLocationException {
        String xml = "<?xml standalone=| ?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, XMLAssert.c("yes", XMLAssert.te(0, 17, 0, 17, "\"yes\""), "\"yes\""), XMLAssert.c("no", XMLAssert.te(0, 17, 0, 17, "\"no\""), "\"no\""));
    }

    @Test
    public void completionVersionExists() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" version=| ?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, XMLAssert.c("1.1", XMLAssert.te(0, 28, 0, 28, "\"1.1\""), "\"1.1\""));
    }

    @Test
    public void completionEncodingExists() throws BadLocationException {
        String xml = "<?xml encoding=\"UTF-8\" encoding=\"Win|\" ?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        this.testCompletionFor(xml, XMLAssert.c("Windows-1251", XMLAssert.te(0, 33, 0, 36, "Windows-1251"), "Windows-1251"), XMLAssert.c("Windows-1252", XMLAssert.te(0, 33, 0, 36, "Windows-1252"), "Windows-1252"));
    }

    @Test
    public void completionVersionSingleQuotes() throws BadLocationException {
        String xml = "<?xml version=| ?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        SharedSettings settings = this.createSharedSettings(true, true);
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        this.testCompletionFor(xml, settings, XMLAssert.c("1.0", XMLAssert.te(0, 14, 0, 14, "'1.0'"), "'1.0'"), XMLAssert.c("1.1", XMLAssert.te(0, 14, 0, 14, "'1.1'"), "'1.1'"));
    }

    @Test
    public void completionEncodingSingleQuotes() throws BadLocationException {
        String xml = "<?xml encoding=| ?>\r\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        SharedSettings settings = this.createSharedSettings(true, true);
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        this.testCompletionFor(xml, settings, XMLAssert.c(PrologModel.UTF_8, XMLAssert.te(0, 15, 0, 15, "'" + PrologModel.UTF_8 + "'"), "'" + PrologModel.UTF_8 + "'"), XMLAssert.c("Shift JIS", XMLAssert.te(0, 15, 0, 15, "'Shift JIS'"), "'Shift JIS'"));
    }

    @Test
    public void testAutoCompletionPrologWithXML() throws BadLocationException {
        this.testCompletionFor("<?xml|", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 5), "<?xml"));
        this.testCompletionFor("<?xml|>", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 6), "<?xml"));
        this.testCompletionFor("<?xml|?>", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 7), "<?xml"));
    }

    @Test
    public void testAutoCompletionPrologWithoutXML() throws BadLocationException {
        this.testCompletionFor("<?|", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 2), "<?xml"));
        this.testCompletionFor("<?|", false, XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 2), "<?xml"));
        this.testCompletionFor("<?|>", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 3), "<?xml"));
        this.testCompletionFor("<?|?>", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 4), "<?xml"));
    }

    @Test
    public void testAutoCompletionPrologWithPartialXML() throws BadLocationException {
        this.testCompletionFor("<?x|", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 3), "<?xml"));
        this.testCompletionFor("<?xm|", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 4), "<?xml"));
        this.testCompletionFor("<?xml|", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 5), "<?xml"));
        this.testCompletionFor("<?xml|?", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 6), "<?xml"));
        this.testCompletionFor("<?xml|?>", true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 7), "<?xml"));
    }

    @Test
    public void testAutoCompletionPrologDTDFileWithXML() throws BadLocationException {
        String dtdFileURI = "test://test/test.dtd";
        this.testCompletionFor("<?xml|", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 5), "<?xml"));
        this.testCompletionFor("<?xml|>", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 6), "<?xml"));
        this.testCompletionFor("<?xml|?>", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 7), "<?xml"));
    }

    @Test
    public void testAutoCompletionPrologDTDFileWithoutXML() throws BadLocationException {
        String dtdFileURI = "test://test/test.dtd";
        this.testCompletionFor("<?|", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 2), "<?xml"));
        this.testCompletionFor("<?|", dtdFileURI, false, XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 2), "<?xml"));
        this.testCompletionFor("<?|>", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 3), "<?xml"));
        this.testCompletionFor("<?|?>", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 4), "<?xml"));
    }

    @Test
    public void testAutoCompletionPrologDTFFileWithPartialXML() throws BadLocationException {
        String dtdFileURI = "test://test/test.dtd";
        this.testCompletionFor("<?x|", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 3), "<?xml"));
        this.testCompletionFor("<?xm|", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 4), "<?xml"));
        this.testCompletionFor("<?xml|", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 5), "<?xml"));
        this.testCompletionFor("<?xml|?", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 6), "<?xml"));
        this.testCompletionFor("<?xml|?>", dtdFileURI, true, XMLAssert.c("Insert XML Declaration", "<?xml version=\"${1|1.0,1.1|}\" encoding=\"${2|UTF-8,ISO-8859-1,Windows-1251,Windows-1252,Shift JIS,GB2312,EUC-KR|}\"?>${0}", XMLAssert.r(0, 0, 0, 7), "<?xml"));
    }

    private void testCompletionFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(xml, null, expectedItems);
    }

    private void testCompletionFor(String xml, int expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(xml, expectedCount, expectedItems);
    }

    private void testCompletionFor(String xml, String fileURI, boolean isSnippetsSupported, CompletionItem ... expectedItems) throws BadLocationException {
        this.testCompletionFor(xml, fileURI, this.createSharedSettings(false, isSnippetsSupported), expectedItems);
    }

    private void testCompletionFor(String xml, String fileURI, SharedSettings settings, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, null, null, fileURI, null, settings, expectedItems);
    }

    private void testCompletionFor(String xml, boolean isSnippetsSupported, CompletionItem ... expectedItems) throws BadLocationException {
        this.testCompletionFor(xml, this.createSharedSettings(false, isSnippetsSupported), expectedItems);
    }

    private void testCompletionFor(String xml, SharedSettings settings, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, null, null, null, null, settings, expectedItems);
    }

    private SharedSettings createSharedSettings(boolean autoCloseTags, boolean isSnippetsSupported) {
        SharedSettings sharedSettings = new SharedSettings();
        CompletionCapabilities capabilities = new CompletionCapabilities();
        CompletionItemCapabilities itemCapabilities = new CompletionItemCapabilities(Boolean.valueOf(isSnippetsSupported));
        capabilities.setCompletionItem(itemCapabilities);
        sharedSettings.getCompletionSettings().setCapabilities(capabilities);
        sharedSettings.getCompletionSettings().setAutoCloseTags(autoCloseTags);
        return sharedSettings;
    }
}

