/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions.completion;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lemminx.commons.SnippetsBuilder;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.services.extensions.completion.ElementEndTagCompletionResolver;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractElementCompletionItem<S, G>
extends CompletionItem {
    public static final String UPDATE_END_TAG_NAME_FIELD = "updateEndTagName";
    private final transient String tagName;
    private final transient S sourceElement;
    private final transient G generator;
    private final transient ICompletionRequest request;

    public AbstractElementCompletionItem(String tagName, S sourceElement, G generator, ICompletionRequest request) {
        String resolverParticipantId;
        this.tagName = tagName;
        this.sourceElement = sourceElement;
        this.generator = generator;
        this.request = request;
        super.setLabel(tagName);
        super.setSortText(tagName);
        super.setFilterText(request.getFilterForStartTagName(tagName));
        super.setKind(CompletionItemKind.Property);
        boolean generateFullElement = this.updateTextEdit();
        boolean updateEndTagName = !generateFullElement && !request.getSharedSettings().isLinkedEditingEnabled();
        boolean resolveAdditionalTextEditsSupported = this.updateAdditionalTextEdits(updateEndTagName);
        boolean resolveDocumentationSupported = this.updateDocumentation();
        if ((resolveDocumentationSupported || resolveAdditionalTextEditsSupported) && (resolverParticipantId = this.getResolverParticipantId()) != null) {
            JsonObject data = this.addResolveData(request, resolverParticipantId);
            data.addProperty(UPDATE_END_TAG_NAME_FIELD, Boolean.valueOf(updateEndTagName));
        }
    }

    protected String getTagName() {
        return this.tagName;
    }

    protected S getSourceElement() {
        return this.sourceElement;
    }

    protected G getGenerator() {
        return this.generator;
    }

    protected ICompletionRequest getRequest() {
        return this.request;
    }

    private boolean updateTextEdit() {
        boolean shouldStartTagClosed;
        boolean shouldGenerateFullElement;
        int offset;
        DOMNode node = this.request.getNode();
        boolean hasOrphanEndTag = node.getOrphanEndElement(offset = this.request.getOffset(), this.tagName, true) != null;
        boolean isTextNode = AbstractElementCompletionItem.isTextNode(node, offset);
        boolean bl = shouldGenerateFullElement = isTextNode || AbstractElementCompletionItem.isElementClosed((DOMElement)node);
        if (!hasOrphanEndTag && shouldGenerateFullElement) {
            String xml = this.generateFullElementContent(!hasOrphanEndTag && this.request.isAutoCloseTags());
            super.setTextEdit(Either.forLeft((Object)new TextEdit(this.request.getReplaceRange(), xml)));
            super.setInsertTextFormat(InsertTextFormat.Snippet);
            return true;
        }
        DOMElement element = node.isElement() ? (DOMElement)node : null;
        StringBuilder insertText = new StringBuilder(isTextNode ? "<" : "");
        insertText.append(this.tagName);
        if (this.request.isCompletionSnippetsSupported()) {
            SnippetsBuilder.tabstops(0, insertText);
            super.setInsertTextFormat(InsertTextFormat.Snippet);
        }
        boolean bl2 = shouldStartTagClosed = isTextNode || element == null || !AbstractElementCompletionItem.hasContentAfterTagName(element);
        if (shouldStartTagClosed) {
            insertText.append('>');
        }
        super.setTextEdit(Either.forLeft((Object)new TextEdit(isTextNode ? this.request.getReplaceRange() : this.request.getReplaceRangeForTagName(), insertText.toString())));
        return false;
    }

    protected static boolean hasContentAfterTagName(DOMElement element) {
        return element.hasAttributes() && element.getAttributeAtIndex(0).hasDelimiter() || element.isStartTagClosed();
    }

    private boolean updateDocumentation() {
        MarkupContent documentation = this.generateDocumentation();
        super.setDocumentation(documentation);
        return false;
    }

    private boolean updateAdditionalTextEdits(boolean updateEndTagName) {
        if (this.request.isResolveAdditionalTextEditsSupported()) {
            return true;
        }
        if (updateEndTagName) {
            AbstractElementCompletionItem.updateEndTagName(this.request.getNode(), this.request.getOffset(), this.request, this.tagName, this);
        }
        return false;
    }

    public static boolean isElementClosed(DOMElement element) {
        return !element.hasEndTag() && !element.isSelfClosed();
    }

    private static boolean isTextNode(DOMNode node, int offset) {
        if (!node.isElement()) {
            return true;
        }
        DOMElement element = (DOMElement)node;
        if (element.getEnd() <= offset) {
            return true;
        }
        return element.isStartTagClosed() && offset > element.getStartTagCloseOffset() || element.isInInsideStartEndTag(offset);
    }

    protected JsonObject addResolveData(ICompletionRequest request, String participantId) {
        JsonObject data = DataEntryField.createCompletionData(request, participantId);
        super.setData((Object)data);
        return data;
    }

    protected abstract String generateFullElementContent(boolean var1);

    protected abstract MarkupContent generateDocumentation();

    public static void updateEndTagName(DOMNode node, int offset, ISharedSettingsRequest request, String tagName, CompletionItem completionItem) {
        List<TextEdit> additionalTextEdits = AbstractElementCompletionItem.getAdditionalTextEdits(node, offset, tagName, request);
        if (additionalTextEdits != null) {
            completionItem.setAdditionalTextEdits(additionalTextEdits);
        }
    }

    private static List<TextEdit> getAdditionalTextEdits(DOMNode node, int offset, String tagName, ISharedSettingsRequest request) {
        DOMElement endElement = null;
        if (AbstractElementCompletionItem.isTextNode(node, offset)) {
            endElement = node.getOrphanEndElement(offset, tagName, true);
        } else {
            DOMElement element = (DOMElement)node;
            int endElementOffset = node.getEnd() - 1;
            DOMElement dOMElement = endElement = element.hasEndTag() ? element : element.getOrphanEndElement(endElementOffset, tagName, true);
        }
        if (endElement != null && !tagName.equals(endElement.getTagName())) {
            Range range = XMLPositionUtility.selectEndTagName(endElement);
            return Arrays.asList(new TextEdit(range, tagName));
        }
        return null;
    }

    protected String getResolverParticipantId() {
        return ElementEndTagCompletionResolver.PARTICIPANT_ID;
    }
}

