/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.common.util;

import java.util.regex.Pattern;

public class NamingUtil {

    private NamingUtil() {
    }

    public static String makePlural(String word) {
        if (Pattern.matches(".*[sxz]$", word) || Pattern.matches(".*[^aeioudgkprt]h$", word)) {
            // Check if word ends with s, x, z or ends with ah, eh, ih, oh, uh, dh, gh, kh, ph, rh, th
            return word + "es";
        } else if (Pattern.matches(".*[^aeiou]y$", word)) {
            // Check if word is not ending with ay, ey, iy, oy, uy
            return word.substring(0, word.length() - 1) + "ies";
        } else {
            // Default case: just add "s"
            return word + "s";
        }
    }
}
