/*
 * Decompiled with CFR 0.152.
 */
package activity.util;

import activity.Activity;
import activity.ActivitySet;
import activity.Claim;
import activity.Event;
import activity.HasResourceAndItem;
import activity.ModelTypeDefinitionRef;
import activity.Move;
import activity.PeripheralAction;
import activity.SimpleAction;
import com.google.common.collect.Sets;
import common.HasName;
import common.ParameterDeclaration;
import common.TypeDefinition;
import common.util.CommonUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import machine.ActionType;
import machine.HasResourcePeripheral;
import machine.IResource;
import machine.Machine;
import machine.MachinePackage;
import machine.Peripheral;
import machine.Profile;
import machine.Resource;
import machine.ResourceItem;
import machine.SymbolicPosition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.emf.ecore.util.EcoreUtility;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.lsat.common.queries.QueryableIterable;
import product.ProductDefinition;

public final class ActivityParametersUtil {
    private static final String ITEM_DELIMITER = "_";
    private static final String REF_DELIMITER = "__";
    private static final String ESCAPE = "_us_";

    private ActivityParametersUtil() {
    }

    public static String expandName(Activity activity, List<? extends Collection<? extends HasName>> parameters) {
        String name = activity.getName();
        if (!activity.getParameterDeclarations().isEmpty()) {
            List<String> parNames = parameters.stream().map(refs -> String.join((CharSequence)REF_DELIMITER, refs.stream().map(HasName::getName).map(ActivityParametersUtil::esc).toList())).toList();
            return Stream.concat(Stream.of(name), parNames.stream()).collect(Collectors.joining(ITEM_DELIMITER));
        }
        if (!activity.getResourcesNeedingItem().isEmpty()) {
            List<IResource> parametersAsResource = ActivityParametersUtil.convertToIResources(parameters);
            return activity.getResourcesNeedingItem().stream().map(r -> parametersAsResource.stream().filter(i -> i.getResource() == r).map(IResource::getName).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.joining(ITEM_DELIMITER, name + ITEM_DELIMITER, ""));
        }
        return name;
    }

    public static Collection<String> getAllExpandedNames(Activity activity) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(activity.getName());
        List<Set<List<? extends HasName>>> candidates = ActivityParametersUtil.findCandidates(activity);
        Sets.cartesianProduct(candidates).stream().map(pars -> ActivityParametersUtil.expandName(activity, pars)).forEach(result::add);
        return result;
    }

    public static boolean uses(Activity activity, TypeDefinition dec) {
        return Stream.concat(activity.getNodes().stream(), activity.getPrerequisites().stream()).anyMatch(o -> EcoreUtility.containsCrossReference((EObject)o, (EObject)dec));
    }

    public static String displayName(Activity activity) {
        if (activity == null) {
            return null;
        }
        if (activity.getOriginalName() == null) {
            return activity.getName();
        }
        return ActivityParametersUtil.getParameterNames(activity.getOriginalName(), activity.getName()).stream().map(i -> String.join((CharSequence)".", i)).collect(Collectors.joining(",", activity.getOriginalName() + "[", "]"));
    }

    public static Collection<List<String>> getParameterNames(String orgActivityName, String expandedActivityName) {
        if (expandedActivityName.startsWith(orgActivityName + ITEM_DELIMITER)) {
            String expandActivityName = expandedActivityName.replaceAll(REF_DELIMITER, "|");
            String parsStrings = expandActivityName.substring(orgActivityName.length() + ITEM_DELIMITER.length());
            return Arrays.stream(parsStrings.split(ITEM_DELIMITER)).map(par -> Arrays.stream(par.split("|")).map(ActivityParametersUtil::unesc).toList()).toList();
        }
        return Collections.emptyList();
    }

    public static List<TypeDefinition> getDeclarations(Activity activity) {
        if (!activity.getParameterDeclarations().isEmpty()) {
            return activity.getParameterDeclarations().stream().flatMap(pd -> pd.getDeclarations().stream()).toList();
        }
        return activity.getResourcesNeedingItem().stream().map(TypeDefinition.class::cast).distinct().toList();
    }

    public static Activity queryCreateExpandedActivity(Activity orgActivity, List<? extends Collection<? extends HasName>> parameters) {
        EObject eContainer = orgActivity.eContainer();
        if (eContainer == null) {
            throw new RuntimeException("Activity is not part of a container");
        }
        if (!(eContainer instanceof ActivitySet)) {
            throw new RuntimeException("Activity must be part of an ActivitySet");
        }
        ActivitySet set = (ActivitySet)eContainer;
        EList<Activity> activities = set.getActivities();
        String activityName = ActivityParametersUtil.expandName(orgActivity, parameters);
        Activity result = (Activity)QueryableIterable.from(set.getActivities()).select(a -> a.getName().equals(activityName)).first();
        if (result == null) {
            result = ActivityParametersUtil.expand(orgActivity, parameters);
            activities.add(activities.indexOf((Object)orgActivity), (Object)result);
        }
        return result;
    }

    public static List<Set<List<? extends HasName>>> findCandidates(Activity activity) {
        ArrayList<Set<List<? extends HasName>>> result = new ArrayList<Set<List<? extends HasName>>>();
        List<? extends IResource> resources = ActivityParametersUtil.collectResourceCandidates(activity);
        for (TypeDefinition dec : ActivityParametersUtil.getDeclarations(activity)) {
            Collection<List<Object>> candidates;
            if (dec instanceof Resource && !(dec instanceof Event) && ActivityParametersUtil.isDeclaration((EObject)dec)) {
                candidates = ActivityParametersUtil.findAllResources(EcoreUtil.getRootContainer((EObject)dec));
                result.add((Set<List<? extends HasName>>)candidates);
                continue;
            }
            if (dec instanceof ActionType) {
                candidates = ActivityParametersUtil.findAllActionCandidates(resources);
                result.add((Set<List<? extends HasName>>)candidates);
                continue;
            }
            candidates = ActivityParametersUtil.findCandidate(activity, resources, dec, List.of());
            LinkedHashSet format = new LinkedHashSet();
            candidates.stream().map(List::of).forEach(format::add);
            result.add(format);
        }
        return result;
    }

    public static boolean matchesType(TypeDefinition declaration, EObject parameter) {
        TypeDefinition type;
        if (declaration instanceof ModelTypeDefinitionRef) {
            ModelTypeDefinitionRef tdRef = (ModelTypeDefinitionRef)declaration;
            v0 = tdRef.getTypeDefinition();
        } else {
            v0 = type = declaration;
        }
        if (type instanceof Resource && parameter instanceof IResource) {
            IResource iResource = (IResource)parameter;
            return iResource instanceof ResourceItem || iResource.getResource().getItems().size() == 0;
        }
        return type.eClass().isInstance((Object)parameter);
    }

    public static EClass getExpectedType(EObject declaration, EObject parameter) {
        EObject type;
        if (declaration instanceof ModelTypeDefinitionRef) {
            ModelTypeDefinitionRef tdRef = (ModelTypeDefinitionRef)declaration;
            v0 = tdRef.getTypeDefinition();
        } else {
            v0 = type = declaration;
        }
        if (type instanceof Resource && parameter instanceof IResource) {
            IResource iResource = (IResource)parameter;
            if (!iResource.getResource().getItems().isEmpty()) {
                return MachinePackage.Literals.RESOURCE_ITEM;
            }
            return MachinePackage.Literals.RESOURCE;
        }
        return type.eClass();
    }

    public static Collection<? extends HasName> findCandidate(Activity activity, List<? extends IResource> resources, TypeDefinition dec, List<? extends HasName> current) {
        ModelTypeDefinitionRef mtdr;
        TypeDefinition typeDefinition;
        Resource resource;
        ModelTypeDefinitionRef mtdr2;
        EObject parent;
        if (dec == null) {
            return Set.of();
        }
        if (!(dec instanceof ActionType) && !(dec instanceof IResource)) assert (current.isEmpty());
        if (dec instanceof Event && (parent = activity.eContainer()) instanceof ActivitySet) {
            ActivitySet set = (ActivitySet)parent;
            return set.getEvents().stream().flatMap(e -> e.getItems().isEmpty() ? Stream.of(e) : e.getItems().stream()).map(TypeDefinition.class::cast).toList();
        }
        if (dec instanceof Resource) {
            Resource r = (Resource)dec;
            Set<List<? extends HasName>> candidates = ActivityParametersUtil.isDeclaration((EObject)dec) ? ActivityParametersUtil.findAllResources(EcoreUtil.getRootContainer((EObject)dec)) : ActivityParametersUtil.createResourcePossibilities(List.of(r));
            return ActivityParametersUtil.returnCandidateColumn(current, candidates);
        }
        if (dec instanceof ModelTypeDefinitionRef && (mtdr2 = (ModelTypeDefinitionRef)dec).getResource() != null && (resource = mtdr2.getResource()) instanceof Resource) {
            Resource r = resource;
            return r.getItems().isEmpty() ? List.of(r) : r.getItems();
        }
        if (dec instanceof ModelTypeDefinitionRef && (typeDefinition = (mtdr = (ModelTypeDefinitionRef)dec).getTypeDefinition()) instanceof ProductDefinition) {
            ProductDefinition pd = (ProductDefinition)typeDefinition;
            return List.of(pd);
        }
        if (dec instanceof SymbolicPosition) {
            return activity.eContents().stream().filter(HasResourcePeripheral.class::isInstance).map(HasResourcePeripheral.class::cast).filter(n -> EcoreUtility.containsCrossReference((EObject)n, (EObject)dec)).map(HasResourcePeripheral::getPeripheral).filter(Objects::nonNull).flatMap(pe -> pe.getPositions().stream()).distinct().toList();
        }
        if (dec instanceof Profile) {
            return activity.getNodes().stream().filter(Move.class::isInstance).map(Move.class::cast).filter(n -> EcoreUtility.containsCrossReference((EObject)n, (EObject)dec)).map(PeripheralAction::getPeripheral).filter(Objects::nonNull).flatMap(pe -> pe.getProfiles().stream()).distinct().toList();
        }
        if (dec instanceof ActionType) {
            Set<List<? extends HasName>> candidates = ActivityParametersUtil.findAllActionCandidates(resources);
            return ActivityParametersUtil.returnCandidateColumn(current, candidates);
        }
        return CommonUtil.collect((EObject)EcoreUtil.getRootContainer((EObject)dec), dec.getClass()).stream().map(TypeDefinition.class::cast).distinct().toList();
    }

    public static List<IResource> getResourceOrItems(IResource resource) {
        if (resource instanceof ResourceItem || resource.getResource().getItems().isEmpty()) {
            return List.of(resource);
        }
        return resource.getResource().getItems().stream().map(IResource.class::cast).toList();
    }

    public static boolean isDeclaration(EObject object) {
        return EcoreUtil.getRootContainer((EObject)object) instanceof ActivitySet;
    }

    private static Collection<? extends HasName> returnCandidateColumn(List<? extends HasName> current, Set<List<? extends HasName>> candidates) {
        LinkedHashSet result = new LinkedHashSet();
        if (current.isEmpty()) {
            candidates.stream().map(List::getFirst).distinct().forEach(result::add);
            List<HasName> finalCandidates = candidates.stream().map(List::getLast).toList();
            finalCandidates.stream().collect(Collectors.groupingBy(e -> e)).entrySet().stream().filter(e -> ((List)e.getValue()).size() == 1).map(Map.Entry::getKey).forEach(result::add);
        } else {
            candidates.stream().filter(candidate -> candidate.subList(0, current.size()).equals(current)).map(candidate -> (HasName)candidate.get(current.size())).distinct().forEach(result::add);
        }
        return result;
    }

    private static Set<List<? extends HasName>> findAllResources(EObject root) {
        List<Resource> allResources = CommonUtil.collect((EObject)root, Machine.class).stream().map(Machine::getResources).flatMap(Collection::stream).toList();
        LinkedHashSet<List<? extends HasName>> result = ActivityParametersUtil.createResourcePossibilities(allResources);
        return result;
    }

    private static LinkedHashSet<List<? extends HasName>> createResourcePossibilities(List<Resource> allResources) {
        LinkedHashSet<List<? extends HasName>> result = new LinkedHashSet<List<? extends HasName>>();
        for (Resource resource : allResources) {
            for (ResourceItem item : resource.getItems()) {
                result.add(List.of(item.getResource(), item));
            }
            if (!resource.getItems().isEmpty()) continue;
            result.add(List.of(resource));
        }
        return result;
    }

    private static Set<List<? extends HasName>> findAllActionCandidates(List<? extends IResource> resources) {
        LinkedHashSet<List<? extends HasName>> result = new LinkedHashSet<List<? extends HasName>>();
        for (IResource iResource : resources) {
            for (Peripheral per : iResource.getResource().getPeripherals()) {
                Resource mResource;
                if (iResource instanceof ResourceItem) {
                    ResourceItem item = (ResourceItem)iResource;
                    for (ActionType action : per.getType().getActions()) {
                        result.add(List.of(item.getResource(), item, per, action));
                    }
                }
                if (!(iResource instanceof Resource) || !(mResource = (Resource)iResource).getItems().isEmpty()) continue;
                for (ActionType action : per.getType().getActions()) {
                    result.add(List.of(mResource, per, action));
                }
            }
        }
        return result;
    }

    private static Activity expand(Activity activity, List<? extends Collection<? extends HasName>> parameters) {
        Activity result = (Activity)EcoreUtil.copy((EObject)activity);
        result.setOriginalName(activity.getName());
        result.setName(ActivityParametersUtil.expandName(activity, parameters));
        Iterator<? extends Collection<? extends HasName>> parIter = parameters.iterator();
        List<TypeDefinition> oldValues = ActivityParametersUtil.getDeclarations(result).subList(0, parameters.size());
        for (TypeDefinition oldValue : oldValues) {
            Collection<? extends HasName> newValue = parIter.next();
            result.getNodes().forEach(n -> ActivityParametersUtil.replace((EObject)n, (EObject)oldValue, newValue));
            result.getPrerequisites().forEach(n -> ActivityParametersUtil.replace(n, (EObject)oldValue, newValue));
            EObject eObject = oldValue.eContainer();
            if (!(eObject instanceof ParameterDeclaration)) continue;
            ParameterDeclaration pd = (ParameterDeclaration)eObject;
            pd.getDeclarations().remove((Object)oldValue);
            if (!pd.getDeclarations().isEmpty()) continue;
            result.getParameterDeclarations().remove((Object)pd);
        }
        return result;
    }

    private static void replace(EObject parent, EObject sourceElement, Collection<? extends HasName> newValue) {
        HashSet<EObject> visited = new HashSet<EObject>();
        ActivityParametersUtil.replaceRecursive(parent, sourceElement, newValue, visited);
    }

    /*
     * Unable to fully structure code
     */
    private static void replaceRecursive(Object parent, EObject sourceElement, Collection<? extends HasName> newValues, Set<EObject> visited) {
        block9: {
            block8: {
                newValue = newValues.stream().reduce((BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$48(common.HasName common.HasName ), (Lcommon/HasName;Lcommon/HasName;)Lcommon/HasName;)()).get();
                if (!(parent instanceof List)) break block8;
                list = (List)parent;
                list.forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$49(org.eclipse.emf.ecore.EObject java.util.Collection java.util.Set java.lang.Object ), (Ljava/lang/Object;)V)((EObject)sourceElement, newValues, visited));
                break block9;
            }
            if (!(parent instanceof EObject)) break block9;
            eParent = (EObject)parent;
            if (!visited.add(eParent)) {
                return;
            }
            for (EReference reference : eParent.eClass().getEAllReferences()) {
                block11: {
                    block10: {
                        if (!reference.isChangeable() || reference.isDerived()) continue;
                        object = eParent.eGet((EStructuralFeature)reference);
                        if (!reference.isMany()) break block10;
                        values = (List)object;
                        i = 0;
                        while (i < values.size()) {
                            if (values.get(i) == sourceElement) {
                                values.set(i, newValue);
                            }
                            ++i;
                        }
                        break block11;
                    }
                    if (object != sourceElement) break block11;
                    if (!(eParent instanceof HasResourceAndItem)) ** GOTO lbl-1000
                    hasResourceAndItem = (HasResourceAndItem)eParent;
                    if (newValue instanceof IResource) {
                        resource = (IResource)newValue;
                        hasResourceAndItem.setResource(resource);
                    } else if (eParent instanceof SimpleAction) {
                        simpleAction = (SimpleAction)eParent;
                        ActivityParametersUtil.setSimpleAction(simpleAction, newValues);
                    } else {
                        eParent.eSet((EStructuralFeature)reference, (Object)newValue);
                    }
                }
                if (!reference.isContainment()) continue;
                ActivityParametersUtil.replaceRecursive(object, sourceElement, newValues, visited);
            }
        }
    }

    private static void setSimpleAction(SimpleAction simpleAction, Collection<? extends HasName> newValues) {
        for (HasName hasName : newValues) {
            EditableDirectedGraph editableDirectedGraph;
            if (hasName instanceof IResource) {
                IResource res = (IResource)hasName;
                simpleAction.setResource(res);
            } else if (hasName instanceof Peripheral) {
                Peripheral per = (Peripheral)hasName;
                simpleAction.setPeripheral(per);
            } else if (hasName instanceof ActionType) {
                ActionType at = (ActionType)hasName;
                simpleAction.setType(at);
            } else {
                throw new IllegalArgumentException("Don't know how to handle value of type: " + hasName.getClass().getName());
            }
            if (simpleAction.getResource() != null || !((editableDirectedGraph = simpleAction.getGraph()) instanceof Activity)) continue;
            Activity activity = (Activity)editableDirectedGraph;
            List<IResource> resources = activity.getNodes().stream().filter(Claim.class::isInstance).map(Claim.class::cast).map(HasResourceAndItem::getResource).toList();
            for (IResource resource : resources) {
                for (Peripheral peripheral : resource.getResource().getPeripherals()) {
                    if (!peripheral.getType().getActions().contains((Object)simpleAction.getType())) continue;
                    if (simpleAction.getPeripheral() != null) {
                        throw new IllegalArgumentException("Supplied action " + simpleAction.getType().getName() + " refers to multiple peripherals: " + String.valueOf(List.of(simpleAction.getPeripheral().fqn(), peripheral.fqn())));
                    }
                    simpleAction.setResource(resource);
                    simpleAction.setPeripheral(peripheral);
                }
            }
        }
    }

    private static List<IResource> convertToIResources(List<? extends Collection<? extends HasName>> parameters) {
        ArrayList<IResource> parametersAsResource = new ArrayList<IResource>();
        for (Collection<? extends HasName> collection : parameters) {
            HasName par = collection.stream().reduce((a, b) -> b).orElse(null);
            if (par instanceof IResource) {
                IResource resource = (IResource)par;
                parametersAsResource.add(resource);
                continue;
            }
            throw new IllegalArgumentException("Expecting an IResource not a " + par.getClass().getSimpleName());
        }
        return parametersAsResource;
    }

    private static String esc(String name) {
        return name.replace(ITEM_DELIMITER, ESCAPE);
    }

    private static String unesc(String name) {
        return name.replace(ESCAPE, ITEM_DELIMITER);
    }

    private static List<? extends IResource> collectResourceCandidates(Activity activity) {
        List resources = activity.getNodes().stream().filter(Claim.class::isInstance).map(Claim.class::cast).map(HasResourceAndItem::getResource).map(ActivityParametersUtil::getResourceOrItems).flatMap(Collection::stream).toList();
        return resources;
    }

    private static /* synthetic */ HasName lambda$48(HasName a, HasName b) {
        return b;
    }

    private static /* synthetic */ void lambda$49(EObject eObject, Collection collection, Set set, Object o) {
        ActivityParametersUtil.replaceRecursive(o, eObject, collection, set);
    }
}

