/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.rename;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.refactoring.LSPTextChange;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class LSPTextChangeTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Test
    public void testPerformOperationWorkspaceFile() throws Exception {
        IProject project = TestUtils.createProject("blah");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        TextEdit edit = new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new");
        PerformChangeOperation operation = new PerformChangeOperation((Change)new LSPTextChange("test", LSPEclipseUtils.toUri((IResource)file), edit));
        operation.run((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)edit.getNewText(), (Object)LSPEclipseUtils.getDocument((IResource)file).get());
    }

    @Test
    public void testRefactoringPreview() throws Exception {
        IProject project = TestUtils.createProject("blah");
        IFile file = TestUtils.createUniqueTestFile(project, "old");
        TextEdit edit = new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new");
        LSPTextChange change = new LSPTextChange("test", LSPEclipseUtils.toUri((IResource)file), edit);
        IDocument preview = change.getPreviewDocument((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)preview.get(), (Object)"new");
    }

    @Test
    public void testPerformOperationExternalFile() throws Exception {
        File file = TestUtils.createTempFile("testPerformOperationExternalFile", ".lspt");
        Files.write(file.toPath(), "old".getBytes(), new OpenOption[0]);
        TextEdit edit = new TextEdit(new Range(new Position(0, 0), new Position(0, 3)), "new");
        PerformChangeOperation operation = new PerformChangeOperation((Change)new LSPTextChange("test", LSPEclipseUtils.toUri((File)file), edit));
        operation.run((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)edit.getNewText(), (Object)new String(Files.readAllBytes(file.toPath())));
    }
}

