/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.test.TestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ContentTypeToLanguageServerDefinitionTest {
    public static final String SERVER_TO_DISABLE = "org.eclipse.lsp4e.test.server.disable";
    public static final String DISABLED_CONTENT_TYPE = "org.eclipse.lsp4e.test.content-type-disabled";
    public static final String DISABLED_SERVER_PREF = "org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled";

    @BeforeClass
    public static void setup() {
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue(DISABLED_SERVER_PREF, "false");
    }

    @AfterClass
    public static void cleanup() {
        TestUtils.getDisabledLS().setUserEnabled(false);
    }

    @Test
    public void testDisabledLanguageServerMappingsPreference() {
        List disabledDefinitions = LanguageServersRegistry.getInstance().getContentTypeToLSPExtensions().stream().filter(lsDefinition -> !lsDefinition.isEnabled(null)).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)disabledDefinitions.size());
        Assert.assertEquals((Object)SERVER_TO_DISABLE, (Object)((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)disabledDefinitions.get((int)0)).getValue()).id);
        Assert.assertEquals((Object)DISABLED_CONTENT_TYPE, (Object)((IContentType)((ContentTypeToLanguageServerDefinition)disabledDefinitions.get(0)).getKey()).toString());
    }

    @Test
    public void testDisableLanguageServerMapping() {
        ContentTypeToLanguageServerDefinition lsDefinition = TestUtils.getDisabledLS();
        lsDefinition.setUserEnabled(false);
        Assert.assertFalse((boolean)lsDefinition.isEnabled(null));
        Assert.assertTrue((boolean)LanguageServerPlugin.getDefault().getPreferenceStore().contains(DISABLED_SERVER_PREF));
        Assert.assertFalse((boolean)LanguageServerPlugin.getDefault().getPreferenceStore().getBoolean(DISABLED_SERVER_PREF));
        lsDefinition.setUserEnabled(true);
        Assert.assertTrue((boolean)lsDefinition.isEnabled(null));
        Assert.assertTrue((boolean)LanguageServerPlugin.getDefault().getPreferenceStore().contains(DISABLED_SERVER_PREF));
        Assert.assertTrue((boolean)LanguageServerPlugin.getDefault().getPreferenceStore().getBoolean(DISABLED_SERVER_PREF));
    }
}

