/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.operations.codeactions.CodeActionMarkerResolution;
import org.eclipse.lsp4e.operations.codeactions.CommandMarkerResolution;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.internal.progress.ProgressInfoItem;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class LSPCodeActionMarkerResolution
implements IMarkerResolutionGenerator2 {
    private static final String LSP_REMEDIATION = "lspCodeActions";
    private static final IMarkerResolution2 COMPUTING = new IMarkerResolution2(){

        public void run(IMarker marker) {
        }

        public String getLabel() {
            return Messages.computing;
        }

        public Image getImage() {
            return JFaceResources.getImage((String)(String.valueOf(ProgressInfoItem.class.getPackage().getName()) + ".PROGRESS_DEFAULT"));
        }

        public String getDescription() {
            return Messages.computing;
        }
    };

    public IMarkerResolution[] getResolutions(IMarker marker) {
        Object att = null;
        try {
            att = marker.getAttribute(LSP_REMEDIATION);
            if (att == null) {
                this.checkMarkerResoultion(marker);
                att = marker.getAttribute(LSP_REMEDIATION);
            }
        }
        catch (IOException | ExecutionException | CoreException e) {
            LanguageServerPlugin.logError(e);
            return new IMarkerResolution[0];
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return new IMarkerResolution[0];
        }
        if (att == COMPUTING) {
            return new IMarkerResolution[]{COMPUTING};
        }
        if (att == null) {
            return new IMarkerResolution[0];
        }
        return (IMarkerResolution[])((List)att).stream().filter(Objects::nonNull).map(command -> (WorkbenchMarkerResolution)command.map(CommandMarkerResolution::new, CodeActionMarkerResolution::new)).toArray(IMarkerResolution[]::new);
    }

    private void checkMarkerResoultion(IMarker marker) throws IOException, CoreException, InterruptedException, ExecutionException {
        IResource res = marker.getResource();
        if (res instanceof IFile var3_4) {
            Object[] attributes = marker.getAttributes(new String[]{"languageServerId", "lspDiagnostic"});
            LanguageServers.LanguageServerProjectExecutor executor = (LanguageServers.LanguageServerProjectExecutor)((LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(file.getProject()).withCapability(ServerCapabilities::getCodeActionProvider)).withPreferredServer(LanguageServersRegistry.getInstance().getDefinition((String)attributes[0]));
            if (executor.anyMatching()) {
                Diagnostic diagnostic = (Diagnostic)attributes[1];
                CodeActionContext context = new CodeActionContext(Collections.singletonList(diagnostic));
                CodeActionParams params = new CodeActionParams();
                params.setContext(context);
                params.setTextDocument(LSPEclipseUtils.toTextDocumentIdentifier(res));
                params.setRange(diagnostic.getRange());
                marker.setAttribute(LSP_REMEDIATION, (Object)COMPUTING);
                try {
                    ((CompletableFuture)((CompletableFuture)executor.computeFirst(ls -> ls.getTextDocumentService().codeAction(params)).thenAccept(optional -> {
                        try {
                            marker.setAttribute(LSP_REMEDIATION, optional.orElse(Collections.emptyList()));
                        }
                        catch (CoreException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    })).thenRun(() -> {
                        Display display = UI.getDisplay();
                        display.asyncExec(() -> {
                            ITextViewer textViewer = UI.getActiveTextViewer();
                            if (textViewer != null) {
                                display.timerExec(500, () -> this.reinvokeQuickfixProposalsIfNecessary(textViewer));
                            }
                        });
                    })).get(300L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    LanguageServerPlugin.logWarning("Could get code actions due to timeout after 300 miliseconds in `textDocument/codeAction`", e);
                }
            }
        }
    }

    private void reinvokeQuickfixProposalsIfNecessary(ITextViewer textViewer) {
        try {
            if (textViewer instanceof ISourceViewerExtension3 var2_3 && (quickAssistant = textViewer3.getQuickAssistAssistant()) != null) {
                Field f = QuickAssistAssistant.class.getDeclaredField("fQuickAssistAssistantImpl");
                f.setAccessible(true);
                ContentAssistant ca = (ContentAssistant)f.get(quickAssistant);
                Method m = ContentAssistant.class.getDeclaredMethod("isProposalPopupActive", new Class[0]);
                m.setAccessible(true);
                boolean isProposalPopupActive = (Boolean)m.invoke((Object)ca, new Object[0]);
                if (isProposalPopupActive) {
                    quickAssistant.showPossibleQuickAssists();
                }
            }
            if ((var7_7 = textViewer) instanceof ITextViewerExtension2 && (quickAssistant = (ITextViewerExtension2)var7_7) == (ITextViewerExtension2)var7_7) {
                ITextHover hover = textViewer2.getCurrentTextHover();
                boolean bl = hoverShowing = hover != null;
                if (hoverShowing) {
                    Field f = TextViewer.class.getDeclaredField("fTextHoverManager");
                    f.setAccessible(true);
                    AbstractInformationControlManager manager = (AbstractInformationControlManager)f.get(textViewer);
                    if (manager != null) {
                        manager.showInformation();
                    }
                }
            }
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e);
        }
    }

    static boolean providesCodeActions(ServerCapabilities capabilities) {
        return capabilities != null && LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getCodeActionProvider());
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasResolutions(IMarker marker) {
        try {
            void collection;
            Collection collection2;
            Object object;
            Object remediation = marker.getAttribute(LSP_REMEDIATION);
            if (remediation == null) {
                this.checkMarkerResoultion(marker);
                remediation = marker.getAttribute(LSP_REMEDIATION);
            }
            return remediation == COMPUTING || (object = remediation) instanceof Collection && (collection2 = (Collection)object) == (Collection)object && !collection.isEmpty();
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            return false;
        }
    }
}

