/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.internal.ArrayUtil;

public final class ResourceForUriCache {
    private static final String FILE_SCHEME = "file";
    private static final Cache<URI, IResource> cache = CacheBuilder.newBuilder().maximumSize(100L).build();

    private ResourceForUriCache() {
    }

    public static @Nullable IResource get(@Nullable URI uri) {
        URI localURI = uri;
        IResource resource = null;
        if (localURI != null) {
            resource = (IResource)cache.getIfPresent((Object)localURI);
            if (resource != null) {
                return resource;
            }
            resource = ResourceForUriCache.findResourceFor(localURI);
            if (resource != null) {
                cache.put((Object)localURI, (Object)resource);
            }
        }
        return resource;
    }

    private static @Nullable IResource findResourceFor(URI uri) {
        if (FILE_SCHEME.equals(uri.getScheme())) {
            IFile file;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = wsRoot.findFilesForLocationURI(uri);
            if (files.length > 0 && (file = LSPEclipseUtils.findMostNested(files)) != null) {
                return file;
            }
            return (IResource)ArrayUtil.findFirst(wsRoot.findContainersForLocationURI(uri));
        }
        return (IResource)Adapters.adapt((Object)uri, IResource.class, (boolean)true);
    }
}

