/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Arguments for 'dataBreakpointInfo' request.
 */
@SuppressWarnings("all")
public class DataBreakpointInfoArguments {
  /**
   * Reference to the variable container if the data breakpoint is requested for a child of the container.
   * The `variablesReference` must have been obtained in the current suspended state.
   * See 'Lifetime of Object References' in the {@link DebugProtocol#Overview} section for details.
   * <p>
   * This is an optional property.
   */
  private Integer variablesReference;

  /**
   * The name of the Variable's child to obtain data breakpoint information for.
   * <p>
   * If variablesReference isn't specified, this can be an expression.
   */
  @NonNull
  private String name;

  /**
   * When `name` is an expression, evaluate it in the scope of this stack frame.
   * If not specified, the expression is evaluated in the global scope. When
   * `variablesReference` is specified, this property has no effect.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.59
   */
  private Integer frameId;

  /**
   * The mode of the desired breakpoint. If defined, this must be one of the `breakpointModes`
   * the debug adapter advertised in its `Capabilities`.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.65
   */
  private String mode;

  /**
   * Reference to the variable container if the data breakpoint is requested for a child of the container.
   * The `variablesReference` must have been obtained in the current suspended state.
   * See 'Lifetime of Object References' in the {@link DebugProtocol#Overview} section for details.
   * <p>
   * This is an optional property.
   */
  public Integer getVariablesReference() {
    return this.variablesReference;
  }

  /**
   * Reference to the variable container if the data breakpoint is requested for a child of the container.
   * The `variablesReference` must have been obtained in the current suspended state.
   * See 'Lifetime of Object References' in the {@link DebugProtocol#Overview} section for details.
   * <p>
   * This is an optional property.
   */
  public void setVariablesReference(final Integer variablesReference) {
    this.variablesReference = variablesReference;
  }

  /**
   * The name of the Variable's child to obtain data breakpoint information for.
   * <p>
   * If variablesReference isn't specified, this can be an expression.
   */
  @NonNull
  public String getName() {
    return this.name;
  }

  /**
   * The name of the Variable's child to obtain data breakpoint information for.
   * <p>
   * If variablesReference isn't specified, this can be an expression.
   */
  public void setName(@NonNull final String name) {
    this.name = Preconditions.checkNotNull(name, "name");
  }

  /**
   * When `name` is an expression, evaluate it in the scope of this stack frame.
   * If not specified, the expression is evaluated in the global scope. When
   * `variablesReference` is specified, this property has no effect.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.59
   */
  public Integer getFrameId() {
    return this.frameId;
  }

  /**
   * When `name` is an expression, evaluate it in the scope of this stack frame.
   * If not specified, the expression is evaluated in the global scope. When
   * `variablesReference` is specified, this property has no effect.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.59
   */
  public void setFrameId(final Integer frameId) {
    this.frameId = frameId;
  }

  /**
   * The mode of the desired breakpoint. If defined, this must be one of the `breakpointModes`
   * the debug adapter advertised in its `Capabilities`.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.65
   */
  public String getMode() {
    return this.mode;
  }

  /**
   * The mode of the desired breakpoint. If defined, this must be one of the `breakpointModes`
   * the debug adapter advertised in its `Capabilities`.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.65
   */
  public void setMode(final String mode) {
    this.mode = mode;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("variablesReference", this.variablesReference);
    b.add("name", this.name);
    b.add("frameId", this.frameId);
    b.add("mode", this.mode);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    DataBreakpointInfoArguments other = (DataBreakpointInfoArguments) obj;
    if (this.variablesReference == null) {
      if (other.variablesReference != null)
        return false;
    } else if (!this.variablesReference.equals(other.variablesReference))
      return false;
    if (this.name == null) {
      if (other.name != null)
        return false;
    } else if (!this.name.equals(other.name))
      return false;
    if (this.frameId == null) {
      if (other.frameId != null)
        return false;
    } else if (!this.frameId.equals(other.frameId))
      return false;
    if (this.mode == null) {
      if (other.mode != null)
        return false;
    } else if (!this.mode.equals(other.mode))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.variablesReference== null) ? 0 : this.variablesReference.hashCode());
    result = prime * result + ((this.name== null) ? 0 : this.name.hashCode());
    result = prime * result + ((this.frameId== null) ? 0 : this.frameId.hashCode());
    return prime * result + ((this.mode== null) ? 0 : this.mode.hashCode());
  }
}
