/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.beanvalidation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.JakartaCodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.RemoveAnnotationProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;

public class RemoveDynamicConstraintAnnotationQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(RemoveDynamicConstraintAnnotationQuickFix.class.getName());
    public static final String ANNOTATION_NAME_KEY = "annotation.name";

    @Override
    public String getParticipantId() {
        return RemoveDynamicConstraintAnnotationQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        String annotationName = diagnostic.getData().toString().replace("\"", "");
        String label = RemoveDynamicConstraintAnnotationQuickFix.getLabel(annotationName);
        ASTNode node = context.getCoveredNode();
        IBinding parentType = RemoveDynamicConstraintAnnotationQuickFix.getBinding(node);
        ArrayList<ExtendedCodeAction> codeActions = new ArrayList<ExtendedCodeAction>();
        if (parentType != null) {
            ExtendedCodeAction codeAction = new ExtendedCodeAction(label);
            codeAction.setRelevance(0);
            codeAction.setKind("quickfix");
            codeAction.setDiagnostics(Arrays.asList(diagnostic));
            HashMap<String, Object> extendedData = new HashMap<String, Object>();
            extendedData.put(ANNOTATION_NAME_KEY, annotationName);
            codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), JakartaCodeActionId.RemoveConstraintAnnotation));
            codeActions.add(codeAction);
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        IBinding parentType = RemoveDynamicConstraintAnnotationQuickFix.getBinding(node);
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        String annotationName = (String)data.getExtendedDataEntry(ANNOTATION_NAME_KEY);
        String label = RemoveDynamicConstraintAnnotationQuickFix.getLabel(annotationName);
        RemoveAnnotationProposal proposal = new RemoveAnnotationProposal(label, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, context.getCoveredNode().getParent(), annotationName);
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to resolve code action to remove a constraint annotation", e);
        }
        return toResolve;
    }

    private static String getLabel(String annotationName) {
        return Messages.getMessage("RemoveConstraintAnnotation", annotationName);
    }

    protected static IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }
}

