/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.jsonp;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.junit.Test;

public class JakartaJsonpTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void invalidPointerTarget() throws Exception {
        IJavaProject javaProject = JakartaJsonpTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jsonp/CreatePointerInvalidTarget.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(20, 60, 64, "Json.createPointer target must be a sequence of '/' prefixed tokens or an empty String.", DiagnosticSeverity.Error, "jakarta-jsonp", "InvalidJsonCreatePointerTarget");
        Diagnostic d2 = JakartaForJavaAssert.d(21, 62, 70, "Json.createPointer target must be a sequence of '/' prefixed tokens or an empty String.", DiagnosticSeverity.Error, "jakarta-jsonp", "InvalidJsonCreatePointerTarget");
        Diagnostic d3 = JakartaForJavaAssert.d(22, 60, 80, "Json.createPointer target must be a sequence of '/' prefixed tokens or an empty String.", DiagnosticSeverity.Error, "jakarta-jsonp", "InvalidJsonCreatePointerTarget");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2, d3);
    }
}

