/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.metadata;

import java.util.List;
import org.eclipse.lsp4mp.commons.metadata.ConverterKind;
import org.eclipse.lsp4mp.commons.metadata.ItemBase;

public class ItemHint
extends ItemBase {
    private List<ValueHint> values;

    public List<ValueHint> getValues() {
        return this.values;
    }

    public void setValues(List<ValueHint> values) {
        this.values = values;
    }

    public ValueHint getValue(String value, List<ConverterKind> converterKinds) {
        if (this.values == null || value == null) {
            return null;
        }
        for (ValueHint valueHint : this.values) {
            if (converterKinds != null) {
                for (ConverterKind converterKind : converterKinds) {
                    if (!value.equals(valueHint.getValue(converterKind))) continue;
                    return valueHint;
                }
                continue;
            }
            if (!value.equals(valueHint.getValue())) continue;
            return valueHint;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemHint other = (ItemHint)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public static class ValueHint {
        private String value;
        private String description;
        private String sourceType;

        public String getValue() {
            return this.value;
        }

        public String getValue(ConverterKind converterKind) {
            return ConverterKind.convert(this.getValue(), converterKind);
        }

        public String getPreferredValue(List<ConverterKind> converterKinds) {
            ConverterKind preferredConverter = converterKinds != null && !converterKinds.isEmpty() ? converterKinds.get(0) : null;
            return this.getValue(preferredConverter);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueHint other = (ValueHint)obj;
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.sourceType == null ? other.sourceType != null : !this.sourceType.equals(other.sourceType)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

