/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.metrics.java;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.InsertAnnotationMissingQuickFix;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.java.corrections.proposal.ReplaceAnnotationProposal;

public class ApplicationScopedAnnotationMissingQuickFix
extends InsertAnnotationMissingQuickFix {
    private static final String[] REMOVE_ANNOTATION_NAMES = new String[]{"RequestScoped", "SessionScoped", "Dependent"};

    public ApplicationScopedAnnotationMissingQuickFix() {
        super("javax.enterprise.context.ApplicationScoped");
    }

    @Override
    protected void insertAnnotations(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions) throws CoreException {
        String[] annotations;
        String[] stringArray = annotations = this.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            ApplicationScopedAnnotationMissingQuickFix.insertAndReplaceAnnotation(diagnostic, context, parentType, codeActions, annotation);
            ++n2;
        }
    }

    private static void insertAndReplaceAnnotation(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, String annotation) throws CoreException {
        String name = ApplicationScopedAnnotationMissingQuickFix.getLabel(annotation);
        ReplaceAnnotationProposal proposal = new ReplaceAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, annotation, REMOVE_ANNOTATION_NAMES);
        CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
    }

    private static String getLabel(String annotation) {
        StringBuilder name = new StringBuilder("Replace current scope with ");
        String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
        name.append("@");
        name.append(annotationName);
        return name.toString();
    }
}

