/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.jaxrs;

import java.util.Collections;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;

public class JaxRsUtils {
    private JaxRsUtils() {
    }

    public static String getJaxRsPathValue(IAnnotatable annotatable) throws JavaModelException {
        IAnnotation annotationPath = AnnotationUtils.getAnnotation(annotatable, "javax.ws.rs.Path");
        return annotationPath != null ? AnnotationUtils.getAnnotationMemberValue(annotationPath, "value") : null;
    }

    public static String getJaxRsApplicationPathValue(IAnnotatable annotatable) throws JavaModelException {
        IAnnotation annotationPath = AnnotationUtils.getAnnotation(annotatable, "javax.ws.rs.ApplicationPath");
        return annotationPath != null ? AnnotationUtils.getAnnotationMemberValue(annotationPath, "value") : null;
    }

    public static boolean isJaxRsRequestMethod(IMethod method) throws JavaModelException {
        return AnnotationUtils.hasAnnotation((IAnnotatable)method, "javax.ws.rs.GET");
    }

    public static CodeLens createURLCodeLens(String baseURL, String rootPath, String openURICommandId, IMethod method, IJDTUtils utils) throws JavaModelException {
        CodeLens lens = JaxRsUtils.createURLCodeLens(method, utils);
        if (lens != null) {
            String pathValue = JaxRsUtils.getJaxRsPathValue((IAnnotatable)method);
            String url = JaxRsUtils.buildURL(baseURL, rootPath, pathValue);
            lens.setCommand(new Command(url, openURICommandId != null ? openURICommandId : "", Collections.singletonList(url)));
        }
        return lens;
    }

    private static CodeLens createURLCodeLens(IMethod method, IJDTUtils utils) throws JavaModelException {
        ISourceRange r = method.getNameRange();
        if (r == null) {
            return null;
        }
        CodeLens lens = new CodeLens();
        Range range = utils.toRange(method.getOpenable(), r.getOffset(), r.getLength());
        lens.setRange(range);
        return lens;
    }

    public static String buildURL(String ... paths) {
        StringBuilder url = new StringBuilder();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path != null && !path.isEmpty()) {
                if (url.length() > 0 && path.charAt(0) == '/') {
                    path = path.substring(1, path.length());
                }
                if (url.length() > 0 && url.charAt(url.length() - 1) != '/') {
                    url.append('/');
                }
                url.append(path);
            }
            ++n2;
        }
        return url.toString();
    }
}

