/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.jdt.core.project.AbstractConfigSource;
import org.eclipse.lsp4mp.jdt.core.project.MicroProfileConfigPropertyInformation;

public class PropertiesConfigSource
extends AbstractConfigSource<Properties> {
    public PropertiesConfigSource(String configFileName, String profile, int ordinal, IJavaProject javaProject) {
        super(configFileName, profile, ordinal, javaProject);
    }

    public PropertiesConfigSource(String configFileName, IJavaProject javaProject) {
        super(configFileName, javaProject);
    }

    public PropertiesConfigSource(String configFileName, int ordinal, IJavaProject javaProject) {
        super(configFileName, ordinal, javaProject);
    }

    @Override
    public String getProperty(String key) {
        Properties properties = (Properties)this.getConfig();
        return properties != null ? properties.getProperty(key) : null;
    }

    @Override
    protected Properties loadConfig(InputStream input) throws IOException {
        Properties properties = new Properties();
        properties.load(input);
        String profile = this.getProfile();
        if (profile != null) {
            Properties adjustedProperties = new Properties();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> {
                if (!((String)key).startsWith("%")) {
                    adjustedProperties.putIfAbsent("%" + profile + "." + key, val);
                }
            }));
            return adjustedProperties;
        }
        return properties;
    }

    @Override
    protected Map<String, List<MicroProfileConfigPropertyInformation>> loadPropertyInformations() {
        Properties config = (Properties)super.getConfig();
        HashMap<String, List<MicroProfileConfigPropertyInformation>> propertiesMap = new HashMap<String, List<MicroProfileConfigPropertyInformation>>();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> {
            if (key != null) {
                String propertyKeyWithProfile = key.toString();
                String propertyValue = val != null ? val.toString() : null;
                String propertyKey = MicroProfileConfigPropertyInformation.getPropertyNameWithoutProfile(propertyKeyWithProfile);
                ArrayList<MicroProfileConfigPropertyInformation> info = (ArrayList<MicroProfileConfigPropertyInformation>)propertiesMap.get(propertyKey);
                if (info == null) {
                    info = new ArrayList<MicroProfileConfigPropertyInformation>();
                    propertiesMap.put(propertyKey, info);
                }
                info.add(new MicroProfileConfigPropertyInformation(propertyKeyWithProfile, propertyValue, this.getSourceConfigFileURI(), this.getConfigFileName()));
            }
        }));
        return propertiesMap;
    }
}

