/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.config.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4mp.commons.CodeActionResolveData;
import org.eclipse.lsp4mp.commons.MicroProfileCodeActionFactory;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSource;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProject;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.ls.commons.CodeActionFactory;

public class NoValueAssignedToPropertyQuickFix
implements IJavaCodeActionParticipant {
    private static final String CODE_ACTION_LABEL = "Insert ''{0}'' property in ''{1}''";
    private static final String PROPERTY_NAME_KEY = "propertyName";
    private static final String CONFIG_TEXT_DOCUMENT_URI_KEY = "uri";

    @Override
    public String getParticipantId() {
        return NoValueAssignedToPropertyQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        IJavaProject javaProject = context.getJavaProject();
        String lineSeparator = context.getCompilationUnit().findRecommendedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = System.lineSeparator();
        }
        String propertyName = NoValueAssignedToPropertyQuickFix.getPropertyName(diagnostic, context);
        String insertText = String.valueOf(propertyName) + "=" + lineSeparator;
        JDTMicroProfileProject mpProject = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(javaProject);
        List<IConfigSource> configSources = mpProject.getConfigSources();
        for (IConfigSource configSource : configSources) {
            String uri = configSource.getSourceConfigFileURI();
            if (uri == null) continue;
            TextDocumentItem document = new TextDocumentItem(uri, "properties", 0, insertText);
            CodeAction codeAction = CodeActionFactory.insert(NoValueAssignedToPropertyQuickFix.getTitle(propertyName, configSource.getConfigFileName()), new Position(0, 0), insertText, document, diagnostic);
            codeActions.add(codeAction);
        }
        if (context.getParams().isCommandConfigurationUpdateSupported()) {
            codeActions.add(MicroProfileCodeActionFactory.createAddToUnassignedExcludedCodeAction(propertyName, diagnostic));
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction unresolved = context.getUnresolved();
        CodeActionResolveData data = (CodeActionResolveData)context.getUnresolved().getData();
        String uri = (String)data.getExtendedDataEntry(CONFIG_TEXT_DOCUMENT_URI_KEY);
        String propertyName = (String)data.getExtendedDataEntry(PROPERTY_NAME_KEY);
        String lineSeparator = null;
        try {
            lineSeparator = context.getCompilationUnit().findRecommendedLineSeparator();
        }
        catch (JavaModelException javaModelException) {}
        if (lineSeparator == null) {
            lineSeparator = System.lineSeparator();
        }
        String insertText = String.valueOf(propertyName) + "=" + lineSeparator;
        TextDocumentEdit tde = NoValueAssignedToPropertyQuickFix.insertTextEdit(new TextDocumentItem(uri, "properties", 0, insertText), insertText, new Position(0, 0));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)tde)));
        unresolved.setEdit(workspaceEdit);
        return unresolved;
    }

    private static TextDocumentEdit insertTextEdit(TextDocumentItem document, String insertText, Position position) {
        VersionedTextDocumentIdentifier documentId = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        TextEdit te = new TextEdit(new Range(position, position), insertText);
        return new TextDocumentEdit(documentId, Collections.singletonList(te));
    }

    private static String getPropertyName(Diagnostic diagnostic, JavaCodeActionContext context) throws JavaModelException {
        JsonObject data;
        JsonElement name;
        if (diagnostic.getData() != null && (name = (data = (JsonObject)diagnostic.getData()).get("name")) != null) {
            return name.getAsString();
        }
        Position hoverPosition = diagnostic.getRange().getStart();
        IJDTUtils utils = context.getUtils();
        ITypeRoot typeRoot = context.getTypeRoot();
        int offset = utils.toOffset(typeRoot.getBuffer(), hoverPosition.getLine(), hoverPosition.getCharacter());
        IJavaElement hoverElement = typeRoot.getElementAt(offset);
        IAnnotation configPropertyAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)hoverElement, "org.eclipse.microprofile.config.inject.ConfigProperty");
        return AnnotationUtils.getAnnotationMemberValue(configPropertyAnnotation, "name");
    }

    private static String getTitle(String propertyName, String configFileName) {
        return MessageFormat.format(CODE_ACTION_LABEL, propertyName, configFileName);
    }
}

