/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfilePropertyDocumentationParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.PropertiesManager;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesManagerDocumentationTest
extends BasePropertiesManagerTest {
    @Test
    public void testCollectDocumentationMarkdown() throws Exception {
        IJavaProject javaProject = PropertiesManagerDocumentationTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IFile propertiesFile = javaProject.getProject().getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfilePropertyDocumentationParams params = this.createDocParams(propertiesFileUri, "org.acme.config.GreetingResource", "number", null, DocumentFormat.Markdown);
        String documentation = PropertiesManager.getInstance().collectPropertyDocumentation(params, JDT_UTILS, null);
        Assert.assertEquals((Object)"The `number` of the greeting.", (Object)documentation);
    }

    @Test
    public void testCollectDocumentationPlainText() throws Exception {
        IJavaProject javaProject = PropertiesManagerDocumentationTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IFile propertiesFile = javaProject.getProject().getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfilePropertyDocumentationParams params = this.createDocParams(propertiesFileUri, "org.acme.config.GreetingResource", "number", null, DocumentFormat.PlainText);
        String documentation = PropertiesManager.getInstance().collectPropertyDocumentation(params, JDT_UTILS, null);
        Assert.assertEquals((Object)" The number of the greeting. ", (Object)documentation);
    }

    @Test
    public void testCollectDocumentationForNoDocs() throws Exception {
        IJavaProject javaProject = PropertiesManagerDocumentationTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IFile propertiesFile = javaProject.getProject().getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfilePropertyDocumentationParams params = this.createDocParams(propertiesFileUri, "org.acme.config.GreetingResource", "suffix", null, DocumentFormat.Markdown);
        String documentation = PropertiesManager.getInstance().collectPropertyDocumentation(params, JDT_UTILS, null);
        Assert.assertEquals(null, (Object)documentation);
        params.setDocumentFormat(DocumentFormat.PlainText);
        documentation = PropertiesManager.getInstance().collectPropertyDocumentation(params, JDT_UTILS, null);
        Assert.assertEquals(null, (Object)documentation);
    }

    public MicroProfilePropertyDocumentationParams createDocParams(String uri, String sourceType, String sourceField, String sourceMethod, DocumentFormat documentFormat) {
        MicroProfilePropertyDocumentationParams params = new MicroProfilePropertyDocumentationParams();
        params.setUri(uri);
        params.setSourceType(sourceType);
        params.setSourceField(sourceField);
        params.setSourceMethod(sourceMethod);
        params.setDocumentFormat(documentFormat);
        return params;
    }
}

