/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.snippets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4mp.commons.JavaCursorContextKind;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCompletionParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class JavaFileCursorContextTest
extends BasePropertiesManagerTest {
    private static final IProgressMonitor MONITOR = new NullProgressMonitor();

    @After
    public void cleanUp() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/Empty.java"));
        javaFile.refreshLocal(0, null);
        javaFile.setContents((InputStream)new ByteArrayInputStream("".getBytes()), 0, MONITOR);
    }

    @Test
    public void testEmptyFileContext() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/Empty.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_EMPTY_FILE, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testJustSnippetFileContext() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/Empty.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        javaFile.refreshLocal(0, null);
        javaFile.setContents((InputStream)new ByteArrayInputStream("rest_class".getBytes()), 0, MONITOR);
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, "rest_class".length()));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_EMPTY_FILE, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_EMPTY_FILE, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, 4));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_EMPTY_FILE, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testBeforeFieldContext() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(15, 4));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_FIELD_ANNOTATIONS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(14, 4));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_FIELD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testBeforeMethodContext() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(34, 4));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_METHOD_ANNOTATIONS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(32, 4));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_METHOD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testInMethodContext() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(35, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.NONE, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(34, 5));
        Assert.assertEquals((Object)JavaCursorContextKind.NONE, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testInClassContext() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(37, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_CLASS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testAfterClassContext() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(38, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.NONE, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testClassContextUsingInterface() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/MyInterface.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(3, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_FIELD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(7, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_CLASS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testClassContextUsingEnum() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/MyEnum.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(3, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_FIELD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(7, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_METHOD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(9, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_CLASS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testClassContextUsingAnnotation() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/MyAnnotation.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(3, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_FIELD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(5, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_METHOD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(7, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_CLASS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testBeforeClassContext() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/MyNestedClass.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(4, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_CLASS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(5, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_CLASS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(6, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_CLASS_ANNOTATIONS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(1, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_CLASS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(3, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.IN_CLASS_ANNOTATIONS, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }

    @Test
    public void testAtBeginningOfFile() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/Empty.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, 0));
        Assert.assertEquals((Object)"", (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getPrefix());
    }

    @Test
    public void testOneWord() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/Empty.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        javaFile.refreshLocal(0, null);
        javaFile.setContents((InputStream)new ByteArrayInputStream("rest_class".getBytes()), 0, MONITOR);
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, "rest_class".length()));
        Assert.assertEquals((Object)"rest_class", (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getPrefix());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, 0));
        Assert.assertEquals((Object)"", (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getPrefix());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, 5));
        Assert.assertEquals((Object)"rest_", (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getPrefix());
    }

    @Test
    public void testTwoWords() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/Empty.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        javaFile.refreshLocal(0, null);
        javaFile.setContents((InputStream)new ByteArrayInputStream("asdf hjkl".getBytes()), 0, MONITOR);
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, 8));
        Assert.assertEquals((Object)"hjk", (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getPrefix());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(0, 5));
        Assert.assertEquals((Object)"", (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getPrefix());
    }

    @Test
    public void testLombok() throws Exception {
        IJavaProject javaProject = JavaFileCursorContextTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/WithLombok.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(6, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_FIELD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
        params = new MicroProfileJavaCompletionParams(javaFileUri, new Position(8, 0));
        Assert.assertEquals((Object)JavaCursorContextKind.BEFORE_METHOD, (Object)PropertiesManagerForJava.javaCursorContext((MicroProfileJavaCompletionParams)params, (IJDTUtils)JDT_UTILS, (IProgressMonitor)MONITOR).getKind());
    }
}

