/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.commons.ClasspathKind;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileAssert;
import org.eclipse.lsp4mp.jdt.core.PropertiesManager;
import org.eclipse.lsp4mp.jdt.internal.core.utils.DependencyUtil;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesManagerClassPathKindTest
extends BasePropertiesManagerTest {
    @Test
    public void configQuickstartTest() throws Exception {
        IJavaProject javaProject = PropertiesManagerClassPathKindTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart_test);
        IFile fileFromNone = javaProject.getProject().getFile((IPath)new Path("application.properties"));
        MicroProfileProjectInfo infoFromNone = PropertiesManager.getInstance().getMicroProfileProjectInfo(fileFromNone, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES, JDT_UTILS, DocumentFormat.Markdown, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)ClasspathKind.NONE, (Object)infoFromNone.getClasspathKind());
        Assert.assertEquals((long)0L, (long)infoFromNone.getProperties().size());
        File resteasyJARFile = DependencyUtil.getArtifact((String)"io.quarkus", (String)"quarkus-resteasy-common-deployment", (String)"1.0.0.CR1", null, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"quarkus-resteasy-common-deployment*.jar is missing", (Object)resteasyJARFile);
        IFile fileFromSrc = javaProject.getProject().getFile((IPath)new Path("src/main/resources/application.properties"));
        MicroProfileProjectInfo infoFromSrc = PropertiesManager.getInstance().getMicroProfileProjectInfo(fileFromSrc, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES, JDT_UTILS, DocumentFormat.Markdown, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)ClasspathKind.SRC, (Object)infoFromSrc.getClasspathKind());
        MicroProfileAssert.assertProperties(infoFromSrc, 11, MicroProfileAssert.p(null, "greeting.message", "java.lang.String", null, false, "org.acme.config.GreetingResource", "message", null, 0, null), MicroProfileAssert.p(null, "greeting.suffix", "java.lang.String", null, false, "org.acme.config.GreetingResource", "suffix", null, 0, "!"), MicroProfileAssert.p(null, "greeting.name", "java.util.Optional", null, false, "org.acme.config.GreetingResource", "name", null, 0, null));
        MicroProfileAssert.assertPropertiesDuplicate(infoFromSrc);
        File undertowJARFile = DependencyUtil.getArtifact((String)"io.quarkus", (String)"quarkus-undertow-deployment", (String)"1.0.0.CR1", null, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"quarkus-undertow-deployment*.jar is missing", (Object)undertowJARFile);
        IFile filefromTest = javaProject.getProject().getFile((IPath)new Path("src/test/resources/application.properties"));
        MicroProfileProjectInfo infoFromTest = PropertiesManager.getInstance().getMicroProfileProjectInfo(filefromTest, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES, JDT_UTILS, DocumentFormat.Markdown, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)ClasspathKind.TEST, (Object)infoFromTest.getClasspathKind());
        MicroProfileAssert.assertProperties(infoFromTest, 14, MicroProfileAssert.p(null, "greeting.message", "java.lang.String", null, false, "org.acme.config.GreetingResource", "message", null, 0, null), MicroProfileAssert.p(null, "greeting.suffix", "java.lang.String", null, false, "org.acme.config.GreetingResource", "suffix", null, 0, "!"), MicroProfileAssert.p(null, "greeting.name", "java.util.Optional", null, false, "org.acme.config.GreetingResource", "name", null, 0, null), MicroProfileAssert.p(null, "greeting.message.test", "java.lang.String", null, false, "org.acme.config.TestResource", "message", null, 0, null), MicroProfileAssert.p(null, "greeting.suffix.test", "java.lang.String", null, false, "org.acme.config.TestResource", "suffix", null, 0, "!"), MicroProfileAssert.p(null, "greeting.name.test", "java.util.Optional", null, false, "org.acme.config.TestResource", "name", null, 0, null));
        MicroProfileAssert.assertPropertiesDuplicate(infoFromTest);
    }
}

