/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.apt.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.apt.internal.AnnotationProcessorConfiguration;
import org.eclipse.m2e.apt.internal.AptConfiguratorDelegate;
import org.eclipse.m2e.apt.internal.utils.ProjectUtils;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAptConfiguratorDelegate
implements AptConfiguratorDelegate {
    private static final String M2E_APT_KEY = "m2e-apt";
    private static final String M2_REPO = "M2_REPO";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAptConfiguratorDelegate.class);
    private static Method setGenTestSrcDirMethod = null;
    protected IMavenProjectFacade mavenFacade;
    protected MavenSession mavenSession;

    static {
        try {
            setGenTestSrcDirMethod = AptConfig.class.getMethod("setGenTestSrcDir", IJavaProject.class, String.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    @Override
    public void setSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    @Override
    public void setFacade(IMavenProjectFacade mavenProjectFacade) {
        this.mavenFacade = mavenProjectFacade;
    }

    @Override
    public boolean isIgnored(IProgressMonitor monitor) {
        return false;
    }

    @Override
    public AbstractBuildParticipant getMojoExecutionBuildParticipant(MojoExecution execution) {
        return null;
    }

    @Override
    public void configureProject(IProgressMonitor monitor) throws CoreException {
        Map<String, String> newOptions;
        IProject eclipseProject = this.mavenFacade.getProject();
        AnnotationProcessorConfiguration configuration = this.getAnnotationProcessorConfiguration(monitor);
        if (configuration == null) {
            return;
        }
        if (!eclipseProject.hasNature("org.eclipse.jdt.core.javanature")) {
            AbstractProjectConfigurator.addNature((IProject)eclipseProject, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
        }
        File generatedSourcesDirectory = configuration.getOutputDirectory();
        File generatedTestSourcesDirectory = configuration.getTestOutputDirectory();
        if (generatedSourcesDirectory == null && generatedTestSourcesDirectory == null) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)eclipseProject);
        LinkedHashSet<File> resolvedJarArtifacts = new LinkedHashSet<File>(this.getJars(configuration.getDependencies()));
        if (configuration.isAddProjectDependencies()) {
            List<Artifact> artifacts = ProjectUtils.getProjectArtifacts(this.mavenFacade);
            resolvedJarArtifacts.addAll(ProjectUtils.filterToResolvedJars(artifacts));
        }
        boolean isAnnotationProcessingEnabled = configuration.isAnnotationProcessingEnabled() && ProjectUtils.containsAptProcessors(resolvedJarArtifacts);
        AptConfig.setEnabled((IJavaProject)javaProject, (boolean)isAnnotationProcessingEnabled);
        if (!isAnnotationProcessingEnabled) {
            return;
        }
        LOG.debug("Enabling APT support on {}", (Object)eclipseProject.getName());
        if (generatedSourcesDirectory != null) {
            File generatedSourcesRelativeDirectory = ProjectUtils.convertToProjectRelativePath(eclipseProject, generatedSourcesDirectory);
            String generatedSourcesRelativeDirectoryPath = generatedSourcesRelativeDirectory.getPath();
            AptConfig.setGenSrcDir((IJavaProject)javaProject, (String)generatedSourcesRelativeDirectoryPath);
        }
        if (generatedTestSourcesDirectory != null && setGenTestSrcDirMethod != null) {
            File generatedTestSourcesRelativeDirectory = ProjectUtils.convertToProjectRelativePath(eclipseProject, generatedTestSourcesDirectory);
            String generatedTestSourcesRelativeDirectoryPath = generatedTestSourcesRelativeDirectory.getPath();
            try {
                setGenTestSrcDirMethod.invoke(null, javaProject, generatedTestSourcesRelativeDirectoryPath);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        ArrayList<File> resolvedJarArtifactsInReverseOrder = new ArrayList<File>(resolvedJarArtifacts);
        Collections.reverse(resolvedJarArtifactsInReverseOrder);
        IFactoryPath factoryPath = AptConfig.getDefaultFactoryPath((IJavaProject)javaProject);
        for (FactoryContainer fc : ((FactoryPath)factoryPath).getEnabledContainers().keySet()) {
            if (!FactoryContainer.FactoryType.PLUGIN.equals((Object)fc.getType())) continue;
            factoryPath.disablePlugin(fc.getId());
        }
        IPath m2RepoPath = JavaCore.getClasspathVariable((String)M2_REPO);
        for (File resolvedJarArtifact : resolvedJarArtifactsInReverseOrder) {
            Path absolutePath = new Path(resolvedJarArtifact.getAbsolutePath());
            if (m2RepoPath != null && m2RepoPath.isPrefixOf((IPath)absolutePath)) {
                IPath relativePath = absolutePath.removeFirstSegments(m2RepoPath.segmentCount()).makeRelative().setDevice(null);
                IPath variablePath = new Path(M2_REPO).append(relativePath);
                factoryPath.addVarJar(variablePath);
                continue;
            }
            factoryPath.addExternalJar(resolvedJarArtifact);
        }
        Map currentOptions = AptConfig.getRawProcessorOptions((IJavaProject)javaProject);
        if (!currentOptions.equals(newOptions = configuration.getAnnotationProcessorOptions())) {
            AptConfig.setProcessorOptions(newOptions, (IJavaProject)javaProject);
        }
        AptConfig.setFactoryPath((IJavaProject)javaProject, (IFactoryPath)factoryPath);
    }

    private List<File> getJars(List<File> files) {
        if (files == null || files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<File> jars = new ArrayList<File>(files);
        Iterator ite = jars.iterator();
        while (ite.hasNext()) {
            File jar = (File)ite.next();
            if (ProjectUtils.isJar(jar)) continue;
            ite.remove();
        }
        return jars;
    }

    @Override
    public void configureClasspath(IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        File generatedTestSourcesDirectory;
        AnnotationProcessorConfiguration configuration = this.getAnnotationProcessorConfiguration(monitor);
        if (configuration == null || !configuration.isAnnotationProcessingEnabled()) {
            return;
        }
        File generatedSourcesDirectory = configuration.getOutputDirectory();
        MavenProject mavenProject = this.mavenFacade.getMavenProject();
        IProject eclipseProject = this.mavenFacade.getProject();
        if (generatedSourcesDirectory != null) {
            this.addToClassPath(eclipseProject, generatedSourcesDirectory, null, classpath, false);
        }
        if ((generatedTestSourcesDirectory = configuration.getTestOutputDirectory()) != null) {
            File outputFolder = new File(mavenProject.getBuild().getTestOutputDirectory());
            this.addToClassPath(eclipseProject, generatedTestSourcesDirectory, outputFolder, classpath, true);
        }
    }

    protected abstract AnnotationProcessorConfiguration getAnnotationProcessorConfiguration(IProgressMonitor var1) throws CoreException;

    private void addToClassPath(IProject project, File sourceDirectory, File targetDirectory, IClasspathDescriptor classpath, boolean isTest) {
        File generatedSourcesRelativeDirectory = ProjectUtils.convertToProjectRelativePath(project, sourceDirectory);
        String generatedSourcesRelativeDirectoryPath = generatedSourcesRelativeDirectory.getPath();
        IFolder generatedSourcesFolder = project.getFolder(generatedSourcesRelativeDirectoryPath);
        IPath outputPath = null;
        if (targetDirectory != null) {
            File outputRelativeFile = ProjectUtils.convertToProjectRelativePath(project, targetDirectory);
            IFolder outputFolder = project.getFolder(outputRelativeFile.getPath());
            outputPath = outputFolder.getFullPath();
        }
        IPath[] includes = new IPath[]{};
        IPath[] excludes = new IPath[]{};
        if (generatedSourcesFolder != null && generatedSourcesFolder.getProject().equals((Object)project)) {
            IClasspathEntryDescriptor enclosing = AbstractAptConfiguratorDelegate.getEnclosingEntryDescriptor(classpath, generatedSourcesFolder.getFullPath());
            if (enclosing == null || this.getEntryDescriptor(classpath, generatedSourcesFolder.getFullPath()) != null) {
                IClasspathEntryDescriptor entry = classpath.addSourceEntry(generatedSourcesFolder.getFullPath(), outputPath, includes, excludes, true);
                entry.setClasspathAttribute("ignore_optional_problems", "true");
                entry.setClasspathAttribute(M2E_APT_KEY, "true");
                if (isTest && setGenTestSrcDirMethod != null) {
                    IClasspathEntry[] iClasspathEntryArray = classpath.getEntries();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                        IClasspathAttribute[] iClasspathAttributeArray = classpathEntry.getExtraAttributes();
                        int n3 = iClasspathAttributeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IClasspathAttribute attribute = iClasspathAttributeArray[n4];
                            if ("test".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                                entry.setClasspathAttribute("test", "true");
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        } else if (generatedSourcesFolder != null) {
            classpath.removeEntry(generatedSourcesFolder.getFullPath());
        }
    }

    private static IClasspathEntryDescriptor getEnclosingEntryDescriptor(IClasspathDescriptor classpath, IPath path) {
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (!cped.getPath().isPrefixOf(path)) continue;
            return cped;
        }
        return null;
    }

    private IClasspathEntryDescriptor getEntryDescriptor(IClasspathDescriptor classpath, IPath fullPath) {
        ArrayList<IPath> stalePaths = new ArrayList<IPath>();
        IClasspathEntryDescriptor matchingDescriptor = null;
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (cped.getPath().equals((Object)fullPath)) {
                matchingDescriptor = cped;
                continue;
            }
            if (!Boolean.parseBoolean((String)cped.getClasspathAttributes().get(M2E_APT_KEY))) continue;
            stalePaths.add(cped.getPath());
        }
        for (IPath stalePath : stalePaths) {
            classpath.removeEntry(stalePath);
        }
        return matchingDescriptor;
    }

    protected <T> T getParameterValue(String parameter, Class<T> asType, MojoExecution mojoExecution) throws CoreException {
        PluginExecution execution = new PluginExecution();
        execution.setConfiguration((Object)mojoExecution.getConfiguration());
        MavenProject mavenProject = this.mavenFacade.getMavenProject();
        return (T)this.mavenFacade.createExecutionContext().execute(mavenProject, (context, monitor) -> MavenPlugin.getMaven().getMojoParameterValue(mavenProject, parameter, asType, mojoExecution.getPlugin(), (ConfigurationContainer)execution, mojoExecution.getGoal(), null), null);
    }
}

