/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AutomaticModuleNaming;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.internal.ClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.internal.InternalModuleInfo;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleSupport {
    public static final String MODULE_INFO_JAVA = "module-info.java";
    private static final Logger log = LoggerFactory.getLogger(ModuleSupport.class);

    public static void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) {
        InternalModuleInfo moduleInfo;
        IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
        if (javaProject == null || !javaProject.exists() || classpath == null) {
            return;
        }
        int targetCompliance = 8;
        String option = javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        if (option != null) {
            if (option.startsWith("1.")) {
                option = option.substring("1.".length());
            }
            try {
                targetCompliance = Integer.parseInt(option);
            }
            catch (NumberFormatException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (targetCompliance < 9) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((moduleInfo = ModuleSupport.getModuleInfo(javaProject, monitor)) == null) {
            return;
        }
        LinkedHashMap<String, InternalModuleInfo> entryModuleInfos = new LinkedHashMap<String, InternalModuleInfo>();
        LinkedHashMap<String, IClasspathEntryDescriptor> entryDescriptors = new LinkedHashMap<String, IClasspathEntryDescriptor>();
        for (IClasspathEntryDescriptor entryDescriptor : classpath.getEntryDescriptors()) {
            if (monitor.isCanceled()) {
                return;
            }
            InternalModuleInfo entryModuleInfo = ModuleSupport.getModuleInfo(entryDescriptor, monitor, targetCompliance);
            if (entryModuleInfo == null) continue;
            entryModuleInfos.put(entryModuleInfo.name, entryModuleInfo);
            entryDescriptors.put(entryModuleInfo.name, entryDescriptor);
        }
        Set<String> neededModuleNames = ModuleSupport.collectModulesNeededTransitively(moduleInfo, entryModuleInfos);
        if (monitor.isCanceled()) {
            return;
        }
        entryDescriptors.forEach((entryModuleName, entry) -> {
            if (neededModuleNames.contains(entryModuleName)) {
                entry.setClasspathAttribute("module", Boolean.TRUE.toString());
            }
        });
    }

    private static Set<String> collectModulesNeededTransitively(InternalModuleInfo module, Map<String, InternalModuleInfo> classpathModules) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Function<InternalModuleInfo, Set<String>> neededModulesLookup = ModuleSupport.createNeededModulesLookup(classpathModules);
        Set<String> todo = neededModulesLookup.apply(module);
        while (!todo.isEmpty()) {
            LinkedHashSet<String> todoNext = new LinkedHashSet<String>();
            for (String neededModuleName : todo) {
                if (!result.add(neededModuleName)) continue;
                InternalModuleInfo neededModule = classpathModules.get(neededModuleName);
                todoNext.addAll((Collection<String>)neededModulesLookup.apply(neededModule));
            }
            todo = todoNext;
        }
        return result;
    }

    private static Function<InternalModuleInfo, Set<String>> createNeededModulesLookup(Map<String, InternalModuleInfo> classpathModules) {
        LinkedHashMap<String, Set> providersByServiceName = new LinkedHashMap<String, Set>();
        for (InternalModuleInfo classpathModule : classpathModules.values()) {
            for (String serviceName : classpathModule.providedServiceNames) {
                providersByServiceName.computeIfAbsent(serviceName, k -> new LinkedHashSet()).add(classpathModule.name);
            }
        }
        return module -> {
            if (module != null) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                result.addAll(module.requiredModuleNames);
                for (String serviceName : module.usedServiceNames) {
                    Set providerNames = providersByServiceName.getOrDefault(serviceName, Collections.emptySet());
                    result.addAll(providerNames);
                }
                return result;
            }
            return Collections.emptySet();
        };
    }

    private static InternalModuleInfo getModuleInfo(IClasspathEntryDescriptor entry, IProgressMonitor monitor, int targetCompliance) {
        if (entry != null && !monitor.isCanceled()) {
            if (1 == entry.getEntryKind()) {
                return ModuleSupport.getModuleInfo(entry.getPath().toFile(), targetCompliance);
            }
            if (2 == entry.getEntryKind()) {
                return ModuleSupport.getModuleInfo(ModuleSupport.getJavaProject(entry.getPath()), monitor);
            }
        }
        return null;
    }

    static InternalModuleInfo getModuleInfo(IJavaProject project, IProgressMonitor monitor) {
        if (project != null) {
            try {
                IModuleDescription moduleDescription = project.getModuleDescription();
                if (moduleDescription != null) {
                    return InternalModuleInfo.fromDescription(moduleDescription);
                }
                String buildName = null;
                IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project.getProject());
                if (facade != null) {
                    buildName = facade.getFinalName();
                }
                if (buildName == null || buildName.isEmpty()) {
                    buildName = project.getElementName();
                }
                String moduleName = new String(AutomaticModuleNaming.determineAutomaticModuleName((String)buildName, (boolean)false, null));
                return InternalModuleInfo.withAutomaticName(moduleName);
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private static InternalModuleInfo getModuleInfo(File file, int targetCompliance) {
        if (!file.isFile()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JarFile jar = new JarFile(file, false);){
                String automaticModuleName;
                int compliance;
                Manifest manifest = jar.getManifest();
                boolean isMultiRelease = false;
                if (manifest != null) {
                    isMultiRelease = "true".equalsIgnoreCase(manifest.getMainAttributes().getValue("Multi-Release"));
                }
                int i = compliance = isMultiRelease ? targetCompliance : 8;
                while (i >= 8) {
                    IBinaryModule module;
                    String filename = i == 8 ? "module-info.class" : "META-INF/versions/" + i + "/" + "module-info.class";
                    ClassFileReader reader = ClassFileReader.read((ZipFile)jar, (String)filename);
                    if (reader != null && (module = reader.getModuleDeclaration()) != null) {
                        return InternalModuleInfo.fromDeclaration((IModule)module);
                    }
                    --i;
                }
                if (manifest != null && (automaticModuleName = manifest.getMainAttributes().getValue("Automatic-Module-Name")) != null) {
                    return InternalModuleInfo.withAutomaticName(automaticModuleName);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException ex) {
            log.error(ex.getMessage(), ex);
        }
        return InternalModuleInfo.withAutomaticNameFromFile(file);
    }

    private static IJavaProject getJavaProject(IPath projectPath) {
        if (projectPath == null || projectPath.isEmpty()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectPath.lastSegment());
        if (project.isAccessible()) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static boolean isModuleEntry(IClasspathEntry entry) {
        return Arrays.stream(entry.getExtraAttributes()).anyMatch(p -> "module".equals(p.getName()) && "true".equals(p.getValue()));
    }

    public static int determineModularClasspathProperty(IClasspathEntry entry) {
        return ModuleSupport.isModuleEntry(entry) ? 4 : 5;
    }

    public static IRuntimeClasspathEntry createRuntimeClasspathEntry(IFolder folder, int classpathProperty, IProject project) {
        if (classpathProperty == 4 && !folder.exists((IPath)new Path("module-info.class"))) {
            classpathProperty = 6;
        }
        IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)folder.getFullPath(), (int)classpathProperty);
        if (classpathProperty == 6) {
            ((RuntimeClasspathEntry)newArchiveRuntimeClasspathEntry).setJavaProject(JavaCore.create((IProject)project));
        }
        return newArchiveRuntimeClasspathEntry;
    }

    public static int determineClasspathPropertyForMainProject(boolean isModularConfiguration, IJavaProject javaProject) {
        if (!isModularConfiguration) {
            return 3;
        }
        if (!JavaRuntime.isModularProject((IJavaProject)javaProject)) {
            return 5;
        }
        return 4;
    }

    public static IRuntimeClasspathEntry newModularProjectRuntimeClasspathEntry(IJavaProject javaProject) {
        return JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)javaProject, (int)(JavaRuntime.isModularProject((IJavaProject)javaProject) ? 4 : 5));
    }

    public static boolean isMavenJavaProject(IProject project) {
        try {
            return project != null && project.isOpen() && project.hasNature("org.eclipse.m2e.core.maven2Nature") && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor, List<String> compilerArgs) {
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
        if (javaProject == null || !javaProject.exists() || classpath == null) {
            return;
        }
        Optional<JpmsArgs> jpmsArgs = JpmsArgs.computeFromArgs(compilerArgs);
        if (jpmsArgs.isEmpty()) {
            return;
        }
        IClasspathEntry m2eEntry = ModuleSupport.findMavenContainerEntry(classpath);
        IClasspathEntry jreEntry = ModuleSupport.findJreContainerEntry(classpath);
        ClasspathEntryDescriptor m2eEntryDescriptor = new ClasspathEntryDescriptor(m2eEntry);
        ClasspathEntryDescriptor jreEntryDescriptor = new ClasspathEntryDescriptor(jreEntry);
        List<String> availableModules = ModuleSupport.getRootModules(javaProject, jreEntry);
        log.debug("Found {} modules managed by the JRE Container", (Object)availableModules.size());
        JpmsArgType[] jpmsArgTypeArray = JpmsArgType.values();
        int n = jpmsArgTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JpmsArgType argType = jpmsArgTypeArray[n2];
            List<JpmsArgValue> values = argType.getFromArgs(jpmsArgs.get());
            if (values != null && !values.isEmpty()) {
                String valuesAsString;
                Map<Boolean, List<JpmsArgValue>> partitioned = values.stream().collect(Collectors.partitioningBy(v -> availableModules.contains(v.getModule())));
                List<JpmsArgValue> jreValues = partitioned.get(true);
                List<JpmsArgValue> m2eValues = partitioned.get(false);
                jreEntryDescriptor.setClasspathAttribute(argType.getEclipseArgumentName(), null);
                if (jreValues != null && !jreValues.isEmpty()) {
                    valuesAsString = jreValues.stream().map(JpmsArgValue::getValue).distinct().collect(Collectors.joining(":"));
                    jreEntryDescriptor.setClasspathAttribute("module", "true");
                    jreEntryDescriptor.setClasspathAttribute(argType.getEclipseArgumentName(), valuesAsString);
                }
                m2eEntryDescriptor.setClasspathAttribute(argType.getEclipseArgumentName(), null);
                if (m2eValues != null && !m2eValues.isEmpty()) {
                    valuesAsString = m2eValues.stream().map(JpmsArgValue::getValue).distinct().collect(Collectors.joining(":"));
                    m2eEntryDescriptor.setClasspathAttribute(argType.getEclipseArgumentName(), valuesAsString);
                }
            }
            ++n2;
        }
        classpath.replaceEntry(descriptor -> "org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER".equals(descriptor.getPath().segment(0)), m2eEntryDescriptor.toClasspathEntry());
        classpath.replaceEntry(descriptor -> JavaRuntime.JRE_CONTAINER.equals(descriptor.getPath().segment(0)), jreEntryDescriptor.toClasspathEntry());
    }

    private static IClasspathEntry findContainerEntry(IClasspathDescriptor classpath, Predicate<IClasspathEntry> predicate) {
        IClasspathEntry[] iClasspathEntryArray = classpath.getEntries();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (predicate.test(entry)) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    private static IClasspathEntry findMavenContainerEntry(IClasspathDescriptor classpath) {
        return ModuleSupport.findContainerEntry(classpath, e -> MavenClasspathHelpers.isMaven2ClasspathContainer(e.getPath()));
    }

    private static IClasspathEntry findJreContainerEntry(IClasspathDescriptor classpath) {
        return ModuleSupport.findContainerEntry(classpath, e -> MavenClasspathHelpers.isJREClasspathContainer(e.getPath()));
    }

    private static List<String> getRootModules(IJavaProject javaProject, IClasspathEntry entry) {
        HashSet<String> result = new HashSet<String>();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(false);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot[] fAllSystemRoots;
                IClasspathEntry entry2 = iClasspathEntryArray[n2];
                IPackageFragmentRoot[] iPackageFragmentRootArray = fAllSystemRoots = javaProject.findUnfilteredPackageFragmentRoots(entry2);
                int n3 = fAllSystemRoots.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPackageFragmentRoot pfr = iPackageFragmentRootArray[n4];
                    if (pfr instanceof JrtPackageFragmentRoot) {
                        String moduleName = pfr.getElementName();
                        IModuleDescription module = pfr.getModuleDescription();
                        if (module != null) {
                            result.add(moduleName);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            return new ArrayList<String>(result);
        }
        catch (JavaModelException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    protected static enum JpmsArgType {
        AddExports("--add-exports", "add-exports", Pattern.compile("^(([A-Za-z0-9\\.$_]*)/[A-Za-z0-9\\.$_]*=[A-Za-z0-9\\.$_-]*)$"), (a, v) -> a.toAddExports((JpmsArgValue)v), JpmsArgs::getAddExports),
        AddOpens("--add-opens", "add-opens", Pattern.compile("^(([A-Za-z0-9\\.$_]*)/[A-Za-z0-9\\.$_]*=[A-Za-z0-9\\.$_-]*)$"), (a, v) -> a.toAddOpens((JpmsArgValue)v), JpmsArgs::getAddOpens),
        AddReads("--add-reads", "add-reads", Pattern.compile("^(([A-Za-z0-9\\.$_]*)=[A-Za-z0-9\\.$_-]*)$"), (a, v) -> a.toAddReads((JpmsArgValue)v), JpmsArgs::getAddReads),
        PatchModule("--patch-module", "patch-module", Pattern.compile("^(([A-Za-z0-9\\.$_]*)=.*)$"), (a, v) -> a.toPatchModule((JpmsArgValue)v), JpmsArgs::getPatchModule);

        private String argumentName;
        private String eclipseArgumentName;
        private Pattern extractPattern;
        private BiFunction<JpmsArgs, JpmsArgValue, Boolean> addFunction;
        private Function<JpmsArgs, List<JpmsArgValue>> getFunction;

        private JpmsArgType(String argumentName, String eclipseArgumentName, Pattern extractPattern, BiFunction<JpmsArgs, JpmsArgValue, Boolean> addFunction, Function<JpmsArgs, List<JpmsArgValue>> getFunction) {
            this.argumentName = argumentName;
            this.eclipseArgumentName = eclipseArgumentName;
            this.extractPattern = extractPattern;
            this.addFunction = addFunction;
            this.getFunction = getFunction;
        }

        public JpmsArgValue parse(String value) {
            String trimed = value.trim();
            Matcher matcher = this.extractPattern.matcher(trimed);
            if (matcher.matches()) {
                String argValue = matcher.group(1);
                String module = matcher.group(2);
                return new JpmsArgValue(module, argValue);
            }
            return null;
        }

        public boolean addToArgs(JpmsArgs args, JpmsArgValue value) {
            return this.addFunction.apply(args, value);
        }

        public List<JpmsArgValue> getFromArgs(JpmsArgs args) {
            return this.getFunction.apply(args);
        }

        static JpmsArgType valueFromArgumentName(String argumentName) {
            Optional<JpmsArgType> result = Arrays.stream(JpmsArgType.values()).filter(at -> at.getArgumentName().equalsIgnoreCase(argumentName)).findFirst();
            if (result.isEmpty()) {
                return null;
            }
            return result.get();
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getEclipseArgumentName() {
            return this.eclipseArgumentName;
        }
    }

    private static class JpmsArgValue {
        private final String module;
        private final String value;

        public JpmsArgValue(String module, String value) {
            this.module = module;
            this.value = value;
        }

        public String getModule() {
            return this.module;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class JpmsArgs {
        public static final String VALUE_SEPARATOR = ":";
        private final List<JpmsArgValue> addExports = new ArrayList<JpmsArgValue>();
        private final List<JpmsArgValue> addOpens = new ArrayList<JpmsArgValue>();
        private final List<JpmsArgValue> addReads = new ArrayList<JpmsArgValue>();
        private final List<JpmsArgValue> patchModule = new ArrayList<JpmsArgValue>();

        private JpmsArgs() {
        }

        protected static Optional<JpmsArgs> computeFromArgs(List<String> args) {
            JpmsArgs jpmsArgs = null;
            if (args != null) {
                ListIterator<String> it = args.listIterator();
                while (it.hasNext()) {
                    String argumentName = it.next();
                    JpmsArgType argType = JpmsArgType.valueFromArgumentName(argumentName);
                    if (argType == null) continue;
                    String value = it.next();
                    JpmsArgValue argValue = argType.parse(value);
                    if (argValue == null) {
                        it.previous();
                        continue;
                    }
                    if (jpmsArgs == null) {
                        jpmsArgs = new JpmsArgs();
                    }
                    argType.addToArgs(jpmsArgs, argValue);
                }
            }
            return Optional.ofNullable(jpmsArgs);
        }

        public List<JpmsArgValue> getAddExports() {
            return this.addExports;
        }

        public boolean toAddExports(JpmsArgValue addExport) {
            return this.addExports.add(addExport);
        }

        public List<JpmsArgValue> getAddOpens() {
            return this.addOpens;
        }

        public boolean toAddOpens(JpmsArgValue addOpen) {
            return this.addOpens.add(addOpen);
        }

        public List<JpmsArgValue> getAddReads() {
            return this.addReads;
        }

        public boolean toAddReads(JpmsArgValue addRead) {
            return this.addReads.add(addRead);
        }

        public List<JpmsArgValue> getPatchModule() {
            return this.patchModule;
        }

        public boolean toPatchModule(JpmsArgValue patchModule) {
            return this.patchModule.add(patchModule);
        }
    }
}

