/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedDependencyTypeProjectConfigurator
extends AbstractProjectConfigurator {
    private static final Set<String> UNSUPPORTED_DEPENDENCY_TYPES = new HashSet<String>(Arrays.asList("ejb-client", "test-jar"));

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (facade == null) {
            return;
        }
        this.clearWarnings((IResource)facade.getPom());
        if (!ModuleCoreNature.isFlexibleProject((IProject)facade.getProject())) {
            return;
        }
        if (!facade.getResolverConfiguration().shouldResolveWorkspaceProjects()) {
            return;
        }
        for (Artifact a : facade.getMavenProject().getArtifacts()) {
            IMavenProjectFacade workspaceDependency;
            String type = a.getType();
            if (!this.isUnsupported(type) || (workspaceDependency = this.getWorkspaceProject(a)) == null) continue;
            Dependency dependency = this.getDependency(a, facade.getMavenProject().getDependencies());
            int lineNumber = -1;
            if (dependency != null) {
                SourceLocation location = SourceLocationHelper.findLocation((MavenProject)facade.getMavenProject(), (Dependency)dependency);
                lineNumber = location.getLineNumber();
            }
            this.addWarning((IResource)facade.getPom(), workspaceDependency, type, lineNumber);
        }
    }

    private void clearWarnings(IResource resource) throws CoreException {
        this.markerManager.deleteMarkers(resource, "org.eclipse.m2e.core.maven2Problem.wtp.unsupportedDependencyProblem");
    }

    private boolean isUnsupported(String type) {
        return UNSUPPORTED_DEPENDENCY_TYPES.contains(type);
    }

    private IMavenProjectFacade getWorkspaceProject(Artifact artifact) {
        return this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    private Dependency getDependency(Artifact a, List<Dependency> dependencies) {
        for (Dependency d : dependencies) {
            String aType;
            if (!StringUtils.equals((String)a.getArtifactId(), (String)d.getArtifactId()) || !StringUtils.equals((String)a.getGroupId(), (String)d.getGroupId()) || !StringUtils.equals((String)a.getVersion(), (String)d.getVersion()) || !StringUtils.equals((String)a.getClassifier(), (String)a.getClassifier())) continue;
            String dType = StringUtils.isBlank((String)d.getType()) ? "jar" : d.getType();
            String string = aType = StringUtils.isBlank((String)a.getType()) ? "jar" : a.getType();
            if (!aType.equals(dType)) continue;
            return d;
        }
        return null;
    }

    private void addWarning(IResource resource, IMavenProjectFacade workspaceDependency, String type, int lineNumber) {
        String warning = NLS.bind((String)Messages.markers_unsupported_dependencies_warning, (Object)workspaceDependency.getProject().getName(), (Object)type);
        this.markerManager.addMarker(resource, "org.eclipse.m2e.core.maven2Problem.wtp.unsupportedDependencyProblem", warning, lineNumber, 1);
    }
}

