/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.zip.GZIPInputStream;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.mat.hprof.CompressedRandomAccessFile;

class FileCacheCompressedRandomAccessFile
extends RandomAccessFile {
    ImageInputStream iis = new FileCacheImageInputStream(new GZIPInputStream(Channels.newInputStream(this.getChannel())), null);

    public FileCacheCompressedRandomAccessFile(File file) throws IOException {
        super(file, "r");
    }

    @Override
    public void seek(long pos) throws IOException {
        this.iis.seek(pos);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.iis.getStreamPosition();
    }

    @Override
    public long length() {
        return Long.MAX_VALUE;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.iis.read(buf);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.iis.read(buf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.iis.close();
        super.close();
    }

    public static boolean isDiskSpace(File f, long len) throws IOException {
        long estlen = len >= 0L ? len : CompressedRandomAccessFile.estimatedLength(f);
        String tempDirName = System.getProperty("java.io.tmpdir");
        File tempDir = new File(tempDirName);
        return tempDir.getUsableSpace() > estlen;
    }
}

