/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.snapshot.SnapshotQueryContext;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.report.SpecFactory;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.actions.OpenHelpPageAction;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.EditorPaneRegistry;
import org.eclipse.mat.ui.editor.MultiPaneEditorSite;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.mat.ui.snapshot.editor.HeapEditorPane;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.Units;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OverviewPane
extends HeapEditorPane
implements IHyperlinkListener,
ISelectionProvider {
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private ISelectionProvider delegate;
    private FormToolkit toolkit;
    private AbstractEditorPane pane;
    private ScrolledForm form;

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 20;
        this.form.getBody().setLayout((Layout)layout);
        Section section = this.createDetailsSection();
        TableWrapData td = new TableWrapData(256, 256, 1, 3);
        section.setLayoutData((Object)td);
        section = this.createBiggestObjectsSection();
        td = new TableWrapData(256, 256, 1, 3);
        section.setLayoutData((Object)td);
        section = this.createSidecarSection();
        if (section != null) {
            td = new TableWrapData(256, 256, 1, 3);
            section.setLayoutData((Object)td);
        }
        section = this.createActionSection();
        td = new TableWrapData(256, 256, 1, 1);
        section.setLayoutData((Object)td);
        section = this.createReportsSection();
        td = new TableWrapData(256, 256, 1, 1);
        section.setLayoutData((Object)td);
        section = this.createStepByStepSection();
        td = new TableWrapData(256, 256, 1, 1);
        section.setLayoutData((Object)td);
        this.form.reflow(true);
    }

    private Section createSidecarSection() {
        Section section = null;
        FormText text = null;
        List queries = QueryRegistry.instance().getQueries(Pattern.compile("supplement_.*"));
        if (queries.isEmpty()) {
            return null;
        }
        Collections.sort(queries, new Comparator<QueryDescriptor>(){

            @Override
            public int compare(QueryDescriptor o1, QueryDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuilder buf = new StringBuilder();
        buf.append("<form>");
        for (QueryDescriptor query : queries) {
            if (!query.accept(this.getQueryContext())) continue;
            if (section == null) {
                section = this.toolkit.createSection(this.form.getBody(), 322);
                section.setText(Messages.OverviewPane_AdditionalInfo);
                Composite sectionClient = this.toolkit.createComposite((Composite)section);
                sectionClient.setLayout((Layout)new TableWrapLayout());
                text = this.toolkit.createFormText(sectionClient, true);
                text.setLayoutData((Object)new TableWrapData(256));
                text.addHyperlinkListener((IHyperlinkListener)this);
                section.setClient((Control)sectionClient);
            }
            this.addButton(buf, text, query.getIdentifier(), null, query.getName(), query.getHelp());
        }
        buf.append("</form>");
        if (text != null) {
            text.setText(buf.toString(), true, false);
        }
        return section;
    }

    private Section createDetailsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 322);
        section.setText(Messages.OverviewPane_Details);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new TableWrapLayout());
        FormText text = this.toolkit.createFormText(sectionClient, true);
        text.setLayoutData((Object)new TableWrapData(256));
        SnapshotInfo info = this.getSnapshotInput().getSnapshot().getSnapshotInfo();
        StringBuilder buf = new StringBuilder();
        buf.append("<form>");
        buf.append("<p>" + Messages.OverviewPane_Size);
        long heapSize = info.getUsedHeapSize();
        String size = Units.Storage.of((long)heapSize).format(heapSize);
        buf.append("<b>" + size + "</b>");
        buf.append("  " + Messages.OverviewPane_Classes);
        buf.append("<b>" + this.formatNumber(info.getNumberOfClasses()) + "</b>");
        buf.append("  " + Messages.OverviewPane_Objects);
        buf.append("<b>" + this.formatNumber(info.getNumberOfObjects()) + "</b>");
        buf.append("  " + Messages.OverviewPane_ClassLoader);
        buf.append("<b>" + this.formatNumber(info.getNumberOfClassLoaders()) + "</b>");
        QueryDescriptor descriptor = QueryRegistry.instance().getQuery("unreachable_objects");
        if (descriptor != null && descriptor.accept(this.getQueryContext())) {
            buf.append("  <a href=\"").append(descriptor.getIdentifier()).append("\">").append(descriptor.getName()).append("</a>");
        }
        buf.append("</p></form>");
        text.setText(buf.toString(), true, false);
        text.addHyperlinkListener((IHyperlinkListener)this);
        section.setClient((Control)sectionClient);
        return section;
    }

    private String formatNumber(int number) {
        return Units.Plain.of((long)number).format((long)number);
    }

    private Section createActionSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 322);
        section.setText(Messages.OverviewPane_Actions);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new TableWrapLayout());
        FormText text = this.toolkit.createFormText(sectionClient, true);
        text.setLayoutData((Object)new TableWrapData(256));
        StringBuilder buf = new StringBuilder();
        buf.append("<form>");
        this.addButton(buf, text, "histogram", null, Messages.OverviewPane_Histogram, Messages.OverviewPane_HistogramInfo);
        this.addButton(buf, text, "dominator_tree", null, Messages.OverviewPane_DominatorTree, Messages.OverviewPane_DominatorTreeInfo);
        this.addButton(buf, text, "top_consumers_html", null, Messages.OverviewPane_TopConsumers, Messages.OverviewPane_TopConsumersInfo);
        this.addButton(buf, text, "duplicate_classes", null, Messages.OverviewPane_DuplicateClasses, Messages.OverviewPane_DuplicateClassesInfo);
        buf.append("</form>");
        text.setText(buf.toString(), true, false);
        text.addHyperlinkListener((IHyperlinkListener)this);
        section.setClient((Control)sectionClient);
        return section;
    }

    private Section createReportsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 322);
        section.setText(Messages.OverviewPane_Reports);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new TableWrapLayout());
        FormText text = this.toolkit.createFormText(sectionClient, true);
        StringBuilder buf = new StringBuilder();
        buf.append("<form>");
        this.addReportsByPattern(text, buf, Pattern.compile(".*:suspects"));
        this.addReportsByPattern(text, buf, Pattern.compile(".*:top_components"));
        this.addReportsByPattern2(text, buf, Pattern.compile(".*:suspects2"));
        buf.append("</form>");
        text.setText(buf.toString(), true, false);
        text.addHyperlinkListener((IHyperlinkListener)this);
        section.setClient((Control)sectionClient);
        return section;
    }

    private void addReportsByPattern(FormText text, StringBuilder buf, Pattern pattern) {
        for (SpecFactory.Report report : SpecFactory.instance().delegates()) {
            if (!pattern.matcher(report.getExtensionIdentifier()).matches()) continue;
            this.addButton(buf, text, "create_report", "default_report " + report.getExtensionIdentifier(), report.getName(), report.getDescription());
        }
    }

    private void addReportsByPattern2(FormText text, StringBuilder buf, Pattern pattern) {
        for (SpecFactory.Report report : SpecFactory.instance().delegates()) {
            if (!pattern.matcher(report.getExtensionIdentifier()).matches()) continue;
            String name = report.getName();
            if (name.startsWith("__hidden__/")) {
                name = name.substring("__hidden__".length() + 1);
            }
            this.addButton(buf, text, "create_report", "comparison_report " + report.getExtensionIdentifier(), name, report.getDescription());
        }
    }

    private Section createStepByStepSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 322);
        section.setText(Messages.OverviewPane_StepByStep);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new TableWrapLayout());
        FormText text = this.toolkit.createFormText(sectionClient, true);
        StringBuilder buf = new StringBuilder();
        buf.append("<form>");
        this.addCheatSheetLink(buf, "org.eclipse.mat.tutorials.component_report", Messages.OverviewPane_ComponentReport, Messages.OverviewPane_ComponentReportInfo);
        buf.append("</form>");
        text.setText(buf.toString(), true, false);
        text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                new OpenCheatSheetAction(String.valueOf(e.getHref())).run();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        section.setClient((Control)sectionClient);
        return section;
    }

    private void addCheatSheetLink(StringBuilder buf, String cheatSheetId, String title, String help) {
        buf.append("<li style=\"text\" value=\"\">");
        buf.append("<a href=\"").append(cheatSheetId).append("\">").append(title).append("</a>");
        if (help != null) {
            buf.append(": ").append(help);
        }
        buf.append("</li>");
    }

    private void addButton(StringBuilder buf, FormText formText, String commandId, String command, String title, String help) {
        Image image;
        QueryDescriptor descriptor = QueryRegistry.instance().getQuery(commandId);
        if (descriptor == null) {
            return;
        }
        if (command == null) {
            command = descriptor.getIdentifier();
        }
        if ((image = MemoryAnalyserPlugin.getDefault().getImage(descriptor)) != null) {
            buf.append("<li style=\"image\" value=\"").append(descriptor.getIdentifier()).append("\">");
            formText.setImage(descriptor.getIdentifier(), image);
        } else {
            buf.append("<li style=\"text\" value=\"\">");
        }
        buf.append("<a href=\"").append(command).append("\">").append(title).append("</a>");
        if (help != null) {
            buf.append(": ").append(help);
        }
        buf.append("</li>");
    }

    private Section createBiggestObjectsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 322);
        section.setText(Messages.OverviewPane_BiggestObjectsByRetainedSIze);
        final Composite sectionClient = this.toolkit.createComposite((Composite)section);
        if (Platform.getBundle((String)"org.eclipse.mat.chart.ui") == null) {
            sectionClient.setLayout((Layout)new TableWrapLayout());
            FormText text = this.toolkit.createFormText(sectionClient, true);
            StringBuilder buf = new StringBuilder(256);
            buf.append("<form><li style=\"text\" value=\"\">");
            buf.append(MessageUtil.format((String)Messages.OverviewPane_NoPieChartAvailable, (Object[])new Object[]{"dominator_tree", "top_consumers_html"}));
            buf.append("</li></form>");
            text.setText(buf.toString(), true, false);
            text.addHyperlinkListener((IHyperlinkListener)this);
        } else {
            FillLayout layout = new FillLayout();
            sectionClient.setLayout((Layout)layout);
            final ISnapshot snapshot = this.getSnapshotInput().getSnapshot();
            new AbstractPaneJob(Messages.OverviewPane_ExtractingBigObjects, this){

                @Override
                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        SnapshotQueryContext ctx = new SnapshotQueryContext(snapshot);
                        final IResult result = CommandLine.execute((IQueryContext)ctx, (String)"pie_biggest_objects", (IProgressListener)new ProgressMonitorWrapper(monitor));
                        sectionClient.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    OverviewPane.this.pane = EditorPaneRegistry.instance().createNewPane(result, null);
                                    OverviewPane.this.pane.init(OverviewPane.this.getEditorSite(), OverviewPane.this.getEditorInput());
                                    OverviewPane.this.pane.createPartControl(sectionClient);
                                    OverviewPane.this.pane.initWithArgument(new QueryResult(QueryRegistry.instance().getQuery("pie_biggest_objects"), "pie_biggest_objects", result));
                                    OverviewPane.this.form.reflow(true);
                                    if (OverviewPane.this.pane instanceof ISelectionProvider) {
                                        OverviewPane.this.delegate = (ISelectionProvider)OverviewPane.this.pane;
                                        for (ISelectionChangedListener l : OverviewPane.this.listeners) {
                                            OverviewPane.this.delegate.addSelectionChangedListener(l);
                                        }
                                    }
                                }
                                catch (PartInitException e) {
                                    ErrorHelper.logThrowableAndShowMessage(e);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (SnapshotException e) {
                        return ErrorHelper.createErrorStatus(e);
                    }
                }
            }.schedule();
        }
        section.setClient((Control)sectionClient);
        return section;
    }

    public void linkActivated(HyperlinkEvent e) {
        String command = String.valueOf(e.getHref());
        this.runCommand(command);
    }

    private void runCommand(String command) {
        try {
            HeapEditor heapEditor = (HeapEditor)((MultiPaneEditorSite)this.getSite()).getMultiPageEditor();
            QueryExecution.executeCommandLine(heapEditor, this.getPaneState(), command);
        }
        catch (SnapshotException exp) {
            ErrorHelper.logThrowableAndShowMessage(exp);
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public String getTitle() {
        return Messages.OverviewPane_Overview;
    }

    @Override
    public Image getTitleImage() {
        return MemoryAnalyserPlugin.getImage("$nl$/icons/info.gif");
    }

    @Override
    public void contributeToToolBar(IToolBarManager manager) {
        manager.appendToGroup("help", (IAction)new OpenHelpPageAction("/org.eclipse.mat.ui.help/gettingstarted/basictutorial.html#task_basictutorial__overview"));
        super.contributeToToolBar(manager);
    }

    @Override
    public void setFocus() {
        this.form.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
        if (this.delegate != null) {
            this.delegate.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.delegate != null) {
            return this.delegate.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.pane != null) {
            this.pane.dispose();
            this.pane = null;
        }
    }
}

