/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.mat.dtfj.DTFJIndexBuilder;
import org.eclipse.mat.dtfj.Messages;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class InitDTFJ
extends Plugin
implements IRegistryChangeListener {
    private static final String DTFJ_NAMESPACE = "com.ibm.dtfj.api";
    private static final String DTFJ_IMAGEFACTORY = "imagefactory";
    private static final Map<String, Map<String, String>> allexts = new HashMap<String, Map<String, String>>();
    private static int updateCount = 0;
    private static InitDTFJ plugin;
    private Object preferenceStore;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        if (reg != null) {
            reg.addRegistryChangeListener((IRegistryChangeListener)this, DTFJ_NAMESPACE);
            this.registerFileExtensions(reg);
        }
        this.checkDTFJInterface();
    }

    public void stop(BundleContext context) throws Exception {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        if (reg != null) {
            this.removeAllExtensions(reg);
            reg.removeRegistryChangeListener((IRegistryChangeListener)this);
        }
        plugin = null;
        super.stop(context);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        if (reg != null) {
            IContributor cont = this.getContributor(reg);
            IExtensionPoint contentPoint = this.contentExtensionPoint(reg);
            IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas(DTFJ_NAMESPACE, DTFJ_IMAGEFACTORY);
            int n = iExtensionDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                IExtension dtfjExtension = delta.getExtension();
                switch (delta.getKind()) {
                    case 1: {
                        try {
                            this.contributeParserExtension(reg, cont, contentPoint, dtfjExtension);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        break;
                    }
                    case 2: {
                        this.removeParserExtension(reg, cont, dtfjExtension);
                        break;
                    }
                }
                ++n2;
            }
            this.checkDTFJInterface();
        }
    }

    void checkDTFJInterface() {
        if (allexts.size() > 0 && ++updateCount <= 1) {
            try {
                new DTFJIndexBuilder();
            }
            catch (NoClassDefFoundError e) {
                this.log(2, Messages.InitDTFJ_FailedToCreate, e);
                Job j = Job.create((String)Messages.InitDTFJ_UpdatingBundle, (ICoreRunnable)new ICoreRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            plugin.getBundle().update();
                            InitDTFJ.this.log(1, Messages.InitDTFJ_UpdatedBundle, null);
                        }
                        catch (BundleException e) {
                            throw new CoreException((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), "Error updating bundle", (Throwable)e));
                        }
                    }
                });
                j.schedule();
            }
        }
    }

    private void removeParserExtension(IExtensionRegistry reg, IContributor cont, IExtension dtfjExtension) {
        IConfigurationElement[] iConfigurationElementArray = dtfjExtension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals("factory")) {
                String id = el.getAttribute("id");
                String fullid = String.valueOf(cont.getName()) + "." + id;
                allexts.remove(fullid);
            }
            ++n2;
        }
    }

    private void removeAllExtensions(IExtensionRegistry reg) {
        block4: {
            IContributor cont = this.getContributor(reg);
            IExtensionPoint dtfjPoint = this.dtfjExtensionPoint(reg);
            if (dtfjPoint != null) {
                IExtension[] iExtensionArray = dtfjPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ex = iExtensionArray[n2];
                    this.removeParserExtension(reg, cont, ex);
                    ++n2;
                }
                try {
                    DTFJIndexBuilder.DumpCache.clearCachedDumps();
                }
                catch (NoClassDefFoundError e) {
                    if (!this.isDebugging()) break block4;
                    this.log(2, Messages.InitDTFJ_ErrorClearDumps, e);
                }
            }
        }
        allexts.clear();
    }

    private void log(int level, String msg, Throwable e) {
        this.getLog().log((IStatus)new Status(level, this.getBundle().getSymbolicName(), msg, e));
    }

    void registerFileExtensions(IExtensionRegistry reg) {
        try {
            IContributor cont = this.getContributor(reg);
            IExtensionPoint dtfjPoint = this.dtfjExtensionPoint(reg);
            IExtensionPoint contentPoint = this.contentExtensionPoint(reg);
            if (dtfjPoint != null) {
                IExtension[] iExtensionArray = dtfjPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ex = iExtensionArray[n2];
                    this.contributeParserExtension(reg, cont, contentPoint, ex);
                    ++n2;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private IExtensionPoint contentExtensionPoint(IExtensionRegistry reg) {
        return reg.getExtensionPoint("org.eclipse.core.contenttype", "contentTypes");
    }

    private IExtensionPoint dtfjExtensionPoint(IExtensionRegistry reg) {
        IExtensionPoint dtfjPoint = reg.getExtensionPoint(DTFJ_NAMESPACE, DTFJ_IMAGEFACTORY);
        return dtfjPoint;
    }

    private IContributor getContributor(IExtensionRegistry reg) {
        IExtensionPoint extensionPoint = reg.getExtensionPoint("org.eclipse.mat.parser.parser");
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension es1 = iExtensionArray[n2];
                if ("dynamic-dtfj".equals(es1.getSimpleIdentifier())) {
                    return es1.getContributor();
                }
                ++n2;
            }
        }
        IContributor cont = ContributorFactoryOSGi.createContributor((Bundle)InitDTFJ.getDefault().getBundle());
        return cont;
    }

    private void contributeParserExtension(IExtensionRegistry reg, IContributor cont, IExtensionPoint contentPoint, IExtension dtfjExtension) throws UnsupportedEncodingException {
        IConfigurationElement[] iConfigurationElementArray = dtfjExtension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals("factory")) {
                HashSet<String> done = new HashSet<String>();
                String id = el.getAttribute("id");
                String name = el.getAttribute("label");
                String exts = null;
                String contentTypes = null;
                IConfigurationElement[] iConfigurationElementArray2 = el.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el2 = iConfigurationElementArray2[n4];
                    String ref = el2.getAttribute("dump-type");
                    if (ref != null && done.add(ref)) {
                        exts = InitDTFJ.addExtension(exts, InitDTFJ.genParser(ref, contentPoint));
                        contentTypes = contentTypes == null ? ref : String.valueOf(contentTypes) + "," + ref;
                    }
                    if ((ref = el2.getAttribute("meta-type")) != null && done.add(ref)) {
                        exts = InitDTFJ.addExtension(exts, InitDTFJ.genParser(ref, contentPoint));
                        contentTypes = contentTypes == null ? ref : String.valueOf(contentTypes) + "," + ref;
                    }
                    ++n4;
                }
                HashMap<String, String> vals = new HashMap<String, String>();
                vals.put("id", id);
                vals.put("name", name);
                vals.put("fileExtension", exts);
                if (contentTypes != null) {
                    vals.put("contentTypeBinding", contentTypes);
                }
                String fullid = String.valueOf(cont.getName()) + "." + id;
                allexts.put(fullid, vals);
            }
            ++n2;
        }
    }

    private static String genParser(String ref, IExtensionPoint point2) {
        IContentType ct = Platform.getContentTypeManager().getContentType(ref);
        if (ct == null) {
            return null;
        }
        String exts = null;
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType ct1 = iContentTypeArray[n2];
            if (ct1.isKindOf(ct)) {
                String s1 = InitDTFJ.genParser(ct1);
                exts = InitDTFJ.addExtension(exts, s1);
            }
            ++n2;
        }
        return exts;
    }

    private static String addExtension(String exts, String ext) {
        if (exts == null) {
            exts = ext;
        } else if (ext != null) {
            exts = String.valueOf(exts) + "," + ext;
        }
        return exts;
    }

    private static String genParser(IContentType ct) {
        String[] s;
        String label = ct.getName();
        String exts = null;
        if (label != null && (s = ct.getFileSpecs(8)).length > 0) {
            String[] stringArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                String s1 = stringArray[n2];
                exts = InitDTFJ.addExtension(exts, s1);
                ++n2;
            }
        }
        return exts;
    }

    public Object getPreferenceStore() {
        if (this.preferenceStore == null) {
            try {
                this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getBundle().getSymbolicName());
            }
            catch (LinkageError e) {
                this.preferenceStore = new PreferenceStore();
            }
        }
        return this.preferenceStore;
    }

    static InitDTFJ getDefault() {
        return plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DynamicInfo
    extends HashMap<String, Map<String, String>> {
        private static final long serialVersionUID = -5291159195829859576L;

        public DynamicInfo() {
            super.putAll(allexts);
        }
    }
}

