/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.rcp.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.mat.ui.rcp.Messages;
import org.eclipse.mat.ui.rcp.RCPPlugin;
import org.eclipse.mat.util.RegistryReader;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class OpenPreferenceAction
extends Action {
    private static final Set<String> ALLOWED_IDS = new HashSet<String>(Arrays.asList("org.eclipse.ui.net.NetPreferences", "org.eclipse.ui.preferencePages.Workbench", "org.eclipse.ui.preferencePages.Keys", "org.eclipse.ui.preferencePages.Views", "org.eclipse.ui.preferencePages.ColorsAndFonts", "org.eclipse.ui.preferencePages.ContentTypes", "org.eclipse.ui.preferencePages.Editors", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.preferencePages.Workspace", "org.eclipse.ui.browser.preferencePage", "org.eclipse.help.ui.browsersPreferencePage", "org.eclipse.help.ui.contentPreferencePage", "org.eclipse.ui.trace.tracingPage", "org.eclipse.equinox.internal.p2.ui.sdk.ProvisioningPreferencePage", "org.eclipse.equinox.internal.p2.ui.sdk.SitesPreferencePage", "org.eclipse.equinox.internal.p2.ui.sdk.TrustPreferencePage", "org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatesPreferencePage", "org.eclipse.update.internal.ui.preferences.MainPreferencePage"));
    private static final String MAT_PREFIX = "org.eclipse.mat.";
    PreferenceRegistry reg;

    public OpenPreferenceAction() {
        super(Messages.OpenPreferenceAction_Preferences);
    }

    public void run() {
        if (this.reg == null) {
            this.reg = new PreferenceRegistry();
        }
        PreferenceManager manager = new PreferenceManager('/');
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (Node node : this.reg.delegates()) {
            node.subNode = false;
            IPreferenceNode[] iPreferenceNodeArray = node.getSubNodes();
            int n = iPreferenceNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPreferenceNode subNode = iPreferenceNodeArray[n2];
                node.remove(subNode.getId());
                ++n2;
            }
            nodes.put(node.getId(), node);
        }
        for (Node node : this.reg.delegates()) {
            if (node.getCategory() == null || !nodes.containsKey(node.getCategory())) continue;
            ((Node)((Object)nodes.get(node.getCategory()))).add((IPreferenceNode)node);
            node.subNode = true;
        }
        ArrayList<Node> toSort = new ArrayList<Node>();
        for (Node node : nodes.values()) {
            if (node.subNode) continue;
            toSort.add(node);
        }
        Collections.sort(toSort, new Comparator<Node>(){

            @Override
            public int compare(Node object1, Node object2) {
                return object1.getLabelText().compareTo(object2.getLabelText());
            }
        });
        for (Node node : toSort) {
            manager.addToRoot((IPreferenceNode)node);
        }
        String pageId = "org.eclipse.mat.ui.Preferences";
        Set nodeset = nodes.keySet();
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)pageId, (String[])nodeset.toArray(new String[nodeset.size()]), null);
        dialog.setHelpAvailable(true);
        dialog.open();
    }

    private static class Node
    extends PreferenceNode {
        private IConfigurationElement configElement;
        private boolean subNode;

        public Node(String id, IConfigurationElement configurationElement) {
            super(id);
            this.configElement = configurationElement;
        }

        public String getLabelText() {
            return this.configElement.getAttribute("name");
        }

        public String getCategory() {
            return this.configElement.getAttribute("category");
        }

        public void createPage() {
            IWorkbenchPreferencePage page;
            try {
                page = (IWorkbenchPreferencePage)this.configElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            page.init(PlatformUI.getWorkbench());
            if (this.getLabelImage() != null) {
                page.setImageDescriptor(this.getImageDescriptor());
            }
            page.setTitle(this.getLabelText());
            this.setPage((IPreferencePage)page);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PreferenceRegistry
    extends RegistryReader<Node> {
        public PreferenceRegistry() {
            this.init(RCPPlugin.getDefault().getExtensionTracker(), "org.eclipse.ui.preferencePages");
        }

        protected Node createDelegate(IConfigurationElement configElement) throws CoreException {
            String id = configElement.getAttribute("id");
            return id.startsWith(OpenPreferenceAction.MAT_PREFIX) || ALLOWED_IDS.contains(id) ? new Node(id, configElement) : null;
        }

        protected void removeDelegate(Node delegate) {
        }
    }
}

