/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveFileV3;
import org.eclipse.birt.core.archive.compound.ArchiveView;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFileFactory;

public class ArchiveFileFactory
implements IArchiveFileFactory {
    @Override
    public IArchiveFile createArchive(String archiveId) throws IOException {
        String fileName = this.getPhysicalFile(archiveId);
        return this.doCreateArchive(archiveId, fileName, "rw");
    }

    @Override
    public IArchiveFile createTransientArchive(String archiveId) throws IOException {
        String fileName = this.getPhysicalFile(archiveId);
        return this.doCreateArchive(archiveId, fileName, "rwt");
    }

    private IArchiveFile doCreateArchive(String archiveId, String fileName, String mode) throws IOException {
        ArchiveFileV3 af = new ArchiveFileV3(fileName, mode);
        af.setSystemId(archiveId);
        return af;
    }

    @Override
    public IArchiveFile createView(String viewId, IArchiveFile archive) throws IOException {
        String fileName = this.getPhysicalFile(viewId);
        return this.doCreateView(fileName, viewId, archive, "rw");
    }

    @Override
    public IArchiveFile createTransientView(String viewId, IArchiveFile archive) throws IOException {
        String fileName = this.getPhysicalFile(viewId);
        return this.doCreateView(fileName, viewId, archive, "rwt");
    }

    private IArchiveFile doCreateView(String viewId, String fileName, IArchiveFile archive, String mode) throws IOException {
        ArchiveFileV3 view = new ArchiveFileV3(fileName, mode);
        view.setSystemId(viewId);
        view.setDependId(archive.getSystemId());
        return new ArchiveView(view, archive, true);
    }

    @Override
    public IArchiveFile openArchive(String archiveId, String mode) throws IOException {
        String fileName = this.getPhysicalFile(archiveId);
        ArchiveFile file = new ArchiveFile(fileName, archiveId, mode);
        String dependId = file.getDependId();
        if (dependId != null && dependId.length() > 0) {
            IArchiveFile archive = this.openArchive(dependId, "r");
            return new ArchiveView(file, archive, false);
        }
        return file;
    }

    @Override
    public IArchiveFile openView(String viewId, String mode, IArchiveFile archive) throws IOException {
        String fileName = this.getPhysicalFile(viewId);
        ArchiveFile view = new ArchiveFile(fileName, viewId, mode);
        return new ArchiveView(view, archive, true);
    }

    protected String getPhysicalFile(String systemId) {
        return systemId;
    }
}

