/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;

public class ArrayListSubListCollectionExtractor
extends FieldSizeArrayCollectionExtractor {
    private String offset;

    public ArrayListSubListCollectionExtractor(String sizeField, String arrayField, String firstIndex) {
        super(sizeField, arrayField);
        if (firstIndex == null) {
            throw new IllegalArgumentException();
        }
        this.offset = firstIndex;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        ISnapshot snapshot = coll.getSnapshot();
        long[] referenceArray = this.extractEntries(coll).getReferenceArray();
        Integer size = this.getSize(coll);
        if (size == null) {
            return new int[0];
        }
        ArrayInt arr = new ArrayInt(size.intValue());
        if (size > 0) {
            int firstIndex = (Integer)coll.resolveValue(this.offset);
            int lastIndex = firstIndex + this.getSize(coll);
            int i = firstIndex;
            while (i < lastIndex) {
                if (referenceArray[i] != 0L) {
                    arr.add(snapshot.mapAddressToId(referenceArray[i]));
                }
                ++i;
            }
        }
        return arr.toArray();
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        return this.getSize(coll);
    }
}

