/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.NumberDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.NumberUtil;

public final class DifferenceEntry
extends NumberDataPointEntry {
    private double dPosValue;
    private double dNegValue;
    private BigNumber bnPosValue;
    private BigNumber bnNegValue;
    private boolean isBigNumber = false;
    private com.ibm.icu.math.BigDecimal divisor;
    private boolean isBigDecimal = false;
    private Number bdPosValue;
    private Number bdNegValue;

    public DifferenceEntry(double dPositiveValue, double dNegativeValue) {
        this.dPosValue = dPositiveValue;
        this.dNegValue = dNegativeValue;
    }

    public DifferenceEntry(Object[] oaTwoComponents) {
        assert (oaTwoComponents.length == 2);
        if (oaTwoComponents[0] instanceof BigNumber) {
            this.init((BigNumber)oaTwoComponents[0], (BigNumber)oaTwoComponents[1]);
        } else if (NumberUtil.isBigDecimal((Object)oaTwoComponents[0]) || NumberUtil.isBigDecimal((Object)oaTwoComponents[1])) {
            this.isBigDecimal = true;
            this.init((Number)oaTwoComponents[0], (Number)oaTwoComponents[1]);
        } else {
            this.init(oaTwoComponents);
        }
    }

    protected void init(Object[] oaTwoComponents) {
        this.isBigNumber = false;
        this.dPosValue = oaTwoComponents[0] instanceof Number ? ((Number)oaTwoComponents[0]).doubleValue() : Double.NaN;
        this.dNegValue = oaTwoComponents[1] instanceof Number ? ((Number)oaTwoComponents[1]).doubleValue() : Double.NaN;
    }

    protected void init(BigNumber bnPositiveValue, BigNumber bnNegativeValue) {
        this.isBigNumber = true;
        this.bnPosValue = bnPositiveValue;
        this.bnNegValue = bnNegativeValue;
        this.divisor = null;
        if (this.bnPosValue != null) {
            this.divisor = this.bnPosValue.getDivisor();
            this.dPosValue = this.bnPosValue.doubleValue();
        } else {
            this.dPosValue = 0.0;
        }
        if (this.bnNegValue != null) {
            if (this.divisor == null) {
                this.divisor = this.bnNegValue.getDivisor();
            }
            this.dNegValue = this.bnNegValue.doubleValue();
        } else {
            this.dNegValue = 0.0;
        }
    }

    protected void init(Number bdPositiveValue, Number bdNegativeValue) {
        if (this.isBigDecimal) {
            if (NumberUtil.isJavaMathBigDecimal((Object)bdPositiveValue) || bdPositiveValue == null && NumberUtil.isJavaMathBigDecimal((Object)bdNegativeValue)) {
                this.bdPosValue = NumberUtil.asJavaMathBigDecimal((Number)bdPositiveValue);
                this.bdNegValue = NumberUtil.asJavaMathBigDecimal((Number)bdNegativeValue);
            } else {
                this.bdPosValue = NumberUtil.asBigDecimal((Number)bdPositiveValue);
                this.bdNegValue = NumberUtil.asBigDecimal((Number)bdNegativeValue);
            }
            this.dPosValue = this.bdPosValue == null ? 0.0 : this.bdPosValue.doubleValue();
            this.dNegValue = this.bdNegValue == null ? 0.0 : this.bdNegValue.doubleValue();
        }
    }

    public String toString() {
        return this.getFormattedString(null, ULocale.getDefault());
    }

    public double getPositiveValue() {
        return this.dPosValue;
    }

    public Number getPositiveValueNumber() {
        if (this.isBigNumber) {
            return this.bnPosValue;
        }
        if (this.isBigDecimal) {
            return this.bdPosValue;
        }
        return this.dPosValue;
    }

    public void setPositiveValue(double value) {
        this.dPosValue = value;
    }

    public void setPositiveValue(Number value) {
        if (this.isBigNumber && value instanceof BigNumber) {
            this.bnPosValue = (BigNumber)value;
        }
        this.setPositiveValue(value.doubleValue());
    }

    public double getNegativeValue() {
        return this.dNegValue;
    }

    public Number getNegativeValueNumber() {
        if (this.isBigNumber) {
            return this.bnNegValue;
        }
        if (this.isBigDecimal) {
            return this.bdNegValue;
        }
        return this.dNegValue;
    }

    public void setNegativeValue(double value) {
        this.dNegValue = value;
    }

    public void setNegativeValue(Number value) {
        if (this.isBigNumber && value instanceof BigNumber) {
            this.bnNegValue = (BigNumber)value;
        }
        this.setNegativeValue(value.doubleValue());
    }

    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        String str = "";
        try {
            if ("difference_positive".equals(type)) {
                Object posValue = this.isBigNumber ? this.bnPosValue : Double.valueOf(this.dPosValue);
                str = ValueFormatter.format((Object)posValue, (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("difference_negative".equals(type)) {
                Object negValue = this.isBigNumber ? this.bnNegValue : Double.valueOf(this.dNegValue);
                str = ValueFormatter.format((Object)negValue, (FormatSpecifier)formatter, (ULocale)locale, null);
            }
        }
        catch (ChartException e) {
            Logger.getLogger((String)"org.eclipse.birt.chart.engine/exception").log((Exception)((Object)e));
        }
        return str;
    }

    public String getFormattedString(FormatSpecifier formatter, ULocale locale) {
        String strPos = this.getFormattedString("difference_positive", formatter, locale);
        String strNeg = this.getFormattedString("difference_negative", formatter, locale);
        return "P " + strPos + "; N " + strNeg;
    }

    public boolean isValid() {
        if (this.isBigNumber) {
            return true;
        }
        return !Double.isNaN(this.dNegValue) && !Double.isNaN(this.dPosValue);
    }

    public boolean isBigNumber() {
        return this.isBigNumber;
    }

    public com.ibm.icu.math.BigDecimal getDivisor() {
        return this.divisor;
    }

    public void setNumberData(Number[] data) {
        if (data == null || data.length < 2) {
            return;
        }
        if (data instanceof BigNumber[]) {
            this.init(((BigNumber[])data)[0], ((BigNumber[])data)[1]);
        } else {
            this.init(data);
        }
    }

    public Number[] getNumberData() {
        if (this.isBigNumber) {
            return new BigNumber[]{this.bnPosValue, this.bnNegValue};
        }
        if (this.isBigDecimal) {
            if (this.bdPosValue instanceof com.ibm.icu.math.BigDecimal) {
                return new com.ibm.icu.math.BigDecimal[]{(com.ibm.icu.math.BigDecimal)this.bdPosValue, (com.ibm.icu.math.BigDecimal)this.bdNegValue};
            }
            return new BigDecimal[]{(BigDecimal)this.bdPosValue, (BigDecimal)this.bdNegValue};
        }
        return new Double[]{this.dPosValue, this.dNegValue};
    }
}

