/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.mat.hprof.IPositionInputStream;
import org.eclipse.mat.hprof.Messages;

public class ByteArrayPositionInputStream
implements IPositionInputStream,
Closeable,
AutoCloseable {
    private final byte[] bytes;
    private int position = 0;
    private final int idSize;

    public ByteArrayPositionInputStream(byte[] bytes, int idSize) {
        this.bytes = bytes;
        this.idSize = idSize;
    }

    @Override
    public void close() throws IOException {
        this.position = this.bytes.length;
    }

    @Override
    public int read() {
        if (this.position >= this.bytes.length) {
            return -1;
        }
        return 0xFF & this.bytes[this.position++];
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.position >= this.bytes.length) {
            return -1;
        }
        if (this.position > this.bytes.length - len) {
            len = this.bytes.length - this.position;
        }
        System.arraycopy(this.bytes, this.position, b, off, len);
        this.position += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        if (this.position >= this.bytes.length) {
            return 0L;
        }
        if ((long)this.position > (long)this.bytes.length - n) {
            n = this.bytes.length - this.position;
        }
        this.position = (int)((long)this.position + n);
        return n;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException(Messages.IPositionInputStream_mark);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException(Messages.IPositionInputStream_reset);
    }

    @Override
    public int skipBytes(long n) {
        return (int)this.skip(n);
    }

    @Override
    public void readFully(byte[] b) throws EOFException {
        int r = this.read(b, 0, b.length);
        if (r < b.length) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws EOFException {
        int r = this.read(b, off, len);
        if (r < len) {
            throw new EOFException();
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public int readInt() throws EOFException {
        if (this.position > this.bytes.length - 4) {
            throw new EOFException();
        }
        int ch1 = this.bytes[this.position] & 0xFF;
        int ch2 = this.bytes[this.position + 1] & 0xFF;
        int ch3 = this.bytes[this.position + 2] & 0xFF;
        int ch4 = this.bytes[this.position + 3] & 0xFF;
        int result = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        this.position += 4;
        return result;
    }

    @Override
    public long readLong() throws EOFException {
        if (this.position > this.bytes.length - 4) {
            throw new EOFException();
        }
        long result = ((long)this.bytes[this.position] << 56) + ((long)(this.bytes[this.position + 1] & 0xFF) << 48) + ((long)(this.bytes[this.position + 2] & 0xFF) << 40) + ((long)(this.bytes[this.position + 3] & 0xFF) << 32) + ((long)(this.bytes[this.position + 4] & 0xFF) << 24) + (long)((this.bytes[this.position + 5] & 0xFF) << 16) + (long)((this.bytes[this.position + 6] & 0xFF) << 8) + (long)((this.bytes[this.position + 7] & 0xFF) << 0);
        this.position += 8;
        return result;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    protected int readIntArray(int[] a) throws EOFException {
        int i = 0;
        while (i < a.length) {
            a[i] = this.readInt();
            ++i;
        }
        return a.length;
    }

    protected int readLongArray(long[] a) throws EOFException {
        int i = 0;
        while (i < a.length) {
            a[i] = this.readLong();
            ++i;
        }
        return a.length;
    }

    @Override
    public long readUnsignedInt() throws EOFException {
        return 0xFFFFFFFFL & (long)this.readInt();
    }

    @Override
    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        if (this.position >= this.bytes.length) {
            return 0;
        }
        if (this.position > this.bytes.length - n) {
            n = this.bytes.length - this.position;
        }
        this.position += n;
        return n;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L || pos > Integer.MAX_VALUE) {
            throw new IOException();
        }
        this.position = (int)pos;
    }

    @Override
    public String readUTF() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readID(int idSize) throws IOException {
        return idSize == 4 ? 0xFFFFFFFFL & (long)this.readInt() : this.readLong();
    }
}

