/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.mft.gmf.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.mylyn.mft.gmf.ui.ContextDecoratorProvider;
import org.eclipse.mylyn.mft.gmf.ui.RevealMouseListener;
import org.eclipse.mylyn.mft.gmf.ui.figures.IRevealableFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextDecorator
implements IDecorator {
    private final ContextDecoratorProvider provider;
    boolean wasInteresting;
    boolean wasLandmark;
    boolean wasFocussed;
    boolean initialized;
    private final List<IRevealableFigure> decorationFigures;
    private final List<IDecoration> decorations;
    private final IDecoratorTarget target;

    public ContextDecorator(ContextDecoratorProvider provider, IDecoratorTarget target) {
        this.provider = provider;
        this.target = target;
        this.decorationFigures = new ArrayList<IRevealableFigure>();
        this.decorations = new ArrayList<IDecoration>();
        target.installDecorator((Object)"mylyn-detail", (IDecorator)this);
    }

    public void activate() {
        this.refresh();
    }

    public void deactivate() {
        this.initialized = false;
        this.removeDecorations();
    }

    public void refresh() {
        boolean interesting = this.isInteresting();
        boolean landmark = this.isLandmark();
        boolean focussed = this.provider.isFocussed();
        if (focussed != this.wasFocussed || interesting != this.wasInteresting || landmark != this.wasLandmark || !this.initialized) {
            this.removeDecorations();
            if (focussed) {
                this.createDecoration();
            }
        }
        this.wasInteresting = interesting;
        this.wasLandmark = landmark;
        this.wasFocussed = focussed;
        this.initialized = true;
    }

    protected abstract void createDecoration();

    IDecoration addDecoration(IRevealableFigure decorationFigure) {
        GraphicalEditPart ownerEditPart = (GraphicalEditPart)this.getDecoratorTarget().getAdapter(GraphicalEditPart.class);
        if (ownerEditPart == null) {
            throw new RuntimeException();
        }
        IDecoration decoration = this.getDecoratorTarget().addDecoration((IFigure)decorationFigure, (Locator)decorationFigure, true);
        this.decorationFigures.add(decorationFigure);
        this.decorations.add(decoration);
        return decoration;
    }

    protected void removeDecorations() {
        for (IRevealableFigure figure : this.decorationFigures) {
            figure.restore();
            IGraphicalEditPart part = (IGraphicalEditPart)this.getTarget().getAdapter(IGraphicalEditPart.class);
            RevealMouseListener listenerForRoot = this.provider.getListenerForRoot(part.getRoot());
            if (listenerForRoot == null) continue;
            listenerForRoot.removeDecoration(figure);
        }
        this.decorationFigures.clear();
        for (IDecoration decoration : this.decorations) {
            this.getDecoratorTarget().removeDecoration(decoration);
        }
        this.decorations.clear();
    }

    public ContextDecoratorProvider getProvider() {
        return this.provider;
    }

    IDecoratorTarget getDecoratorTarget() {
        return this.getTarget();
    }

    public abstract boolean isInteresting();

    public abstract boolean isLandmark();

    public IDecoratorTarget getTarget() {
        return this.target;
    }

    IGraphicalEditPart getEditPart() {
        return (IGraphicalEditPart)this.getTarget().getAdapter(IGraphicalEditPart.class);
    }

    public IFigure getDecoratedFigure() {
        if (this.getEditPart() != null) {
            return this.getEditPart().getFigure();
        }
        return null;
    }

    public List<IRevealableFigure> getDecorationFigures() {
        return this.decorationFigures;
    }
}

