/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.mft.gmf.ui;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.mylyn.mft.gmf.ui.figures.IRevealableFigure;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevealMouseListener
implements MouseMoveListener,
MouseTrackListener {
    private static final int REVEAL_DISTANCE = 180;
    private Collection<IRevealableFigure> lastDecorations = new HashSet<IRevealableFigure>();
    private final IFigure layer;

    RevealMouseListener(IFigure layer) {
        this.layer = layer;
    }

    private Collection<IRevealableFigure> getTargetFigures(Point mousePoint) {
        Rectangle revealBounds = new Rectangle(mousePoint, new Dimension(360, 360));
        this.layer.translateFromParent((Translatable)revealBounds);
        revealBounds.translate(-180, -180);
        HashSet<IRevealableFigure> found = new HashSet<IRevealableFigure>();
        this.findChildFigure(this.layer, revealBounds, found);
        return found;
    }

    private void findChildFigure(IFigure parent, Rectangle revealBounds, HashSet<IRevealableFigure> found) {
        for (Object object : parent.getChildren()) {
            IFigure child = (IFigure)object;
            Rectangle clientArea = child.getClientArea();
            Rectangle childRevealBounds = revealBounds.getCopy();
            child.translateFromParent((Translatable)childRevealBounds);
            if (!childRevealBounds.intersects(clientArea)) continue;
            IRevealableFigure figure = this.getRevealableMember(child);
            if (figure != null) {
                found.add(figure);
            }
            this.findChildFigure(child, childRevealBounds, found);
        }
    }

    private void findAllChildFigures(IFigure parent, HashSet<IRevealableFigure> found) {
        for (Object object : parent.getChildren()) {
            IFigure child = (IFigure)object;
            IRevealableFigure figure = this.getRevealableMember(child);
            if (figure != null) {
                found.add(figure);
            }
            this.findAllChildFigures(child, found);
        }
    }

    public IRevealableFigure getRevealableMember(IFigure candFigure) {
        if (candFigure instanceof IRevealableFigure) {
            return (IRevealableFigure)candFigure;
        }
        if (candFigure instanceof Decoration) {
            for (Object object : ((Decoration)candFigure).getChildren()) {
                if (!(object instanceof IRevealableFigure)) continue;
                return (IRevealableFigure)object;
            }
        } else if (candFigure.getParent() != null) {
            return this.getRevealableMember(candFigure.getParent());
        }
        return null;
    }

    private int distance(Rectangle rectangle, Point point) {
        int dx = 0;
        if (point.x < rectangle.x) {
            dx = rectangle.x - point.x;
        } else if (point.x > rectangle.right()) {
            dx = point.x - rectangle.right();
        }
        int dy = 0;
        if (point.y < rectangle.y) {
            dy = rectangle.y - point.y;
        } else if (point.y > rectangle.bottom()) {
            dy = point.y - rectangle.bottom();
        }
        return (int)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
    }

    private double nearness(IFigure figure, Point point) {
        Rectangle clientArea = figure.getClientArea().getCopy();
        figure.translateToAbsolute((Translatable)clientArea);
        double d = this.distance(clientArea, point);
        d = Math.min(d, 180.0);
        double n = 1.0 - d / 180.0;
        return n;
    }

    public void mouseMove(MouseEvent e) {
        Point mousePoint = new Point(e.x, e.y);
        Collection<IRevealableFigure> newDecorations = this.getTargetFigures(mousePoint);
        if (!newDecorations.equals(this.lastDecorations)) {
            HashSet<IRevealableFigure> removedFigures = new HashSet<IRevealableFigure>(this.lastDecorations);
            removedFigures.removeAll(newDecorations);
            for (IRevealableFigure removedFigure : removedFigures) {
                if (removedFigure.getParent() == null || removedFigure.getParent().getParent() == null) continue;
                removedFigure.unreveal();
            }
        }
        for (IRevealableFigure figure : newDecorations) {
            double n = this.nearness(figure, mousePoint);
            figure.reveal(n);
        }
        this.lastDecorations = newDecorations;
    }

    public void removeDecoration(IFigure decoration) {
        this.lastDecorations.remove(decoration);
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        HashSet<IRevealableFigure> allFigures = new HashSet<IRevealableFigure>();
        this.findAllChildFigures(this.layer, allFigures);
        for (IRevealableFigure revealableFigure : allFigures) {
            revealableFigure.unreveal();
        }
    }

    public void mouseHover(MouseEvent e) {
    }
}

