/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.platform.xdk110.connectivity.BleGenerator;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class BleValidator
implements IResourceValidator {
    public void validate(Program program, EObject context, ValidationMessageAcceptor acceptor) {
        if (context instanceof SystemResourceSetup) {
            this.validateUniqueUUIDs(program, (SystemResourceSetup)context, acceptor);
            this.validateMacAddress(program, (SystemResourceSetup)context, acceptor);
        }
    }

    private void validateUniqueUUIDs(Program program, SystemResourceSetup setup, ValidationMessageAcceptor acceptor) {
        Functions.Function1<SignalInstance, Object> _function = new Functions.Function1<SignalInstance, Object>(){

            public Object apply(SignalInstance x) {
                Expression _initialization = x.getInitialization();
                ElementReferenceExpression ref = (ElementReferenceExpression)_initialization;
                EObject _reference = ref.getReference();
                Expression arg = ModelUtils.getArgumentValue((Operation)((Operation)_reference), (ArgumentExpression)ref, (String)"UUID");
                Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                    public void apply(EObject z) {
                    }
                };
                return StaticValueInferrer.infer((EObject)arg, (Procedures.Procedure1)_function);
            }
        };
        Map uuidGroups = IterableExtensions.groupBy((Iterable)setup.getSignalInstances(), (Functions.Function1)_function);
        Set _entrySet = uuidGroups.entrySet();
        for (Map.Entry group : _entrySet) {
            boolean _greaterThan;
            int _length = ((Object[])Conversions.unwrapArray(group.getValue(), Object.class)).length;
            boolean bl = _greaterThan = _length > 1;
            if (!_greaterThan) continue;
            acceptor.acceptError("UUID must be unique among characteristics", (EObject)IterableExtensions.last((Iterable)((Iterable)group.getValue())), (EStructuralFeature)ProgramPackage.eINSTANCE.getVariableDeclaration_Initialization(), 0, "UUID_NOT_UNIQUE", new String[0]);
        }
    }

    protected Object validateMacAddress(Program program, SystemResourceSetup setup, ValidationMessageAcceptor acceptor) {
        Object _xblockexpression = null;
        Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

            public Boolean apply(ConfigurationItemValue it) {
                String _name = it.getItem().getName();
                return Objects.equal((Object)_name, (Object)"macAddress");
            }
        };
        ConfigurationItemValue itemValue = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)setup.getConfigurationItemValues(), (Functions.Function1)_function);
        Object _xifexpression = null;
        if (itemValue != null) {
            Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            Object value = StaticValueInferrer.infer((EObject)itemValue.getValue(), (Procedures.Procedure1)_function_1);
            if (value == null) {
                acceptor.acceptError("Unknown error in BLE validation", (EObject)itemValue, null, 0, "", new String[0]);
            }
            if (value instanceof String) {
                boolean valid = BleGenerator.MAC_ADDRESS_PATTERN.matcher((CharSequence)value).matches();
                if (!valid) {
                    acceptor.acceptError("Your MAC address is not in the correct format: " + (String)value + "\nThe address should be of the format: FC:D6:BD:xx:xx:xx", (EObject)itemValue, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "mac_address_wrong_format", new String[0]);
                }
            } else {
                acceptor.acceptError("Unknown error in BLE validation", (EObject)itemValue, null, 0, "", new String[0]);
            }
        } else {
            _xifexpression = null;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

