/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.internal;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.SystemResourceEvent;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IComponentConfiguration;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.mita.program.generator.ProgramDslTraceExtensions;
import org.eclipse.mita.program.generator.TypeGenerator;
import org.eclipse.mita.program.generator.internal.GeneratorRegistry;
import org.eclipse.mita.program.generator.internal.MapBasedComponentConfiguration;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class SystemResourceHandlingGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected GeneratorRegistry registry;
    @Inject(optional=true)
    protected IPlatformExceptionGenerator exceptionGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected TypeGenerator typeGenerator;
    @Inject
    protected ITypeSystemInferrer typeInferrer;
    @Inject
    @Extension
    protected ProgramDslTraceExtensions _programDslTraceExtensions;

    public Iterable<String> generateAdditionalFiles(IFileSystemAccess2 fsa, CompilationContext context, EObject obj) {
        Iterable<String> _xblockexpression = null;
        Pair<AbstractSystemResource, SystemResourceSetup> componentAndSetup = this._generatorUtils.getComponentAndSetup(obj, context);
        AbstractSystemResource component = (AbstractSystemResource)componentAndSetup.getKey();
        SystemResourceSetup setup = (SystemResourceSetup)componentAndSetup.getValue();
        AbstractSystemResourceGenerator internalGenerator = this.registry.getGenerator(component);
        if (internalGenerator != null) {
            internalGenerator.prepare(context, component, setup, this.getConfiguration(context, component, setup), this.getRelevantEventHandler(context, component));
        }
        _xblockexpression = internalGenerator.generateAdditionalFiles(fsa);
        return _xblockexpression;
    }

    public CompositeGeneratorNode generateHeader(CompilationContext context, EObject obj) {
        Pair<AbstractSystemResource, SystemResourceSetup> componentAndSetup = this._generatorUtils.getComponentAndSetup(obj, context);
        final AbstractSystemResource component = (AbstractSystemResource)componentAndSetup.getKey();
        final SystemResourceSetup setup = (SystemResourceSetup)componentAndSetup.getValue();
        final AbstractSystemResourceGenerator internalGenerator = this.registry.getGenerator(component);
        if (internalGenerator != null) {
            internalGenerator.prepare(context, component, setup, this.getConfiguration(context, component, setup), this.getRelevantEventHandler(context, component));
        }
        final CodeFragment exceptionType = this.exceptionGenerator.getExceptionType();
        final String name = EcoreUtil.getID((EObject)component);
        CompositeGeneratorNode cgn = this._programDslTraceExtensions.trace(obj);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Sets up the ");
                _builder.append((Object)name, " ");
                _builder.append((Object)".");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)exceptionType);
                _builder.append((Object)" ");
                SystemResourceSetup _elvis = null;
                _elvis = setup != null ? setup : component;
                String _setupName = SystemResourceHandlingGenerator.this._generatorUtils.getSetupName(_elvis);
                _builder.append((Object)_setupName);
                _builder.append((Object)"(void);");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Enables the ");
                _builder.append((Object)name, " ");
                _builder.append((Object)" sensor.");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)exceptionType);
                _builder.append((Object)" ");
                SystemResourceSetup _elvis_1 = null;
                _elvis_1 = setup != null ? setup : component;
                String _enableName = SystemResourceHandlingGenerator.this._generatorUtils.getEnableName(_elvis_1);
                _builder.append((Object)_enableName);
                _builder.append((Object)"(void);");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                if (setup != null) {
                    EList<SignalInstance> _signalInstances = null;
                    if (setup != null) {
                        _signalInstances = setup.getSignalInstances();
                    }
                    for (SignalInstance signalInstance : _signalInstances) {
                        TypeSpecifier signalType = ModelUtils.toSpecifier(SystemResourceHandlingGenerator.this.typeInferrer.infer((EObject)signalInstance.getInstanceOf()));
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"/**");
                        _builder.newLine();
                        _builder.append((Object)" ");
                        _builder.append((Object)"* Provides read access to ");
                        String _name = signalInstance.getName();
                        _builder.append((Object)_name, " ");
                        _builder.append((Object)".");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)" ");
                        _builder.append((Object)"*/");
                        _builder.newLine();
                        _builder.append((Object)exceptionType);
                        _builder.append((Object)" ");
                        String _readAccessName = SystemResourceHandlingGenerator.this._generatorUtils.getReadAccessName(signalInstance);
                        _builder.append((Object)_readAccessName);
                        _builder.append((Object)"(");
                        CodeFragment _code = SystemResourceHandlingGenerator.this.typeGenerator.code(signalType);
                        _builder.append((Object)_code);
                        _builder.append((Object)"* result);");
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        boolean _isWriteable = signalInstance.isWriteable();
                        if (!_isWriteable) continue;
                        _builder.append((Object)"/**");
                        _builder.newLine();
                        _builder.append((Object)" ");
                        _builder.append((Object)"* Provides write access to ");
                        String _name_1 = signalInstance.getName();
                        _builder.append((Object)_name_1, " ");
                        _builder.append((Object)".");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)" ");
                        _builder.append((Object)"*/");
                        _builder.newLine();
                        _builder.append((Object)exceptionType);
                        _builder.append((Object)" ");
                        String _writeAccessName = SystemResourceHandlingGenerator.this._generatorUtils.getWriteAccessName(signalInstance);
                        _builder.append((Object)_writeAccessName);
                        _builder.append((Object)"(");
                        CodeFragment _code_1 = SystemResourceHandlingGenerator.this.typeGenerator.code(signalType);
                        _builder.append((Object)_code_1);
                        _builder.append((Object)"* result);");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.newLine();
                CodeFragment _generateAdditionalHeaderContent = null;
                if (internalGenerator != null) {
                    _generateAdditionalHeaderContent = internalGenerator.generateAdditionalHeaderContent();
                }
                _builder.append(_generateAdditionalHeaderContent);
                _builder.newLineIfNotEmpty();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenation _builder = new StringConcatenation();
        String _upperCase = this._generatorUtils.getBaseName(component).toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_");
        String _upperCase_1 = name.toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_H");
        cgn.getChildren().add(_create.toHeader(context, _builder.toString()));
        return cgn;
    }

    public CompositeGeneratorNode generateImplementation(CompilationContext context, EObject obj) {
        Pair<AbstractSystemResource, SystemResourceSetup> componentAndSetup = this._generatorUtils.getComponentAndSetup(obj, context);
        final AbstractSystemResource component = (AbstractSystemResource)componentAndSetup.getKey();
        final SystemResourceSetup setup = (SystemResourceSetup)componentAndSetup.getValue();
        final AbstractSystemResourceGenerator internalGenerator = this.registry.getGenerator(component);
        if (internalGenerator != null) {
            internalGenerator.prepare(context, component, setup, this.getConfiguration(context, component, setup), this.getRelevantEventHandler(context, component));
        }
        final CodeFragment exceptionType = this.exceptionGenerator.getExceptionType();
        CompositeGeneratorNode cgn = this._programDslTraceExtensions.trace(obj);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)exceptionType);
                _builder.append((Object)" ");
                SystemResourceSetup _elvis = null;
                _elvis = setup != null ? setup : component;
                String _setupName = SystemResourceHandlingGenerator.this._generatorUtils.getSetupName(_elvis);
                _builder.append((Object)_setupName);
                _builder.append((Object)"(void)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateSetup = null;
                if (internalGenerator != null) {
                    _generateSetup = internalGenerator.generateSetup();
                }
                _builder.append((Object)_generateSetup, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return NO_EXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)exceptionType);
                _builder.append((Object)" ");
                SystemResourceSetup _elvis_1 = null;
                _elvis_1 = setup != null ? setup : component;
                String _enableName = SystemResourceHandlingGenerator.this._generatorUtils.getEnableName(_elvis_1);
                _builder.append((Object)_enableName);
                _builder.append((Object)"(void)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateEnable = null;
                if (internalGenerator != null) {
                    _generateEnable = internalGenerator.generateEnable();
                }
                _builder.append((Object)_generateEnable, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return NO_EXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                if (setup != null) {
                    EList<SignalInstance> _signalInstances = null;
                    if (setup != null) {
                        _signalInstances = setup.getSignalInstances();
                    }
                    for (SignalInstance signalInstance : _signalInstances) {
                        TypeSpecifier signalType = ModelUtils.toSpecifier(SystemResourceHandlingGenerator.this.typeInferrer.infer((EObject)signalInstance.getInstanceOf()));
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"/**");
                        _builder.newLine();
                        _builder.append((Object)" ");
                        _builder.append((Object)"* Provides read access to the ");
                        String _name = signalInstance.getName();
                        _builder.append((Object)_name, " ");
                        _builder.append((Object)" signal.");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)" ");
                        _builder.append((Object)"*/");
                        _builder.newLine();
                        _builder.append((Object)exceptionType);
                        _builder.append((Object)" ");
                        String _readAccessName = SystemResourceHandlingGenerator.this._generatorUtils.getReadAccessName(signalInstance);
                        _builder.append((Object)_readAccessName);
                        _builder.append((Object)"(");
                        CodeFragment _code = SystemResourceHandlingGenerator.this.typeGenerator.code(signalType);
                        _builder.append((Object)_code);
                        _builder.append((Object)"* result)");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        CodeFragment _generateSignalInstanceGetter = null;
                        if (internalGenerator != null) {
                            _generateSignalInstanceGetter = internalGenerator.generateSignalInstanceGetter(signalInstance, "result");
                        }
                        _builder.append(_generateSignalInstanceGetter, "\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return NO_EXCEPTION;");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.newLine();
                        boolean _isWriteable = signalInstance.isWriteable();
                        if (_isWriteable) {
                            _builder.append((Object)"/**");
                            _builder.newLine();
                            _builder.append((Object)" ");
                            _builder.append((Object)"* Provides write access to the ");
                            String _name_1 = signalInstance.getName();
                            _builder.append((Object)_name_1, " ");
                            _builder.append((Object)" signal.");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)" ");
                            _builder.append((Object)"*/");
                            _builder.newLine();
                            _builder.append((Object)exceptionType);
                            _builder.append((Object)" ");
                            String _writeAccessName = SystemResourceHandlingGenerator.this._generatorUtils.getWriteAccessName(signalInstance);
                            _builder.append((Object)_writeAccessName);
                            _builder.append((Object)"(");
                            CodeFragment _code_1 = SystemResourceHandlingGenerator.this.typeGenerator.code(signalType);
                            _builder.append((Object)_code_1);
                            _builder.append((Object)"* value)");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            CodeFragment _generateSignalInstanceSetter = null;
                            if (internalGenerator != null) {
                                _generateSignalInstanceSetter = internalGenerator.generateSignalInstanceSetter(signalInstance, "value");
                            }
                            _builder.append(_generateSignalInstanceSetter, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"return NO_EXCEPTION;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.newLine();
                        }
                        _builder.newLine();
                    }
                }
                CodeFragment _generateAdditionalImplementation = null;
                if (internalGenerator != null) {
                    _generateAdditionalImplementation = internalGenerator.generateAdditionalImplementation();
                }
                _builder.append(_generateAdditionalImplementation);
                _builder.newLineIfNotEmpty();
            }
        };
        cgn.getChildren().add(this.codeFragmentProvider.create(_client).addHeader("MitaExceptions.h", false).toImplementation(context));
        return cgn;
    }

    protected IComponentConfiguration getConfiguration(CompilationContext context, AbstractSystemResource component, SystemResourceSetup setup) {
        return new MapBasedComponentConfiguration(component, context, setup);
    }

    protected Iterable<EventHandlerDeclaration> getRelevantEventHandler(CompilationContext context, final AbstractSystemResource component) {
        Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration x) {
                EventSource event = x.getEvent();
                AbstractSystemResource _xifexpression = null;
                if (!(event instanceof SystemEventSource)) {
                    return false;
                }
                _xifexpression = ((SystemEventSource)event).getOrigin();
                AbstractSystemResource eventSource = _xifexpression;
                AbstractSystemResource _xifexpression_1 = null;
                if (eventSource instanceof SystemResourceEvent) {
                    EObject _eContainer = eventSource.eContainer();
                    _xifexpression_1 = (AbstractSystemResource)_eContainer;
                } else {
                    AbstractSystemResource _xifexpression_2 = null;
                    if (!(eventSource instanceof AbstractSystemResource)) {
                        return false;
                    }
                    _xifexpression_2 = eventSource;
                    _xifexpression_1 = _xifexpression_2;
                }
                AbstractSystemResource subject = _xifexpression_1;
                AbstractSystemResource _xifexpression_3 = null;
                _xifexpression_3 = component instanceof SystemResourceSetup ? ((SystemResourceSetup)component).getType() : component;
                AbstractSystemResource object = _xifexpression_3;
                String _iD = EcoreUtil.getID((EObject)subject);
                String _iD_1 = EcoreUtil.getID((EObject)object);
                return Objects.equal((Object)_iD, (Object)_iD_1);
            }
        };
        return IterableExtensions.filter(context.getAllEventHandlers(), (Functions.Function1)_function);
    }
}

