/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.transformation;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.program.AbstractLoopStatement;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.ArrayRuntimeCheckStatement;
import org.eclipse.mita.program.DoWhileStatement;
import org.eclipse.mita.program.ForStatement;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.ProgramFactory;
import org.eclipse.mita.program.ValueRange;
import org.eclipse.mita.program.WhileStatement;
import org.eclipse.mita.program.generator.transformation.AbstractTransformationStage;
import org.eclipse.mita.program.generator.transformation.UnravelLiteralArraysStage;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PrepareArrayRuntimeChecksStage
extends AbstractTransformationStage {
    @Inject
    protected ElementSizeInferrer sizeInferrer;
    @Inject
    protected UnravelLiteralArraysStage unravelExpression;

    @Override
    public int getOrder() {
        return 700;
    }

    @Override
    protected void doPostTransformations(Program program) {
        this.unravelExpression.doPostTransformations(program);
        super.doPostTransformations(program);
    }

    protected void _doTransform(final ArrayAccessExpression expression) {
        ProgramBlock parentBlock;
        AbstractLoopStatement parentLoop;
        boolean canInferStatically;
        this.transformChildren((EObject)expression);
        ElementSizeInferenceResult sizeInfRes = this.sizeInferrer.infer((EObject)expression.getOwner());
        Expression arraySelector = expression.getArraySelector();
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject x) {
            }
        };
        Object staticVal = StaticValueInferrer.infer((EObject)arraySelector, (Procedures.Procedure1<? super EObject>)_function);
        boolean bl = canInferStatically = sizeInfRes instanceof ValidElementSizeInferenceResult && staticVal != null;
        if (canInferStatically) {
            return;
        }
        if (staticVal == null) {
            List<Expression> _xifexpression = null;
            if (arraySelector instanceof ValueRange) {
                Expression _lowerBound = ((ValueRange)arraySelector).getLowerBound();
                Expression _upperBound = ((ValueRange)arraySelector).getUpperBound();
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{_lowerBound, _upperBound}));
            } else {
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{arraySelector}));
            }
            List<Expression> exprs = _xifexpression;
            Consumer<Expression> _function_1 = new Consumer<Expression>(){

                @Override
                public void accept(Expression e) {
                    Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                        public void apply(EObject it) {
                        }
                    };
                    Object eInf = StaticValueInferrer.infer((EObject)e, (Procedures.Procedure1<? super EObject>)_function);
                    if (eInf != null) {
                        return;
                    }
                    if (e instanceof PrimitiveValueExpression) {
                        return;
                    }
                    if (e instanceof ElementReferenceExpression) {
                        boolean _not;
                        boolean _isOperationCall = ((ElementReferenceExpression)e).isOperationCall();
                        boolean bl = _not = !_isOperationCall;
                        if (_not) {
                            return;
                        }
                    }
                    PrepareArrayRuntimeChecksStage.this.unravelExpression.doUnravel(e);
                }
            };
            exprs.forEach(_function_1);
        }
        if ((parentLoop = (AbstractLoopStatement)EcoreUtil2.getContainerOfType((EObject)expression, AbstractLoopStatement.class)) != null) {
            boolean checkInLoopBody = false;
            if (parentLoop instanceof ForStatement) {
                boolean isInCondition = IteratorExtensions.toList((Iterator)((ForStatement)parentLoop).getCondition().eAllContents()).contains(expression);
                Functions.Function1<Expression, Boolean> _function_2 = new Functions.Function1<Expression, Boolean>(){

                    public Boolean apply(Expression it) {
                        return IteratorExtensions.toList((Iterator)it.eAllContents()).contains(expression);
                    }
                };
                boolean isInPostLoop = IterableExtensions.exists(((ForStatement)parentLoop).getPostLoopStatements(), (Functions.Function1)_function_2);
                checkInLoopBody = isInCondition || isInPostLoop;
            } else if (parentLoop instanceof WhileStatement) {
                checkInLoopBody = IteratorExtensions.toList((Iterator)((WhileStatement)parentLoop).getCondition().eAllContents()).contains(expression);
            } else if (parentLoop instanceof DoWhileStatement) {
                checkInLoopBody = IteratorExtensions.toList((Iterator)((DoWhileStatement)parentLoop).getCondition().eAllContents()).contains(expression);
            }
            if (checkInLoopBody) {
                Procedures.Procedure1<EObject> _function_3 = new Procedures.Procedure1<EObject>(){

                    public void apply(EObject it) {
                        parentLoop.getBody().getContent().add(0, (Object)PrepareArrayRuntimeChecksStage.this.createRuntimeCheckStatement(expression));
                    }
                };
                this.addPostTransformation((Procedures.Procedure1<? super EObject>)_function_3);
            }
        }
        if ((parentBlock = (ProgramBlock)EcoreUtil2.getContainerOfType((EObject)expression, ProgramBlock.class)) == null) {
            return;
        }
        Procedures.Procedure1<EObject> _function_4 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
                PrepareArrayRuntimeChecksStage.this.insertNextToParentBlock((EObject)expression, true, PrepareArrayRuntimeChecksStage.this.createRuntimeCheckStatement(expression));
            }
        };
        this.addPostTransformation((Procedures.Procedure1<? super EObject>)_function_4);
    }

    protected ArrayRuntimeCheckStatement createRuntimeCheckStatement(ArrayAccessExpression expression) {
        ArrayRuntimeCheckStatement result = ProgramFactory.eINSTANCE.createArrayRuntimeCheckStatement();
        result.setAccess(expression);
        return result;
    }

    @Override
    protected void doTransform(EObject expression) {
        if (expression instanceof ArrayAccessExpression) {
            this._doTransform((ArrayAccessExpression)expression);
            return;
        }
        if (expression != null) {
            this._doTransform(expression);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }
}

