/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.transformation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.ExpressionsFactory;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.program.ExpressionStatement;
import org.eclipse.mita.program.GeneratedFunctionDefinition;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.generator.AbstractFunctionGenerator;
import org.eclipse.mita.program.generator.internal.GeneratorRegistry;
import org.eclipse.mita.program.generator.transformation.AbstractUnravelingStage;
import org.eclipse.xtext.EcoreUtil2;

public class UnravelFunctionCallsStage
extends AbstractUnravelingStage {
    @Inject
    protected GeneratorRegistry generatorRegistry;

    @Override
    protected boolean needsUnraveling(Expression expression) {
        boolean _tripleEquals;
        ProgramBlock _containerOfType = (ProgramBlock)EcoreUtil2.getContainerOfType((EObject)expression, ProgramBlock.class);
        boolean bl = _tripleEquals = _containerOfType == null;
        if (_tripleEquals) {
            return false;
        }
        if (expression instanceof ElementReferenceExpression) {
            EObject ref = ((ElementReferenceExpression)expression).getReference();
            if (ref instanceof Operation) {
                boolean _equals;
                AbstractFunctionGenerator generator;
                if (ref instanceof GeneratedFunctionDefinition && (generator = this.generatorRegistry.getGenerator((GeneratedFunctionDefinition)ref)) != null) {
                    return generator.callShouldBeUnraveled((ElementReferenceExpression)expression);
                }
                ITypeSystemInferrer.InferenceResult inferenceResult = this.typeInferrer.infer(ref);
                Type _type = null;
                if (inferenceResult != null) {
                    _type = inferenceResult.getType();
                }
                String _name = null;
                if (_type != null) {
                    _name = _type.getName();
                }
                if (_equals = Objects.equal((Object)_name, (Object)"void")) {
                    return false;
                }
                EObject _eContainer = ((ElementReferenceExpression)expression).eContainer();
                return !(_eContainer instanceof ExpressionStatement);
            }
            return ref instanceof ComplexType && !(ref instanceof SumType) && !(ref instanceof StructureType) || ref instanceof GeneratedType;
        }
        return false;
    }

    @Override
    protected Expression createInitialization(Expression expression) {
        ElementReferenceExpression elementReferenceExpression = (ElementReferenceExpression)expression;
        ElementReferenceExpression newFunctionCall = ExpressionsFactory.eINSTANCE.createElementReferenceExpression();
        newFunctionCall.setReference(elementReferenceExpression.getReference());
        newFunctionCall.setOperationCall(true);
        newFunctionCall.getArguments().addAll((Collection)elementReferenceExpression.getArguments());
        return newFunctionCall;
    }
}

