/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.scoping;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.program.AbstractStatement;
import org.eclipse.mita.program.ForEachStatement;
import org.eclipse.mita.program.ForStatement;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.IsAssignmentCase;
import org.eclipse.mita.program.IsDeconstructionCase;
import org.eclipse.mita.program.IsDeconstructor;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ElementReferenceScope
extends AbstractScope {
    private EObject context;

    public ElementReferenceScope(IScope outer, EObject context) {
        super(outer, false);
        this.context = context;
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        Iterable _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList();
        this.addFunctionParameter(result, this.context);
        this.addProgramBlocks(result, this.context);
        this.addForLoopIterator(result, this.context);
        this.addForEachLoopIterator(result, this.context);
        this.addGlobalVariables(result, this.context);
        this.addDeconstructorVariables(result, this.context);
        this.addStructureTypes(result, this.context);
        _xblockexpression = Scopes.scopedElementsFor((Iterable)result);
        return _xblockexpression;
    }

    public boolean addSumTypes(ArrayList<EObject> result, EObject context) {
        Functions.Function1<SumType, EList<SumAlternative>> _function = new Functions.Function1<SumType, EList<SumAlternative>>(){

            public EList<SumAlternative> apply(SumType st) {
                return st.getAlternatives();
            }
        };
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)Iterables.filter(((Program)EcoreUtil2.getContainerOfType((EObject)context, Program.class)).getTypes(), SumType.class), (Functions.Function1)_function);
        return Iterables.addAll(result, (Iterable)_flatMap);
    }

    public boolean addDeconstructorVariables(ArrayList<EObject> result, EObject context) {
        boolean _xblockexpression = false;
        IsDeconstructionCase deconstructor = (IsDeconstructionCase)EcoreUtil2.getContainerOfType((EObject)context, IsDeconstructionCase.class);
        if (deconstructor != null) {
            EList<IsDeconstructor> _deconstructors = deconstructor.getDeconstructors();
            Iterables.addAll(result, _deconstructors);
        }
        IsAssignmentCase assignmentDeconstructor = (IsAssignmentCase)EcoreUtil2.getContainerOfType((EObject)context, IsAssignmentCase.class);
        boolean _xifexpression = false;
        if (assignmentDeconstructor != null) {
            VariableDeclaration _assignmentVariable = assignmentDeconstructor.getAssignmentVariable();
            _xifexpression = result.add(_assignmentVariable);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean addStructureTypes(ArrayList<EObject> result, EObject object) {
        Iterable _filter = Iterables.filter(((Program)EcoreUtil2.getContainerOfType((EObject)object, Program.class)).getTypes(), StructureType.class);
        return Iterables.addAll(result, (Iterable)_filter);
    }

    public boolean addFunctionParameter(ArrayList<EObject> result, EObject object) {
        boolean _xblockexpression = false;
        FunctionDefinition container = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)object, FunctionDefinition.class);
        boolean _xifexpression = false;
        if (container != null) {
            EList _parameters = container.getParameters();
            _xifexpression = Iterables.addAll(result, (Iterable)_parameters);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void addForLoopIterator(List<EObject> result, EObject object) {
        ForStatement container = (ForStatement)EcoreUtil2.getContainerOfType((EObject)object, ForStatement.class);
        if (container != null) {
            boolean _tripleNotEquals;
            EList<VariableDeclaration> _loopVariables = container.getLoopVariables();
            Iterables.addAll(result, _loopVariables);
            EObject _eContainer = container.eContainer();
            boolean bl = _tripleNotEquals = _eContainer != null;
            if (_tripleNotEquals) {
                this.addForLoopIterator(result, container.eContainer());
            }
        }
    }

    public void addForEachLoopIterator(List<EObject> result, EObject object) {
        ForEachStatement container = (ForEachStatement)EcoreUtil2.getContainerOfType((EObject)object, ForEachStatement.class);
        if (container != null) {
            boolean _tripleNotEquals;
            VariableDeclaration _iterator = container.getIterator();
            result.add(_iterator);
            EObject _eContainer = container.eContainer();
            boolean bl = _tripleNotEquals = _eContainer != null;
            if (_tripleNotEquals) {
                this.addForEachLoopIterator(result, container.eContainer());
            }
        }
    }

    public boolean addGlobalFunctions(List<EObject> result, EObject object) {
        EList<Operation> _functionDefinitions = ((Program)EcoreUtil2.getContainerOfType((EObject)object, Program.class)).getFunctionDefinitions();
        return Iterables.addAll(result, _functionDefinitions);
    }

    public boolean addGlobalVariables(List<EObject> result, EObject object) {
        EList<VariableDeclaration> _globalVariables = ((Program)EcoreUtil2.getContainerOfType((EObject)object, Program.class)).getGlobalVariables();
        return Iterables.addAll(result, _globalVariables);
    }

    public void addProgramBlocks(List<EObject> result, EObject object) {
        ProgramBlock programBlock = (ProgramBlock)EcoreUtil2.getContainerOfType((EObject)object, ProgramBlock.class);
        if (programBlock != null) {
            int index = programBlock.getContent().indexOf((Object)EcoreUtil2.getContainerOfType((EObject)object, AbstractStatement.class));
            if (index >= 0) {
                Iterable _filter = Iterables.filter((Iterable)programBlock.getContent().subList(0, index), VariableDeclaration.class);
                Iterables.addAll(result, (Iterable)_filter);
            } else {
                Iterable _filter_1 = Iterables.filter(programBlock.getContent(), VariableDeclaration.class);
                Iterables.addAll(result, (Iterable)_filter_1);
            }
            this.addProgramBlocks(result, programBlock.eContainer());
        }
    }
}

