/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Instantiability implements Enumerator
{
    NONE(0, "None", "None"),
    SINGLETON(0, "Singleton", "Singleton"),
    NAMED_SINGLETON(0, "NamedSingleton", "NamedSingleton"),
    MANY(0, "Many", "Many");

    public static final int NONE_VALUE = 0;
    public static final int SINGLETON_VALUE = 0;
    public static final int NAMED_SINGLETON_VALUE = 0;
    public static final int MANY_VALUE = 0;
    private static final Instantiability[] VALUES_ARRAY;
    public static final List<Instantiability> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Instantiability[]{NONE, SINGLETON, NAMED_SINGLETON, MANY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Instantiability get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Instantiability result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Instantiability getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Instantiability result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Instantiability get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    private Instantiability(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

