/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.library.stdlib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.AssignmentOperator;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.program.InterpolatedStringExpression;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.generator.AbstractFunctionGenerator;
import org.eclipse.mita.program.generator.AbstractTypeGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.ProgramDslTraceExtensions;
import org.eclipse.mita.program.generator.StatementGenerator;
import org.eclipse.mita.program.generator.TypeGenerator;
import org.eclipse.mita.program.generator.transformation.EscapeWhitespaceInStringStage;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class StringGenerator
extends AbstractTypeGenerator {
    public static final int DOUBLE_PRECISION = 6;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected ElementSizeInferrer sizeInferrer;
    @Inject
    @Extension
    protected ProgramDslTraceExtensions _programDslTraceExtensions;
    @Inject
    protected TypeGenerator typeGenerator;
    @Inject
    protected ITypeSystemInferrer typeInferrer;
    @Inject
    @Extension
    protected StatementGenerator _statementGenerator;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;

    private static Integer getFixedSize(EObject stmt, ElementSizeInferrer sizeInferrer) {
        ElementSizeInferenceResult inference = sizeInferrer.infer(stmt);
        int _xifexpression = 0;
        if (!(inference instanceof ValidElementSizeInferenceResult)) {
            return -1;
        }
        _xifexpression = ((ValidElementSizeInferenceResult)inference).getElementCount();
        return _xifexpression;
    }

    public boolean checkExpressionSupport(TypeSpecifier type, AssignmentOperator operator, TypeSpecifier otherType) {
        boolean result = false;
        result = result || operator == null;
        boolean _or = false;
        if (result) {
            _or = true;
        } else {
            boolean _and = false;
            if (!Objects.equal((Object)operator, (Object)AssignmentOperator.ASSIGN) || !Objects.equal((Object)type.getType(), (Object)otherType.getType())) {
                _and = false;
            } else {
                boolean _equals;
                Type _type = type.getType();
                String _name = null;
                if (_type != null) {
                    _name = _type.getName();
                }
                _and = _equals = Objects.equal((Object)_name, (Object)"string");
            }
            _or = _and;
        }
        result = _or;
        boolean _or_1 = false;
        if (result) {
            _or_1 = true;
        } else {
            boolean _and_1 = false;
            if (!Objects.equal((Object)operator, (Object)AssignmentOperator.ADD_ASSIGN) || !Objects.equal((Object)type.getType(), (Object)otherType.getType())) {
                _and_1 = false;
            } else {
                boolean _equals_1;
                Type _type_1 = type.getType();
                String _name_1 = null;
                if (_type_1 != null) {
                    _name_1 = _type_1.getName();
                }
                _and_1 = _equals_1 = Objects.equal((Object)_name_1, (Object)"string");
            }
            _or_1 = _and_1;
        }
        result = _or_1;
        return result;
    }

    public CodeFragment generateExpression(TypeSpecifier type, final EObject left, AssignmentOperator operator, final EObject right) {
        CodeFragment _xifexpression = null;
        if (operator == null) {
            CodeFragment _xblockexpression = null;
            CodeFragment interpolationCode = this.generateVariableDeclaration("_str", left, right);
            final CompositeGeneratorNode trimmedInterpolationCode = this.removeAllNewLines((CompositeGeneratorNode)interpolationCode);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"/* WARNING: unstable code path! */ ({ ");
                    IGeneratorNode _noTerminator = StringGenerator.this._generatorUtils.noTerminator((IGeneratorNode)trimmedInterpolationCode);
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)"; _str; })");
                }
            };
            _xifexpression = _xblockexpression = this.codeFragmentProvider.create(_client);
        } else {
            CodeFragment _xifexpression_1 = null;
            if (right == null) {
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    }
                };
                _xifexpression_1 = this.codeFragmentProvider.create(_client);
            } else {
                StringConcatenationClient _client_7;
                StringConcatenationClient _client_5;
                CodeFragment _xblockexpression_1 = null;
                CodeFragment _xifexpression_2 = null;
                if (left instanceof VariableDeclaration) {
                    StringConcatenationClient _client_1 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            String _name = ((VariableDeclaration)left).getName();
                            _builder.append((Object)_name);
                        }
                    };
                    _xifexpression_2 = this.codeFragmentProvider.create(_client_1);
                } else {
                    IGeneratorNode _xifexpression_3 = null;
                    if (left instanceof ReturnStatement) {
                        StringConcatenationClient _client_2 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"*_result");
                            }
                        };
                        _xifexpression_3 = this.codeFragmentProvider.create(_client_2);
                    } else {
                        _xifexpression_3 = this._generatorUtils.noTerminator(this._statementGenerator.code(left));
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                CodeFragment leftCode = _xifexpression_2;
                Pair _xifexpression_4 = null;
                if (right instanceof ElementReferenceExpression) {
                    StringConcatenationClient _client_3 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        }
                    };
                    CodeFragment _create = this.codeFragmentProvider.create(_client_3);
                    StringConcatenationClient _client_4 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            IGeneratorNode _noTerminator = StringGenerator.this._generatorUtils.noTerminator(StringGenerator.this._statementGenerator.code(right));
                            _builder.append((Object)_noTerminator);
                        }
                    };
                    CodeFragment _create_1 = this.codeFragmentProvider.create(_client_4);
                    _xifexpression_4 = Pair.of((Object)_create, (Object)_create_1);
                } else {
                    Pair _xifexpression_5 = null;
                    if (right instanceof PrimitiveValueExpression) {
                        Pair _xblockexpression_2 = null;
                        String _uniqueIdentifier = this._generatorUtils.getUniqueIdentifier(left);
                        final String bufName = String.valueOf(_uniqueIdentifier) + "_buf";
                        _client_5 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"char ");
                                _builder.append((Object)bufName);
                                _builder.append((Object)"[] = ");
                                IGeneratorNode _noTerminator = StringGenerator.this._generatorUtils.noTerminator(StringGenerator.this._statementGenerator.code(right));
                                _builder.append((Object)_noTerminator);
                                _builder.append((Object)";");
                            }
                        };
                        CodeFragment _create_2 = this.codeFragmentProvider.create(_client_5);
                        StringConcatenationClient _client_6 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)bufName);
                            }
                        };
                        CodeFragment _create_3 = this.codeFragmentProvider.create(_client_6);
                        _xifexpression_5 = _xblockexpression_2 = Pair.of((Object)_create_2, (Object)_create_3);
                    } else {
                        Pair _xifexpression_6 = null;
                        if (right instanceof InterpolatedStringExpression) {
                            Pair _xblockexpression_3 = null;
                            String _uniqueIdentifier = this._generatorUtils.getUniqueIdentifier(left);
                            final String bufName = String.valueOf(_uniqueIdentifier) + "_buf";
                            final ElementSizeInferenceResult strLen = this.sizeInferrer.infer(right);
                            CodeFragment _xifexpression_7 = null;
                            if (strLen instanceof ValidElementSizeInferenceResult) {
                                StringConcatenationClient _client_52 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"char ");
                                        _builder.append((Object)bufName);
                                        _builder.append((Object)"[");
                                        int _elementCount = ((ValidElementSizeInferenceResult)strLen).getElementCount();
                                        int _plus = _elementCount + 1;
                                        _builder.append((Object)_plus);
                                        _builder.append((Object)"] = {0};");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append((Object)"snprintf(");
                                        _builder.append((Object)bufName);
                                        _builder.append((Object)", sizeof(");
                                        _builder.append((Object)bufName);
                                        _builder.append((Object)"), \"");
                                        String _pattern = StringGenerator.this.getPattern((InterpolatedStringExpression)right);
                                        _builder.append((Object)_pattern);
                                        _builder.append((Object)"\"");
                                        EList _content = ((InterpolatedStringExpression)right).getContent();
                                        boolean _hasElements = false;
                                        for (Expression x : _content) {
                                            if (!_hasElements) {
                                                _hasElements = true;
                                                _builder.append((Object)", ");
                                            } else {
                                                _builder.appendImmediate((Object)", ", "");
                                            }
                                            IGeneratorNode _code = StringGenerator.this._statementGenerator.code((EObject)x);
                                            _builder.append((Object)_code);
                                        }
                                        _builder.append((Object)");");
                                        _builder.newLineIfNotEmpty();
                                    }
                                };
                                _xifexpression_7 = this.codeFragmentProvider.create(_client_52);
                            } else {
                                StringConcatenationClient _client_6 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"ERROR: Couldn't infer size!");
                                    }
                                };
                                _xifexpression_7 = this.codeFragmentProvider.create(_client_6);
                            }
                            _client_7 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)bufName);
                                }
                            };
                            CodeFragment _create_2 = this.codeFragmentProvider.create(_client_7);
                            _xifexpression_6 = _xblockexpression_3 = Pair.of((Object)_xifexpression_7, (Object)_create_2);
                        }
                        _xifexpression_5 = _xifexpression_6;
                    }
                    _xifexpression_4 = _xifexpression_5;
                }
                final Pair prelude_rightCode = _xifexpression_4;
                CodeFragment _xifexpression_7 = null;
                if (right instanceof ElementReferenceExpression) {
                    CodeFragment _xblockexpression_4 = null;
                    boolean _isOperationCall = ((ElementReferenceExpression)right).isOperationCall();
                    if (_isOperationCall) {
                        _client_5 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"ERROR: Couldn't infer size!");
                            }
                        };
                        this.codeFragmentProvider.create(_client_5);
                    }
                    StringConcatenationClient _client_6 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            CodeFragment _value = (CodeFragment)prelude_rightCode.getValue();
                            _builder.append((Object)_value);
                            _builder.append((Object)"_buf");
                        }
                    };
                    _xifexpression_7 = _xblockexpression_4 = this.codeFragmentProvider.create(_client_6);
                } else {
                    StringConcatenationClient _client_53 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            CodeFragment _value = (CodeFragment)prelude_rightCode.getValue();
                            _builder.append((Object)_value);
                        }
                    };
                    _xifexpression_7 = this.codeFragmentProvider.create(_client_53);
                }
                CodeFragment rightSizeVar = _xifexpression_7;
                CodeFragment _xifexpression_8 = null;
                boolean _equals = Objects.equal((Object)operator, (Object)AssignmentOperator.ASSIGN);
                if (_equals) {
                    StringConcatenationClient _client_6 = new StringConcatenationClient((IGeneratorNode)leftCode, rightSizeVar){
                        private final /* synthetic */ IGeneratorNode val$leftCode;
                        private final /* synthetic */ CodeFragment val$rightSizeVar;
                        {
                            this.val$leftCode = iGeneratorNode;
                            this.val$rightSizeVar = codeFragment;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            CodeFragment _key = (CodeFragment)prelude_rightCode.getKey();
                            _builder.append((Object)_key);
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"memcpy(");
                            _builder.append((Object)this.val$leftCode);
                            _builder.append((Object)", ");
                            CodeFragment _value = (CodeFragment)prelude_rightCode.getValue();
                            _builder.append((Object)_value);
                            _builder.append((Object)", sizeof(");
                            _builder.append((Object)this.val$rightSizeVar);
                            _builder.append((Object)"));");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    _xifexpression_8 = this.codeFragmentProvider.create(_client_6).addHeader("string.h", true);
                } else {
                    CodeFragment _xifexpression_9 = null;
                    boolean _equals_1 = Objects.equal((Object)operator, (Object)AssignmentOperator.ADD_ASSIGN);
                    if (_equals_1) {
                        _client_7 = new StringConcatenationClient((IGeneratorNode)leftCode){
                            private final /* synthetic */ IGeneratorNode val$leftCode;
                            {
                                this.val$leftCode = iGeneratorNode;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                CodeFragment _key = (CodeFragment)prelude_rightCode.getKey();
                                _builder.append((Object)_key);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"strcat(");
                                _builder.append((Object)this.val$leftCode);
                                _builder.append((Object)", ");
                                CodeFragment _value = (CodeFragment)prelude_rightCode.getValue();
                                _builder.append((Object)_value);
                                _builder.append((Object)");");
                                _builder.newLineIfNotEmpty();
                            }
                        };
                        _xifexpression_9 = this.codeFragmentProvider.create(_client_7).addHeader("string.h", true);
                    } else {
                        StringConcatenationClient _client_8 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"ERROR: unimplemented string operator");
                            }
                        };
                        _xifexpression_9 = this.codeFragmentProvider.create(_client_8);
                    }
                    _xifexpression_8 = _xifexpression_9;
                }
                _xifexpression_1 = _xblockexpression_1 = _xifexpression_8;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public CodeFragment generateVariableDeclaration(TypeSpecifier type, VariableDeclaration stmt) {
        return this.codeFragmentProvider.create(this._programDslTraceExtensions.append(this._programDslTraceExtensions.trace((EObject)stmt), (Object)this.generateVariableDeclaration(stmt.getName(), (EObject)stmt, (EObject)stmt.getInitialization())));
    }

    protected CodeFragment generateVariableDeclaration(final String name, EObject variable, EObject initialization) {
        CodeFragment _xblockexpression = null;
        ElementSizeInferenceResult _xifexpression = null;
        EObject _eContainer = null;
        if (initialization != null) {
            _eContainer = initialization.eContainer();
        }
        if (_eContainer instanceof VariableDeclaration) {
            _xifexpression = this.sizeInferrer.infer(initialization.eContainer());
        } else {
            EObject _elvis = null;
            _elvis = initialization != null ? initialization : variable;
            _xifexpression = this.sizeInferrer.infer(_elvis);
        }
        ElementSizeInferenceResult sizeInferenceResult = _xifexpression;
        int _xifexpression_1 = 0;
        _xifexpression_1 = sizeInferenceResult instanceof ValidElementSizeInferenceResult ? ((ValidElementSizeInferenceResult)sizeInferenceResult).getElementCount() : -1;
        int size = _xifexpression_1;
        int _xifexpression_2 = 0;
        _xifexpression_2 = size >= 0 ? size + 1 : size;
        final int byteCount = _xifexpression_2;
        CodeFragment _xifexpression_3 = null;
        if (initialization instanceof InterpolatedStringExpression) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"char ");
                    _builder.append((Object)name);
                    _builder.append((Object)"_buf[");
                    _builder.append((Object)byteCount);
                    _builder.append((Object)"] = {0};");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"char *");
                    _builder.append((Object)name);
                    _builder.append((Object)" = ");
                    _builder.append((Object)name);
                    _builder.append((Object)"_buf;");
                    _builder.newLineIfNotEmpty();
                }
            };
            _xifexpression_3 = this.codeFragmentProvider.create(_client).addHeader("stdio.h", true).addHeader("inttypes.h", true);
        } else {
            CodeFragment _xifexpression_4 = null;
            boolean _isOperationCall = this.getIsOperationCall(initialization);
            if (_isOperationCall) {
                CodeFragment _xblockexpression_1 = null;
                ElementReferenceExpression elementReference = (ElementReferenceExpression)initialization;
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"char ");
                        _builder.append((Object)name);
                        _builder.append((Object)"_buf[");
                        _builder.append((Object)byteCount);
                        _builder.append((Object)"] = {0};");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"char *");
                        _builder.append((Object)name);
                        _builder.append((Object)" = ");
                        _builder.append((Object)name);
                        _builder.append((Object)"_buf;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                _xifexpression_4 = _xblockexpression_1 = this.codeFragmentProvider.create(_client_1).addHeader("string.h", true).addHeader("inttypes.h", true);
            } else {
                CodeFragment _xifexpression_5 = null;
                if (initialization != null && !(initialization instanceof NewInstanceExpression)) {
                    StringConcatenationClient _client_1 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"char ");
                            _builder.append((Object)name);
                            _builder.append((Object)"_buf[");
                            _builder.append((Object)byteCount);
                            _builder.append((Object)"] = {0};");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"char *");
                            _builder.append((Object)name);
                            _builder.append((Object)" = ");
                            _builder.append((Object)name);
                            _builder.append((Object)"_buf;");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    _xifexpression_5 = this.codeFragmentProvider.create(_client_1).addHeader("string.h", true).addHeader("inttypes.h", true);
                } else {
                    StringConcatenationClient _client_2 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"char ");
                            _builder.append((Object)name);
                            _builder.append((Object)"_buf[");
                            _builder.append((Object)byteCount);
                            _builder.append((Object)"] = {0};");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"char *");
                            _builder.append((Object)name);
                            _builder.append((Object)" = ");
                            _builder.append((Object)name);
                            _builder.append((Object)"_buf;");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    _xifexpression_5 = this.codeFragmentProvider.create(_client_2).addHeader("string.h", true);
                }
                _xifexpression_4 = _xifexpression_5;
            }
            _xifexpression_3 = _xifexpression_4;
        }
        _xblockexpression = _xifexpression_3;
        return _xblockexpression;
    }

    protected boolean getIsOperationCall(EObject object) {
        if (object instanceof ElementReferenceExpression) {
            return ((ElementReferenceExpression)object).isOperationCall() && ((ElementReferenceExpression)object).getReference() instanceof Operation;
        }
        return false;
    }

    public String getPattern(InterpolatedStringExpression expression) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.replaceAll("%", "%%");
            }
        };
        List tokenizedCode = ListExtensions.map(StringGenerator.getOriginalTexts(expression), (Functions.Function1)_function);
        String result = "";
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)tokenizedCode, Object.class)).length) {
            Expression sub;
            boolean _lessThan;
            String txt = (String)tokenizedCode.get(i);
            String _result = result;
            result = String.valueOf(_result) + txt;
            int _length = ((Object[])Conversions.unwrapArray((Object)expression.getContent(), Object.class)).length;
            boolean bl = _lessThan = i < _length;
            if (_lessThan && (sub = (Expression)expression.getContent().get(i)) != null) {
                ITypeSystemInferrer.InferenceResult _infer = this.typeInferrer.infer((EObject)sub);
                Type _type = null;
                if (_infer != null) {
                    _type = _infer.getType();
                }
                Type type = _type;
                String _switchResult = null;
                String _name = null;
                if (type != null) {
                    _name = type.getName();
                }
                boolean _matched = false;
                if (Objects.equal((Object)_name, (Object)"uint32")) {
                    _matched = true;
                    _switchResult = "%\" PRIu32 \"";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"uint16")) {
                    _matched = true;
                    _switchResult = "%\" PRIu16 \"";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"uint8")) {
                    _matched = true;
                    _switchResult = "%\" PRIu8 \"";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"int32")) {
                    _matched = true;
                    _switchResult = "%\" PRId32 \"";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"int16")) {
                    _matched = true;
                    _switchResult = "%\" PRId16 \"";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"int8")) {
                    _matched = true;
                    _switchResult = "%\" PRId8 \"";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"float")) {
                    _matched = true;
                    _switchResult = "%." + Integer.valueOf(6) + "g";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"double")) {
                    _matched = true;
                    _switchResult = "%." + Integer.valueOf(6) + "g";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"bool")) {
                    _matched = true;
                    _switchResult = "%d";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"string")) {
                    _matched = true;
                    _switchResult = "%s";
                }
                if (!_matched) {
                    _switchResult = "UNKNOWN";
                }
                String typePattern = _switchResult;
                String _result_1 = result;
                result = String.valueOf(_result_1) + typePattern;
            }
            ++i;
        }
        return result;
    }

    public CodeFragment generateTypeSpecifier(TypeSpecifier type, EObject context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"char*");
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateNewInstance(TypeSpecifier type, NewInstanceExpression expr) {
        return CodeFragment.EMPTY;
    }

    public static List<String> getOriginalTexts(InterpolatedStringExpression expr) {
        String originalSourceCode = ModelUtils.getOriginalSourceCode((EObject)expr);
        int _length = originalSourceCode.length();
        int _minus = _length - 1;
        String codeWithoutBackticks = originalSourceCode.substring(1, _minus);
        LinkedList<String> results = new LinkedList<String>();
        int i = 0;
        while (i < codeWithoutBackticks.length()) {
            int startOfNextBlock = codeWithoutBackticks.indexOf("${", i);
            if (startOfNextBlock == -1) {
                results.add(codeWithoutBackticks.substring(i, codeWithoutBackticks.length()));
                i = codeWithoutBackticks.length();
            } else {
                int endOfNextBlock = codeWithoutBackticks.indexOf("}", startOfNextBlock);
                results.add(codeWithoutBackticks.substring(i, startOfNextBlock));
                i = endOfNextBlock;
            }
            ++i;
        }
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String x) {
                return EscapeWhitespaceInStringStage.replaceSpecialCharacters((String)x);
            }
        };
        return ListExtensions.map(results, (Functions.Function1)_function);
    }

    protected CompositeGeneratorNode removeAllNewLines(CompositeGeneratorNode node) {
        CollectionExtensions.removeAll((Collection)node.getChildren(), (Iterable)Iterables.filter((Iterable)node.getChildren(), NewLineNode.class));
        Consumer<CompositeGeneratorNode> _function = new Consumer<CompositeGeneratorNode>(){

            @Override
            public void accept(CompositeGeneratorNode it) {
                StringGenerator.this.removeAllNewLines(it);
            }
        };
        Iterables.filter((Iterable)node.getChildren(), CompositeGeneratorNode.class).forEach(_function);
        return node;
    }

    public static class LengthGenerator
    extends AbstractFunctionGenerator {
        @Inject
        protected CodeFragmentProvider codeFragmentProvider;
        @Inject
        protected ElementSizeInferrer sizeInferrer;

        public CodeFragment generate(ElementReferenceExpression ref, final IGeneratorNode resultVariableName) {
            EObject _reference = ref.getReference();
            Expression variable = ModelUtils.getArgumentValue((Operation)((Operation)_reference), (ArgumentExpression)ref, (String)"self");
            VariableDeclaration _xifexpression = null;
            if (variable instanceof ElementReferenceExpression) {
                VariableDeclaration _xblockexpression = null;
                EObject varref = ((ElementReferenceExpression)variable).getReference();
                VariableDeclaration _xifexpression_1 = null;
                if (varref instanceof VariableDeclaration) {
                    _xifexpression_1 = (VariableDeclaration)varref;
                }
                _xifexpression = _xblockexpression = _xifexpression_1;
            }
            final VariableDeclaration varref = _xifexpression;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    if (resultVariableName != null) {
                        _builder.append((Object)resultVariableName);
                        _builder.append((Object)" = ");
                    }
                    Integer _fixedSize = null;
                    if (varref != null) {
                        _fixedSize = StringGenerator.getFixedSize((EObject)varref, LengthGenerator.this.sizeInferrer);
                    }
                    _builder.append(_fixedSize);
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
    }
}

