/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public final class CompositeUnitResolver
implements UnitResolver {
    private List<UnitResolver> fResolvers;

    public CompositeUnitResolver(UnitResolver ... resolvers) {
        this.fResolvers = new ArrayList<UnitResolver>(resolvers.length);
        UnitResolver[] unitResolverArray = resolvers;
        int n = resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            UnitResolver unitResolver = unitResolverArray[n2];
            if (unitResolver == null) {
                throw new IllegalArgumentException();
            }
            this.fResolvers.add(unitResolver);
            ++n2;
        }
    }

    public final UnitProxy resolveUnit(String qualifiedName) {
        for (UnitResolver nextResolver : this.fResolvers) {
            UnitProxy unit = nextResolver.resolveUnit(qualifiedName);
            if (unit == null) continue;
            return unit;
        }
        return null;
    }
}

