/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.util;

import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertUtil {
    public static void assertTrue(String msg, boolean value) {
        if (!value) {
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertResource(EObject obj1, EObject obj2) {
        if (obj1.eResource() == null && obj2.eResource() == null) {
            return;
        }
        if (obj1.eResource() != obj2.eResource()) {
            throw new AssertionError((Object)("The resources are different: " + obj1.getClass().getName() + "/" + obj2.getClass().getName()));
        }
    }

    public static void assertContainer(EObject parent, EObject child) {
        if (parent != child.eContainer()) {
            throw new AssertionError((Object)("The child's container is incorrect! parent/child: " + parent.getClass().getName() + "/" + child.getClass().getName()));
        }
    }

    public static void assertIsNull(Object obj) {
        if (obj != null) {
            throw new AssertionError((Object)("Passed object: " + obj.getClass().getName() + " is not null while this was expected"));
        }
    }

    public static void assertInstanceOf(Object obj, Class<?> expClass) {
        if (obj == null) {
            return;
        }
        if (!expClass.isAssignableFrom(obj.getClass())) {
            throw new AssertionError((Object)("Expected class: " + expClass.getName() + " but object has class: " + obj.getClass().getName()));
        }
    }

    public static void assertInstanceOfNotNull(Object obj, Class<?> expClass) {
        if (obj == null) {
            throw new AssertionError((Object)("Checking instanceof but object is null, expecting class: " + expClass.getName()));
        }
        if (!expClass.isAssignableFrom(obj.getClass())) {
            throw new AssertionError((Object)("Expected class: " + expClass.getName() + " but object has class: " + obj.getClass().getName()));
        }
    }

    public static void assertSameObject(Object obj1, Object obj2) {
        if (obj1 != obj2) {
            throw new AssertionError((Object)"Objects are not the same");
        }
    }

    public static void assertNotSameObject(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            throw new AssertionError((Object)"Objects are the same");
        }
    }
}

