/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEModelElement;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pamodel.PamodelFactory;
import org.eclipse.emf.teneo.extension.ExtensionPoint;

public class BasicPamodelBuilder
implements ExtensionPoint {
    private PAnnotatedModel target = null;

    public BasicPamodelBuilder() {
        this.setPAnnotatedModel(this.createPAnnotatedModel());
    }

    public PAnnotatedModel createPAnnotatedModel() {
        return PamodelFactory.eINSTANCE.createPAnnotatedModel();
    }

    public BasicPamodelBuilder(PAnnotatedModel target) {
        this.setPAnnotatedModel(target);
    }

    public void setPAnnotatedModel(PAnnotatedModel target) {
        this.target = target;
    }

    public PAnnotatedModel getPAnnotatedModel() {
        return this.target;
    }

    protected PAnnotatedEModelElement create(EModelElement eModelElement) {
        PAnnotatedEModelElement paElement = this.target.getPAnnotated(eModelElement);
        if (paElement == null) {
            paElement = this.doCreate(eModelElement);
        }
        return paElement;
    }

    protected PAnnotatedEModelElement doCreate(EModelElement eModelElement) throws AssertionError {
        PAnnotatedEAttribute paElement;
        EClass eModelElementEClass = eModelElement.eClass();
        switch (eModelElementEClass.getClassifierID()) {
            case 0: {
                paElement = PamodelFactory.eINSTANCE.createPAnnotatedEAttribute();
                break;
            }
            case 14: {
                paElement = PamodelFactory.eINSTANCE.createPAnnotatedEReference();
                break;
            }
            case 2: {
                paElement = PamodelFactory.eINSTANCE.createPAnnotatedEClass();
                break;
            }
            case 12: {
                paElement = PamodelFactory.eINSTANCE.createPAnnotatedEPackage();
                break;
            }
            case 4: 
            case 5: {
                paElement = PamodelFactory.eINSTANCE.createPAnnotatedEDataType();
                break;
            }
            default: {
                throw new AssertionError((Object)("Trying to build PAnnotatedEModelElement for a " + eModelElementEClass));
            }
        }
        paElement.setModelElement((ENamedElement)eModelElement);
        return paElement;
    }

    protected PAnnotatedEPackage pElement(EPackage ePackage) {
        PAnnotatedEPackage pPackage = (PAnnotatedEPackage)this.create((EModelElement)ePackage);
        if (pPackage.eContainer() == null) {
            this.target.getPaEPackages().add((Object)pPackage);
        }
        return pPackage;
    }

    protected PAnnotatedEClass pElement(EClass eClass) {
        PAnnotatedEClass pClass = (PAnnotatedEClass)this.create((EModelElement)eClass);
        this.pElement(eClass.getEPackage()).getPaEClasses().add((Object)pClass);
        return pClass;
    }

    protected PAnnotatedEModelElement pElement(EStructuralFeature eFeature) {
        PAnnotatedEStructuralFeature pFeature = (PAnnotatedEStructuralFeature)this.create((EModelElement)eFeature);
        this.pElement(eFeature.getEContainingClass()).getPaEStructuralFeatures().add((Object)pFeature);
        return pFeature;
    }

    protected PAnnotatedEDataType pElement(EDataType eDataType) {
        PAnnotatedEDataType pDataType = (PAnnotatedEDataType)this.create((EModelElement)eDataType);
        this.pElement(eDataType.getEPackage()).getPaEDataTypes().add((Object)pDataType);
        return pDataType;
    }

    protected PAnnotatedEModelElement pElement(EModelElement eElement) throws AssertionError {
        PAnnotatedEModelElement pElement = null;
        switch (eElement.eClass().getClassifierID()) {
            case 0: 
            case 14: {
                pElement = this.pElement((EStructuralFeature)eElement);
                break;
            }
            case 2: {
                pElement = this.pElement((EClass)eElement);
                break;
            }
            case 12: {
                pElement = this.pElement((EPackage)eElement);
                break;
            }
            case 4: {
                pElement = this.pElement((EDataType)eElement);
                break;
            }
            default: {
                throw new AssertionError((Object)("Trying to build PAnnotatedEModelElement for a " + eElement.eClass()));
            }
        }
        return pElement;
    }

    public void add(EPackage ePackage) {
        this.pElement(ePackage);
    }

    public void add(EClass eClass) {
        this.pElement(eClass);
    }

    public void add(EStructuralFeature eFeature) {
        this.pElement(eFeature);
    }

    public void addRecurse(EPackage ePackage) {
        PAnnotatedEPackage paPackage = this.pElement(ePackage);
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (eClassifier instanceof EClass) {
                this.addRecurse(paPackage, (EClass)eClassifier);
                continue;
            }
            if (!(eClassifier instanceof EDataType)) continue;
            this.pElement((EDataType)eClassifier);
        }
    }

    protected void addRecurse(PAnnotatedEPackage paPackage, EClass eClass) {
        PAnnotatedEClass paClass = (PAnnotatedEClass)this.create((EModelElement)eClass);
        if (paClass.eContainer() == null) {
            paPackage.getPaEClasses().add((Object)paClass);
        }
        for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
            this.add(paClass, eStructuralFeature);
        }
    }

    protected void add(PAnnotatedEClass paClass, EStructuralFeature eFeature) {
        PAnnotatedEStructuralFeature paFeature = (PAnnotatedEStructuralFeature)this.create((EModelElement)eFeature);
        if (paFeature.eContainer() == null) {
            paClass.getPaEStructuralFeatures().add((Object)paFeature);
        }
    }
}

