/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.annotations.parser.AnnotationParserException;
import org.eclipse.emf.teneo.annotations.parser.ComplexNode;
import org.eclipse.emf.teneo.annotations.parser.EClassResolver;
import org.eclipse.emf.teneo.annotations.parser.NamedParserNode;
import org.eclipse.emf.teneo.annotations.parser.ReferenceValueNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayValueNode
extends NamedParserNode {
    private static final Log log = LogFactory.getLog(ArrayValueNode.class);
    private List<Object> children = new ArrayList<Object>();

    ArrayValueNode() {
    }

    List<Object> getChildren() {
        return this.children;
    }

    @Override
    List<Object> convert(EClassResolver ecr) {
        log.debug((Object)"Converting array value node");
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object ob : this.children) {
            if (ob instanceof String) {
                result.add(ob);
                continue;
            }
            if (ob instanceof ComplexNode) {
                ComplexNode cn = (ComplexNode)ob;
                result.add(cn.convert(ecr));
                continue;
            }
            if (ob instanceof ReferenceValueNode) {
                ReferenceValueNode rvn = (ReferenceValueNode)ob;
                result.add(rvn.convert(ecr));
                continue;
            }
            if (ob instanceof ArrayValueNode) {
                ArrayValueNode avn = (ArrayValueNode)ob;
                result.addAll((Collection<Object>)avn.convert(ecr));
                continue;
            }
            throw new AnnotationParserException("Type " + ob.getClass().getName() + " not supported here");
        }
        return result;
    }
}

