/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.ConditionalRedoCommand;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.impl.NonEMFTransaction;
import org.eclipse.emf.workspace.internal.EMFWorkspacePlugin;
import org.eclipse.emf.workspace.internal.Tracing;
import org.eclipse.emf.workspace.internal.l10n.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFOperationCommand
implements ConditionalRedoCommand {
    private final TransactionalEditingDomain domain;
    private IUndoableOperation operation;
    private Reference<IAdaptable> adaptable;

    public EMFOperationCommand(TransactionalEditingDomain domain, IUndoableOperation operation) {
        this(domain, operation, null);
    }

    public EMFOperationCommand(TransactionalEditingDomain domain, IUndoableOperation operation, IAdaptable adaptable) {
        if (domain == null) {
            throw new IllegalArgumentException("null domain");
        }
        if (operation == null) {
            throw new IllegalArgumentException("null operation");
        }
        this.domain = domain;
        this.operation = operation;
        if (adaptable != null) {
            this.adaptable = new WeakReference<IAdaptable>(adaptable);
        }
    }

    public boolean canExecute() {
        return this.operation.canExecute();
    }

    public void execute() {
        block16: {
            InternalTransaction tx = this.getTransaction();
            if (tx == null) {
                throw new IllegalStateException("attempt to execute without write transaction");
            }
            Transaction childTransaction = null;
            try {
                try {
                    if (!(this.operation instanceof AbstractEMFOperation)) {
                        try {
                            childTransaction = this.createNonEMFTransaction(this.operation, this.getAdaptable(), tx.getOptions());
                        }
                        catch (InterruptedException e) {
                            Tracing.catching(EMFOperationCommand.class, "execute", e);
                            ExecutionException exc = new ExecutionException(Messages.executeInterrupted, (Throwable)e);
                            Tracing.throwing(EMFOperationCommand.class, "execute", exc);
                            throw exc;
                        }
                    }
                    this.operation.execute((IProgressMonitor)new NullProgressMonitor(), this.getAdaptable());
                }
                catch (ExecutionException e) {
                    EMFWorkspacePlugin.INSTANCE.log(new Status(4, EMFWorkspacePlugin.getPluginId(), 32, NLS.bind((String)Messages.rollbackFailed, (Object)this.operation.getLabel()), (Throwable)e));
                    if (childTransaction == null || !childTransaction.isActive()) break block16;
                    try {
                        childTransaction.commit();
                    }
                    catch (RollbackException e2) {
                        Tracing.catching(EMFOperationCommand.class, "execute", e2);
                        EMFWorkspacePlugin.INSTANCE.log(e2.getStatus());
                    }
                }
            }
            finally {
                if (childTransaction != null && childTransaction.isActive()) {
                    try {
                        childTransaction.commit();
                    }
                    catch (RollbackException e) {
                        Tracing.catching(EMFOperationCommand.class, "execute", e);
                        EMFWorkspacePlugin.INSTANCE.log(e.getStatus());
                    }
                }
            }
        }
    }

    private Transaction createNonEMFTransaction(IUndoableOperation operation, IAdaptable info, Map<?, ?> options) throws InterruptedException {
        NonEMFTransaction result = new NonEMFTransaction(this.domain, operation, info, options);
        result.start();
        return result;
    }

    public boolean canUndo() {
        return this.operation.canUndo();
    }

    public void undo() {
        InternalTransaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("attempt to undo without write transaction");
        }
        try {
            this.operation.undo((IProgressMonitor)new NullProgressMonitor(), this.getAdaptable());
        }
        catch (ExecutionException e) {
            EMFWorkspacePlugin.INSTANCE.log(new Status(4, EMFWorkspacePlugin.getPluginId(), 32, NLS.bind((String)Messages.rollbackFailed, (Object)this.operation.getLabel()), (Throwable)e));
        }
    }

    public boolean canRedo() {
        return this.operation.canRedo();
    }

    public void redo() {
        InternalTransaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("attempt to redo without write transaction");
        }
        try {
            this.operation.redo((IProgressMonitor)new NullProgressMonitor(), this.getAdaptable());
        }
        catch (ExecutionException e) {
            EMFWorkspacePlugin.INSTANCE.log(new Status(4, EMFWorkspacePlugin.getPluginId(), 32, NLS.bind((String)Messages.rollbackFailed, (Object)this.operation.getLabel()), (Throwable)e));
        }
    }

    public Collection<?> getResult() {
        return Collections.EMPTY_LIST;
    }

    public Collection<?> getAffectedObjects() {
        Object[] affected;
        Collection result = null;
        if (this.operation instanceof IAdvancedUndoableOperation && (affected = ((IAdvancedUndoableOperation)this.operation).getAffectedObjects()) != null) {
            result = Arrays.asList(affected);
        }
        return result;
    }

    public String getLabel() {
        return this.operation.getLabel();
    }

    public String getDescription() {
        return this.operation.getLabel();
    }

    public void dispose() {
        if (this.operation != null) {
            if (this.operation instanceof AbstractEMFOperation) {
                ((AbstractEMFOperation)this.operation).disposeChange(true);
            }
            this.operation.dispose();
            this.operation = null;
        }
        if (this.adaptable != null) {
            this.adaptable.clear();
            this.adaptable = null;
        }
    }

    public Command chain(Command command) {
        return new ConditionalRedoCommand.Compound().chain((Command)this).chain(command);
    }

    private IAdaptable getAdaptable() {
        IAdaptable result = null;
        if (this.adaptable != null) {
            result = this.adaptable.get();
        }
        return result;
    }

    private InternalTransaction getTransaction() {
        InternalTransaction result = ((InternalTransactionalEditingDomain)this.domain).getActiveTransaction();
        if (result != null && (result.isReadOnly() || result.getOwner() != Thread.currentThread())) {
            result = null;
        }
        return result;
    }

    IUndoableOperation getOperation() {
        return this.operation;
    }
}

