/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.eef.EEFTextStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFTextController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.eef.ide.ui.internal.preferences.EEFPreferences;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFColor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class EEFTextLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int TEXT_AREA_WIDTH_HINT = 300;
    private EEFTextDescription description;
    private StyledText text;
    private IEEFTextController controller;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private EEFWidgetFactory widgetFactory;
    private Color defaultBackgroundColor;
    private ModifyListener modifyListener;
    private AtomicBoolean updateInProgress = new AtomicBoolean(false);
    private AtomicBoolean lockedByOtherInProgress = new AtomicBoolean(false);
    private String referenceValue = "";
    private boolean isDirty;

    public EEFTextLifecycleManager(EEFTextDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        this.defaultBackgroundColor = parent.getBackground();
        int lineCount = this.description.getLineCount();
        if (lineCount > 1) {
            this.text = this.widgetFactory.createStyledText(parent, 834);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.heightHint = lineCount * this.text.getLineHeight();
            gridData.widthHint = 300;
            gridData.horizontalIndent = 5;
            this.text.setLayoutData((Object)gridData);
        } else {
            this.text = this.widgetFactory.createStyledText(parent, 4);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalIndent = 5;
            this.text.setLayoutData((Object)gridData);
        }
        this.text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createTextController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    @Override
    protected int getLabelVerticalAlignment() {
        if (this.description.getLineCount() > 1) {
            return 2;
        }
        return 4;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!EEFTextLifecycleManager.this.container.isRenderingInProgress() && !EEFTextLifecycleManager.this.updateInProgress.get()) {
                    EEFTextLifecycleManager.this.isDirty = true;
                    Object self = EEFTextLifecycleManager.this.variableManager.getVariables().get("self");
                    String userInput = ((StyledText)e.widget).getText();
                    Memento memento = new Memento(EEFTextLifecycleManager.this.description, self, EEFTextLifecycleManager.this.referenceValue, userInput);
                    memento.store(e.widget);
                }
            }
        };
        this.text.addModifyListener(this.modifyListener);
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (!EEFTextLifecycleManager.this.lockedByOtherInProgress.get() && !EEFTextLifecycleManager.this.container.isRenderingInProgress() && EEFTextLifecycleManager.this.isDirty) {
                    EEFTextLifecycleManager.this.updateValue(false);
                }
            }

            public void focusGained(FocusEvent e) {
            }
        };
        this.text.addFocusListener(this.focusListener);
        if (this.description.getLineCount() <= 1) {
            this.keyListener = new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\r' || e.character == '\n') {
                        EEFTextLifecycleManager.this.updateValue(false);
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            };
            this.text.addKeyListener(this.keyListener);
        }
        this.controller.onNewValue((IConsumer)new IConsumer<Object>(){

            public void apply(Object value) {
                if (!EEFTextLifecycleManager.this.text.isDisposed()) {
                    String newDisplayText = EEFTextLifecycleManager.this.computeNewText(value);
                    if (EEFTextLifecycleManager.this.text.getText() == null || !EEFTextLifecycleManager.this.text.getText().equals(newDisplayText)) {
                        EEFTextLifecycleManager.this.text.setText(newDisplayText);
                        EEFTextLifecycleManager.this.referenceValue = EEFTextLifecycleManager.this.text.getText();
                    }
                    EEFTextLifecycleManager.this.setStyle();
                    if (!EEFTextLifecycleManager.this.text.isEnabled()) {
                        EEFTextLifecycleManager.this.text.setEnabled(true);
                    }
                }
            }
        });
    }

    private String computeNewText(Object value) {
        Memento m;
        String[] newDisplayText = new String[]{""};
        if (value != null) {
            newDisplayText[0] = Util.firstNonNull((String[])new String[]{value.toString(), newDisplayText[0]});
        }
        if ((m = Memento.of((Widget)this.text)) != null) {
            boolean userHasUncommitedInput;
            boolean resettingToPreviousReferenceValue = this.equals(newDisplayText[0], m.referenceValue);
            boolean bl = userHasUncommitedInput = !this.equals(newDisplayText[0], m.userInput);
            if (m.appliesTo(this) && userHasUncommitedInput) {
                if (resettingToPreviousReferenceValue) {
                    newDisplayText[0] = m.userInput;
                } else if (!this.equals(m.userInput, newDisplayText[0])) {
                    newDisplayText[0] = this.resolveEditionConflict(this.text.getShell(), m.referenceValue, m.userInput, newDisplayText[0]);
                }
            }
            Memento.remove((Widget)this.text);
        }
        return newDisplayText[0];
    }

    protected String resolveEditionConflict(Shell shell, String originalValue, String localEditedVersion, String newValueFromModel) {
        String result;
        switch (EEFPreferences.getTextConflictResolutionMode()) {
            case USE_LOCAL_VERSION: {
                result = localEditedVersion;
                break;
            }
            case USE_MODEL_VERSION: {
                result = newValueFromModel;
                break;
            }
            case ASK_USER: {
                result = this.askUserToResolveConflict(shell, originalValue, localEditedVersion, newValueFromModel);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    protected String askUserToResolveConflict(final Shell shell, String originalValue, final String localEditedVersion, final String newValueFromModel) {
        final String[] result = new String[]{localEditedVersion};
        final String[] choices = new String[]{Messages.EEFTextLifecycleManager_conflictDialog_choiceNewModelValue, Messages.EEFTextLifecycleManager_conflictDialog_choiceLocalEditedValue};
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Image img = shell.getDisplay().getSystemImage(4);
                MessageDialog dialog = new MessageDialog(shell, Messages.EEFTextLifecycleManager_conflictDialog_title, img, MessageFormat.format(Messages.EEFTextLifecycleManager_conflictDialog_message, newValueFromModel, localEditedVersion), 3, 0, choices);
                switch (dialog.open()) {
                    case 0: {
                        result[0] = newValueFromModel;
                        break;
                    }
                    case 1: {
                        result[0] = localEditedVersion;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        return result[0];
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private void updateValue(boolean force) {
        boolean shouldUpdateWhileRendering;
        boolean bl = shouldUpdateWhileRendering = !this.container.isRenderingInProgress() || force;
        if (!this.text.isDisposed() && this.isDirty && shouldUpdateWhileRendering && this.updateInProgress.compareAndSet(false, true)) {
            try {
                IStatus result = this.controller.updateValue(this.text.getText());
                if (result != null && result.getSeverity() == 4) {
                    EEFIdeUiPlugin.INSTANCE.log(result);
                    this.text.setText(this.referenceValue);
                } else {
                    this.referenceValue = this.text.getText();
                    this.refresh();
                }
                this.isDirty = false;
                Memento.remove((Widget)this.text);
                this.setStyle();
            }
            finally {
                this.updateInProgress.set(false);
            }
        }
    }

    private void setStyle() {
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle widgetStyle = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (widgetStyle instanceof EEFTextStyle) {
            EEFTextStyle textStyle = (EEFTextStyle)widgetStyle;
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.text);
            styleHelper.applyTextStyle(textStyle.getFontNameExpression(), textStyle.getFontSizeExpression(), textStyle.getFontStyleExpression(), this.text.getFont(), textStyle.getBackgroundColorExpression(), textStyle.getForegroundColorExpression(), callback);
        }
    }

    @Override
    protected Control getValidationControl() {
        return this.text;
    }

    @Override
    public void aboutToBeHidden() {
        if (this.isDirty) {
            this.updateValue(true);
        }
        super.aboutToBeHidden();
        if (!this.text.isDisposed()) {
            this.text.removeFocusListener(this.focusListener);
        }
        this.controller.removeNewValueConsumer();
        if (!this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
        }
        if (!this.text.isDisposed() && this.description.getLineCount() <= 1) {
            this.text.removeKeyListener(this.keyListener);
        }
    }

    @Override
    protected void lockedByOther() {
        this.lockedByOtherInProgress.set(true);
        try {
            super.lockedByOther();
        }
        finally {
            this.lockedByOtherInProgress.set(false);
        }
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.text.isDisposed()) {
            this.text.setEnabled(isEnabled);
            this.text.setEditable(isEnabled);
            this.text.setBackground(this.getBackgroundColor(isEnabled));
        }
    }

    private Color getBackgroundColor(boolean isEnabled) {
        Color color = this.defaultBackgroundColor;
        if (!isEnabled) {
            color = this.widgetFactory.getColors().getInactiveBackground();
        } else {
            EEFTextStyle style;
            String backgroundColorCode;
            EEFWidgetStyle widgetStyle = new EEFStyleHelper(this.interpreter, this.variableManager).getWidgetStyle((EEFWidgetDescription)this.description);
            if (widgetStyle instanceof EEFTextStyle && !Util.isBlank((String)(backgroundColorCode = (style = (EEFTextStyle)widgetStyle).getBackgroundColorExpression()))) {
                EEFColor backgroundColor = new EEFColor(backgroundColorCode);
                color = backgroundColor.getColor();
            }
        }
        return color;
    }

    public static enum ConflictResolutionMode {
        USE_LOCAL_VERSION,
        USE_MODEL_VERSION,
        ASK_USER;

    }

    private static class Memento {
        public static final String KEY = "eef.widget.text.memento";
        public final EEFTextDescription description;
        public final Object self;
        public final String referenceValue;
        public final String userInput;

        public Memento(EEFTextDescription description, Object self, String referenceValue, String userInpu) {
            this.description = description;
            this.self = self;
            this.referenceValue = referenceValue;
            this.userInput = userInpu;
        }

        public boolean appliesTo(EEFTextLifecycleManager lm) {
            return this.description == lm.description && this.self == lm.variableManager.getVariables().get("self");
        }

        public void store(Widget w) {
            w.setData(KEY, (Object)this);
        }

        public static Memento of(Widget w) {
            Object data = w.getData(KEY);
            if (data instanceof Memento) {
                return (Memento)data;
            }
            return null;
        }

        public static void remove(Widget w) {
            w.setData(KEY, null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String newLine = "\n";
            sb.append("Desc: " + EcoreUtil.getURI((EObject)this.description)).append(newLine);
            sb.append("Self: " + EcoreUtil.getURI((EObject)((EObject)this.self))).append(newLine);
            sb.append("Reference Value: " + this.referenceValue).append(newLine);
            sb.append("User Input: " + this.userInput).append(newLine);
            sb.append(newLine);
            return sb.toString();
        }
    }
}

